/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexOneValue;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;

public class OIndexUnique
extends OIndexOneValue {
    public OIndexUnique(String typeId, OIndexEngine<OIdentifiable> engine) {
        super(typeId, engine);
    }

    public OIndexOneValue put(Object key, OIdentifiable iSingleValue) {
        this.checkForRebuild();
        this.modificationLock.requestModificationLock();
        try {
            block10: {
                OIndexUnique oIndexUnique;
                this.acquireExclusiveLock();
                try {
                    this.checkForKeyType(key);
                    OIdentifiable value = (OIdentifiable)this.indexEngine.get(key);
                    if (value == null) break block10;
                    if (!value.equals(iSingleValue)) {
                        throw new ORecordDuplicatedException(String.format("Cannot index record %s: found duplicated key '%s' in index '%s' previously assigned to the record %s", null, OIndexException.class, iSingleValue.getIdentity(), key, this.getName(), value.getIdentity()), value.getIdentity());
                    }
                    oIndexUnique = this;
                }
                catch (Throwable throwable) {
                    this.releaseExclusiveLock();
                    throw throwable;
                }
                this.releaseExclusiveLock();
                return oIndexUnique;
            }
            if (!iSingleValue.getIdentity().isPersistent()) {
                iSingleValue.getRecord().save();
            }
            this.indexEngine.put(key, iSingleValue.getIdentity());
            OIndexUnique oIndexUnique = this;
            this.releaseExclusiveLock();
            return oIndexUnique;
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    @Override
    public boolean canBeUsedInEqualityOperators() {
        return true;
    }

    @Override
    public boolean supportsOrderedIterations() {
        return this.indexEngine.hasRangeQuerySupport();
    }
}

