/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class OIndexRemote<T>
implements OIndex<T> {
    private final String wrappedType;
    private final ORID rid;
    protected final String databaseName;
    protected OIndexDefinition indexDefinition;
    protected String name;
    protected ODocument configuration;
    protected Set<String> clustersToIndex;
    protected static final String QUERY_ENTRIES = "select key, rid from index:%s";
    private static final String QUERY_GET_MAJOR = "select from index:%s where key > ?";
    private static final String QUERY_GET_MAJOR_EQUALS = "select from index:%s where key >= ?";
    private static final String QUERY_GET_VALUE_MAJOR = "select EXPAND( rid ) from index:%s where key > ?";
    private static final String QUERY_GET_VALUE_MAJOR_EQUALS = "select EXPAND( rid ) from index:%s where key >= ?";
    private static final String QUERY_GET_MINOR = "select from index:%s where key < ?";
    private static final String QUERY_GET_MINOR_EQUALS = "select from index:%s where key <= ?";
    private static final String QUERY_GET_VALUE_MINOR = "select EXPAND( rid ) from index:%s where key < ?";
    private static final String QUERY_GET_VALUE_MINOR_EQUALS = "select EXPAND( rid ) from index:%s where key <= ?";
    private static final String QUERY_GET_RANGE = "select from index:%s where key between ? and ?";
    private static final String QUERY_GET_VALUES = "select EXPAND( rid ) from index:%s where key in [%s]";
    private static final String QUERY_GET_ENTRIES = "select from index:%s where key in [%s]";
    private static final String QUERY_GET_VALUE_RANGE = "select EXPAND( rid ) from index:%s where key between ? and ?";
    private static final String QUERY_PUT = "insert into index:%s (key,rid) values (?,?)";
    private static final String QUERY_REMOVE = "delete from index:%s where key = ?";
    private static final String QUERY_REMOVE2 = "delete from index:%s where key = ? and rid = ?";
    private static final String QUERY_REMOVE3 = "delete from index:%s where rid = ?";
    private static final String QUERY_CONTAINS = "select count(*) as size from index:%s where key = ?";
    private static final String QUERY_COUNT = "select count(*) as size from index:%s where key = ?";
    private static final String QUERY_COUNT_RANGE = "select count(*) as size from index:%s where ";
    private static final String QUERY_SIZE = "select count(*) as size from index:%s";
    private static final String QUERY_KEY_SIZE = "select count(distinct( key )) as size from index:%s";
    private static final String QUERY_KEYS = "select key from index:%s";
    private static final String QUERY_REBUILD = "rebuild index %s";
    private static final String QUERY_CLEAR = "delete from index:%s";
    public static final String QUERY_GET_VALUES_BEETWEN_SELECT = "select from index:%s where ";
    public static final String QUERY_GET_VALUES_BEETWEN_INCLUSIVE_FROM_CONDITION = "key >= ?";
    public static final String QUERY_GET_VALUES_BEETWEN_EXCLUSIVE_FROM_CONDITION = "key > ?";
    public static final String QUERY_GET_VALUES_BEETWEN_INCLUSIVE_TO_CONDITION = "key <= ?";
    public static final String QUERY_GET_VALUES_BEETWEN_EXCLUSIVE_TO_CONDITION = "key < ?";
    public static final String QUERY_GET_VALUES_AND_OPERATOR = " and ";
    public static final String QUERY_GET_VALUES_LIMIT = " limit ";

    public OIndexRemote(String iName, String iWrappedType, ORID iRid, OIndexDefinition iIndexDefinition, ODocument iConfiguration, Set<String> clustersToIndex) {
        this.name = iName;
        this.wrappedType = iWrappedType;
        this.rid = iRid;
        this.indexDefinition = iIndexDefinition;
        this.configuration = iConfiguration;
        this.clustersToIndex = new HashSet<String>(clustersToIndex);
        this.databaseName = ODatabaseRecordThreadLocal.INSTANCE.get().getName();
    }

    @Override
    public OIndexRemote<T> create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        this.name = name;
        return this;
    }

    @Override
    public OIndexRemote<T> delete() {
        return this;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    public Set<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo, boolean iInclusive) {
        OCommandRequest cmd = this.formatCommand(QUERY_GET_RANGE, this.name);
        return (Set)this.getDatabase().command(cmd).execute(iRangeFrom, iRangeTo);
    }

    @Override
    public Collection<OIdentifiable> getValuesBetween(Object iRangeFrom, Object iRangeTo) {
        OCommandRequest cmd = this.formatCommand(QUERY_GET_VALUE_RANGE, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(iRangeFrom, iRangeTo);
    }

    @Override
    public Collection<OIdentifiable> getValuesBetween(Object iRangeFrom, boolean iFromInclusive, Object iRangeTo, boolean iToInclusive) {
        StringBuilder query = new StringBuilder(QUERY_GET_VALUES_BEETWEN_SELECT);
        if (iFromInclusive) {
            query.append(QUERY_GET_VALUES_BEETWEN_INCLUSIVE_FROM_CONDITION);
        } else {
            query.append(QUERY_GET_VALUES_BEETWEN_EXCLUSIVE_FROM_CONDITION);
        }
        query.append(QUERY_GET_VALUES_AND_OPERATOR);
        if (iToInclusive) {
            query.append(QUERY_GET_VALUES_BEETWEN_INCLUSIVE_TO_CONDITION);
        } else {
            query.append(QUERY_GET_VALUES_BEETWEN_EXCLUSIVE_TO_CONDITION);
        }
        OCommandRequest cmd = this.formatCommand(query.toString(), new Object[0]);
        return (Collection)this.getDatabase().command(cmd).execute(iRangeFrom, iRangeTo);
    }

    @Override
    public Collection<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo) {
        OCommandRequest cmd = this.formatCommand(QUERY_GET_RANGE, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(iRangeFrom, iRangeTo);
    }

    @Override
    public Collection<OIdentifiable> getValuesMajor(Object fromKey, boolean isInclusive) {
        OCommandRequest cmd = isInclusive ? this.formatCommand(QUERY_GET_VALUE_MAJOR_EQUALS, this.name) : this.formatCommand(QUERY_GET_VALUE_MAJOR, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(fromKey);
    }

    @Override
    public Collection<ODocument> getEntriesMajor(Object fromKey, boolean isInclusive) {
        OCommandRequest cmd = isInclusive ? this.formatCommand(QUERY_GET_MAJOR_EQUALS, this.name) : this.formatCommand(QUERY_GET_MAJOR, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(fromKey);
    }

    @Override
    public Collection<OIdentifiable> getValuesMinor(Object toKey, boolean isInclusive) {
        OCommandRequest cmd = isInclusive ? this.formatCommand(QUERY_GET_VALUE_MINOR_EQUALS, this.name) : this.formatCommand(QUERY_GET_VALUE_MINOR, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(toKey);
    }

    @Override
    public Collection<ODocument> getEntriesMinor(Object toKey, boolean isInclusive) {
        OCommandRequest cmd = isInclusive ? this.formatCommand(QUERY_GET_MINOR_EQUALS, this.name) : this.formatCommand(QUERY_GET_MINOR, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(toKey);
    }

    @Override
    public boolean contains(Object iKey) {
        OCommandRequest cmd = this.formatCommand("select count(*) as size from index:%s where key = ?", this.name);
        List result = (List)this.getDatabase().command(cmd).execute(iKey);
        return (Long)((ODocument)result.get(0)).field("size") > 0L;
    }

    @Override
    public long count(Object iKey) {
        OCommandRequest cmd = this.formatCommand("select count(*) as size from index:%s where key = ?", this.name);
        List result = (List)this.getDatabase().command(cmd).execute(iKey);
        return (Long)((ODocument)result.get(0)).field("size");
    }

    @Override
    public long count(Object iRangeFrom, boolean iFromInclusive, Object iRangeTo, boolean iToInclusive, int maxValuesToFetch) {
        StringBuilder query = new StringBuilder(QUERY_COUNT_RANGE);
        if (iFromInclusive) {
            query.append(QUERY_GET_VALUES_BEETWEN_INCLUSIVE_FROM_CONDITION);
        } else {
            query.append(QUERY_GET_VALUES_BEETWEN_EXCLUSIVE_FROM_CONDITION);
        }
        query.append(QUERY_GET_VALUES_AND_OPERATOR);
        if (iToInclusive) {
            query.append(QUERY_GET_VALUES_BEETWEN_INCLUSIVE_TO_CONDITION);
        } else {
            query.append(QUERY_GET_VALUES_BEETWEN_EXCLUSIVE_TO_CONDITION);
        }
        if (maxValuesToFetch > 0) {
            query.append(QUERY_GET_VALUES_LIMIT).append(maxValuesToFetch);
        }
        OCommandRequest cmd = this.formatCommand(query.toString(), new Object[0]);
        return (Long)this.getDatabase().command(cmd).execute(iRangeFrom, iRangeTo);
    }

    @Override
    public OIndexRemote<T> put(Object iKey, OIdentifiable iValue) {
        if (iValue instanceof ORecord && !iValue.getIdentity().isValid()) {
            ((ORecord)iValue).save();
        }
        if (iValue.getIdentity().isNew()) {
            throw new OIndexException("Cannot insert values in manual indexes against remote protocol during a transaction. Temporary RID cannot be managed at server side");
        }
        OCommandRequest cmd = this.formatCommand(QUERY_PUT, this.name);
        this.getDatabase().command(cmd).execute(iKey, iValue.getIdentity());
        return this;
    }

    @Override
    public boolean remove(Object iKey) {
        OCommandRequest cmd = this.formatCommand(QUERY_REMOVE, this.name);
        return (Integer)this.getDatabase().command(cmd).execute(iKey) > 0;
    }

    @Override
    public boolean remove(Object iKey, OIdentifiable iRID) {
        int deleted;
        if (iRID != null) {
            if (iRID.getIdentity().isNew()) {
                throw new OIndexException("Cannot remove values in manual indexes against remote protocol during a transaction. Temporary RID cannot be managed at server side");
            }
            OCommandRequest cmd = this.formatCommand(QUERY_REMOVE2, this.name);
            deleted = (Integer)this.getDatabase().command(cmd).execute(iKey, iRID);
        } else {
            OCommandRequest cmd = this.formatCommand(QUERY_REMOVE, this.name);
            deleted = (Integer)this.getDatabase().command(cmd).execute(iKey);
        }
        return deleted > 0;
    }

    @Override
    public int remove(OIdentifiable iRecord) {
        OCommandRequest cmd = this.formatCommand(QUERY_REMOVE3, this.name, iRecord.getIdentity());
        return (Integer)this.getDatabase().command(cmd).execute(iRecord);
    }

    public void automaticRebuild() {
        throw new UnsupportedOperationException("autoRebuild()");
    }

    @Override
    public long rebuild() {
        OCommandRequest cmd = this.formatCommand(QUERY_REBUILD, this.name);
        return (Long)this.getDatabase().command(cmd).execute(new Object[0]);
    }

    @Override
    public OIndexRemote<T> clear() {
        OCommandRequest cmd = this.formatCommand(QUERY_CLEAR, this.name);
        this.getDatabase().command(cmd).execute(new Object[0]);
        return this;
    }

    @Override
    public Iterable<Object> keys() {
        OCommandRequest cmd = this.formatCommand(QUERY_KEYS, this.name);
        return (Iterable)this.getDatabase().command(cmd).execute(new Object[0]);
    }

    @Override
    public long getSize() {
        OCommandRequest cmd = this.formatCommand(QUERY_SIZE, this.name);
        List result = (List)this.getDatabase().command(cmd).execute(new Object[0]);
        return (Long)((ODocument)result.get(0)).field("size");
    }

    @Override
    public long getKeySize() {
        OCommandRequest cmd = this.formatCommand(QUERY_KEY_SIZE, this.name);
        List result = (List)this.getDatabase().command(cmd).execute(new Object[0]);
        return (Long)((ODocument)result.get(0)).field("size");
    }

    @Override
    public void unload() {
    }

    @Override
    public boolean isAutomatic() {
        return this.indexDefinition != null && this.indexDefinition.getClassName() != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void flush() {
    }

    @Override
    public String getType() {
        return this.wrappedType;
    }

    @Override
    public ODocument getConfiguration() {
        return this.configuration;
    }

    @Override
    public ORID getIdentity() {
        return this.rid;
    }

    protected OCommandRequest formatCommand(String iTemplate, Object ... iArgs) {
        String text = String.format(iTemplate, iArgs);
        return new OCommandSQL(text);
    }

    @Override
    public void commit(ODocument iDocument) {
    }

    @Override
    public OIndexInternal<T> getInternal() {
        return null;
    }

    protected ODatabaseComplex<ORecordInternal<?>> getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    @Override
    public long rebuild(OProgressListener iProgressListener) {
        return this.rebuild();
    }

    @Override
    public OType[] getKeyTypes() {
        if (this.indexDefinition != null) {
            return this.indexDefinition.getTypes();
        }
        return null;
    }

    @Override
    public Collection<OIdentifiable> getValues(Collection<?> iKeys) {
        StringBuilder params = new StringBuilder();
        if (!iKeys.isEmpty()) {
            params.append("?");
            int i = 1;
            while (i < iKeys.size()) {
                params.append(", ?");
                ++i;
            }
        }
        OCommandRequest cmd = this.formatCommand(QUERY_GET_VALUES, this.name, params.toString());
        return (Collection)this.getDatabase().command(cmd).execute(iKeys.toArray());
    }

    @Override
    public Collection<ODocument> getEntries(Collection<?> iKeys) {
        StringBuilder params = new StringBuilder();
        if (!iKeys.isEmpty()) {
            params.append("?");
            int i = 1;
            while (i < iKeys.size()) {
                params.append(", ?");
                ++i;
            }
        }
        OCommandRequest cmd = this.formatCommand(QUERY_GET_ENTRIES, this.name, params.toString());
        return (Collection)this.getDatabase().command(cmd).execute(iKeys.toArray());
    }

    @Override
    public OIndexDefinition getDefinition() {
        return this.indexDefinition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OIndexRemote that = (OIndexRemote)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public Collection<OIdentifiable> getValuesBetween(Object iRangeFrom, boolean iFromInclusive, Object iRangeTo, boolean iToInclusive, int maxValuesToFetch) {
        if (maxValuesToFetch < 0) {
            return this.getValuesBetween(iRangeFrom, iFromInclusive, iRangeTo, iToInclusive);
        }
        StringBuilder query = new StringBuilder(QUERY_GET_VALUES_BEETWEN_SELECT);
        if (iFromInclusive) {
            query.append(QUERY_GET_VALUES_BEETWEN_INCLUSIVE_FROM_CONDITION);
        } else {
            query.append(QUERY_GET_VALUES_BEETWEN_EXCLUSIVE_FROM_CONDITION);
        }
        query.append(QUERY_GET_VALUES_AND_OPERATOR);
        if (iToInclusive) {
            query.append(QUERY_GET_VALUES_BEETWEN_INCLUSIVE_TO_CONDITION);
        } else {
            query.append(QUERY_GET_VALUES_BEETWEN_EXCLUSIVE_TO_CONDITION);
        }
        query.append(QUERY_GET_VALUES_LIMIT).append(maxValuesToFetch);
        OCommandRequest cmd = this.formatCommand(query.toString(), new Object[0]);
        return (Collection)this.getDatabase().command(cmd).execute(iRangeFrom, iRangeTo);
    }

    @Override
    public Collection<OIdentifiable> getValuesMajor(Object fromKey, boolean isInclusive, int maxValuesToFetch) {
        if (maxValuesToFetch < 0) {
            return this.getValuesMajor(fromKey, isInclusive);
        }
        OCommandRequest cmd = isInclusive ? this.formatCommand("select EXPAND( rid ) from index:%s where key >= ? limit " + maxValuesToFetch, this.name) : this.formatCommand("select EXPAND( rid ) from index:%s where key > ? limit " + maxValuesToFetch, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(fromKey);
    }

    @Override
    public Collection<OIdentifiable> getValuesMinor(Object toKey, boolean isInclusive, int maxValuesToFetch) {
        if (maxValuesToFetch < 0) {
            return this.getValuesMinor(toKey, isInclusive);
        }
        OCommandRequest cmd = isInclusive ? this.formatCommand("select EXPAND( rid ) from index:%s where key <= ? limit " + maxValuesToFetch, this.name) : this.formatCommand("select EXPAND( rid ) from index:%s where key < ? limit " + maxValuesToFetch, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(toKey);
    }

    @Override
    public Collection<ODocument> getEntriesMajor(Object fromKey, boolean isInclusive, int maxEntriesToFetch) {
        if (maxEntriesToFetch < 0) {
            return this.getEntriesMajor(fromKey, isInclusive);
        }
        OCommandRequest cmd = isInclusive ? this.formatCommand("select from index:%s where key >= ? limit " + maxEntriesToFetch, this.name) : this.formatCommand("select from index:%s where key > ? limit " + maxEntriesToFetch, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(fromKey);
    }

    @Override
    public Collection<ODocument> getEntriesMinor(Object toKey, boolean isInclusive, int maxEntriesToFetch) {
        if (maxEntriesToFetch < 0) {
            return this.getEntriesMinor(toKey, isInclusive);
        }
        OCommandRequest cmd = isInclusive ? this.formatCommand("select from index:%s where key <= ? limit " + maxEntriesToFetch, this.name) : this.formatCommand("select from index:%s where key < ? limit " + maxEntriesToFetch, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(toKey);
    }

    @Override
    public Collection<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo, boolean iInclusive, int maxEntriesToFetch) {
        if (maxEntriesToFetch < 0) {
            return this.getEntriesBetween(iRangeFrom, iRangeTo, iInclusive);
        }
        OCommandRequest cmd = this.formatCommand("select from index:%s where key between ? and ? limit " + maxEntriesToFetch, this.name);
        return (Set)this.getDatabase().command(cmd).execute(iRangeFrom, iRangeTo);
    }

    @Override
    public Collection<OIdentifiable> getValues(Collection<?> iKeys, int maxValuesToFetch) {
        if (maxValuesToFetch < 0) {
            return this.getValues(iKeys);
        }
        StringBuilder params = new StringBuilder();
        if (!iKeys.isEmpty()) {
            params.append("?");
            int i = 1;
            while (i < iKeys.size()) {
                params.append(", ?");
                ++i;
            }
        }
        OCommandRequest cmd = this.formatCommand("select EXPAND( rid ) from index:%s where key in [%s] limit " + maxValuesToFetch, this.name, params.toString());
        return (Collection)this.getDatabase().command(cmd).execute(iKeys.toArray());
    }

    @Override
    public Collection<ODocument> getEntries(Collection<?> iKeys, int maxEntriesToFetch) {
        if (maxEntriesToFetch < 0) {
            return this.getEntries(iKeys);
        }
        StringBuilder params = new StringBuilder();
        if (!iKeys.isEmpty()) {
            params.append("?");
            int i = 1;
            while (i < iKeys.size()) {
                params.append(", ?");
                ++i;
            }
        }
        OCommandRequest cmd = this.formatCommand("select from index:%s where key in [%s] limit " + maxEntriesToFetch, this.name, params.toString());
        return (Collection)this.getDatabase().command(cmd).execute(iKeys.toArray());
    }

    @Override
    public Set<String> getClusters() {
        return Collections.unmodifiableSet(this.clustersToIndex);
    }

    @Override
    public void checkEntry(OIdentifiable iRecord, Object iKey) {
    }

    @Override
    public boolean isRebuiding() {
        return false;
    }
}

