/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.common.concur.resource.OSharedResourceIterator;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.ODocumentFieldsHashSet;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerRID;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class OIndexOneValue
extends OIndexAbstract<OIdentifiable> {
    public OIndexOneValue(String iType, OIndexEngine<OIdentifiable> engine) {
        super(iType, engine);
    }

    @Override
    public OIdentifiable get(Object iKey) {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            OIdentifiable oIdentifiable = (OIdentifiable)this.indexEngine.get(iKey);
            return oIdentifiable;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long count(Object key) {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            long l = this.indexEngine.contains(key) ? 1 : 0;
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void checkEntry(OIdentifiable iRecord, Object key) {
        this.checkForRebuild();
        OIdentifiable indexedRID = this.get(key);
        if (indexedRID != null && !indexedRID.getIdentity().equals(iRecord.getIdentity())) {
            OTransactionIndexChangesPerKey keyChanges;
            OTransactionIndexChanges indexChanges = ODatabaseRecordThreadLocal.INSTANCE.get().getTransaction().getIndexChanges(this.getName());
            if (indexChanges != null && (keyChanges = indexChanges.getChangesPerKey(key)) != null) {
                for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : keyChanges.entries) {
                    if (entry.operation != OTransactionIndexChanges.OPERATION.REMOVE) continue;
                    return;
                }
            }
            OLogManager.instance().exception("Cannot index record %s: found duplicated key '%s' in index '%s' previously assigned to the record %s", null, OIndexException.class, new Object[]{key, iRecord, indexedRID});
        }
    }

    public OIndexOneValue create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        return (OIndexOneValue)super.create(name, indexDefinition, clusterIndexName, clustersToIndex, rebuild, progressListener, OStreamSerializerRID.INSTANCE);
    }

    @Override
    public Collection<OIdentifiable> getValuesBetween(Object iRangeFrom, boolean iFromInclusive, Object iRangeTo, boolean iToInclusive, int maxValuesToFetch) {
        this.checkForRebuild();
        if (iRangeFrom.getClass() != iRangeTo.getClass()) {
            throw new IllegalArgumentException("Range from-to parameters are of different types");
        }
        this.acquireSharedLock();
        try {
            Collection<OIdentifiable> collection = this.indexEngine.getValuesBetween(iRangeFrom, iFromInclusive, iRangeTo, iToInclusive, maxValuesToFetch, null);
            return collection;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Collection<OIdentifiable> getValuesMajor(Object fromKey, boolean isInclusive, int maxValuesToFetch) {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            Collection<OIdentifiable> collection = this.indexEngine.getValuesMajor(fromKey, isInclusive, maxValuesToFetch, null);
            return collection;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Collection<OIdentifiable> getValuesMinor(Object toKey, boolean isInclusive, int maxValuesToFetch) {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            Collection<OIdentifiable> collection = this.indexEngine.getValuesMinor(toKey, isInclusive, maxValuesToFetch, null);
            return collection;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Collection<OIdentifiable> getValues(Collection<?> keys, int maxValuesToSearch) {
        this.checkForRebuild();
        ArrayList sortedKeys = new ArrayList(keys);
        Collections.sort(sortedKeys, ODefaultComparator.INSTANCE);
        this.acquireSharedLock();
        HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
        try {
            for (Object key : sortedKeys) {
                if (maxValuesToSearch > -1 && result.size() == maxValuesToSearch) {
                    HashSet<OIdentifiable> hashSet = result;
                    return hashSet;
                }
                OIdentifiable val = (OIdentifiable)this.indexEngine.get(key);
                if (val == null) continue;
                result.add(val);
            }
            HashSet<OIdentifiable> hashSet = result;
            return hashSet;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Collection<ODocument> getEntriesMajor(Object fromKey, boolean isInclusive, int maxEntriesToFetch) {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            Collection<ODocument> collection = this.indexEngine.getEntriesMajor(fromKey, isInclusive, maxEntriesToFetch, null);
            return collection;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Collection<ODocument> getEntriesMinor(Object toKey, boolean isInclusive, int maxEntriesToFetch) {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            Collection<ODocument> collection = this.indexEngine.getEntriesMinor(toKey, isInclusive, maxEntriesToFetch, null);
            return collection;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Collection<ODocument> getEntriesBetween(Object rangeFrom, Object rangeTo, boolean inclusive, int maxEntriesToFetch) {
        this.checkForRebuild();
        if (rangeFrom.getClass() != rangeTo.getClass()) {
            throw new IllegalArgumentException("Range from-to parameters are of different types");
        }
        this.acquireSharedLock();
        try {
            Collection<ODocument> collection = this.indexEngine.getEntriesBetween(rangeFrom, rangeTo, inclusive, maxEntriesToFetch, null);
            return collection;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Collection<ODocument> getEntries(Collection<?> keys, int maxEntriesToFetch) {
        this.checkForRebuild();
        ArrayList sortedKeys = new ArrayList(keys);
        Collections.sort(sortedKeys, ODefaultComparator.INSTANCE);
        this.acquireSharedLock();
        ODocumentFieldsHashSet result = new ODocumentFieldsHashSet();
        try {
            for (Object key : sortedKeys) {
                if (maxEntriesToFetch > -1 && result.size() == maxEntriesToFetch) {
                    ODocumentFieldsHashSet oDocumentFieldsHashSet = result;
                    return oDocumentFieldsHashSet;
                }
                OIdentifiable val = (OIdentifiable)this.indexEngine.get(key);
                if (val == null) continue;
                ODocument document = new ODocument();
                document.field("key", key);
                document.field("rid", val.getIdentity());
                document.unsetDirty();
                result.add(document);
            }
            ODocumentFieldsHashSet oDocumentFieldsHashSet = result;
            return oDocumentFieldsHashSet;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long getSize() {
        this.checkForRebuild();
        this.acquireExclusiveLock();
        try {
            long l = this.indexEngine.size(null);
            return l;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public long count(Object iRangeFrom, boolean iFromInclusive, Object iRangeTo, boolean iToInclusive, int maxValuesToFetch) {
        this.checkForRebuild();
        if (iRangeFrom != null && iRangeTo != null && iRangeFrom.getClass() != iRangeTo.getClass()) {
            throw new IllegalArgumentException("Range from-to parameters are of different types");
        }
        this.acquireSharedLock();
        try {
            long l = this.indexEngine.count(iRangeFrom, iFromInclusive, iRangeTo, iToInclusive, maxValuesToFetch, null);
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long getKeySize() {
        this.checkForRebuild();
        this.acquireExclusiveLock();
        try {
            long l = this.indexEngine.size(null);
            return l;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Iterator<OIdentifiable> valuesIterator() {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            OSharedResourceIterator oSharedResourceIterator = new OSharedResourceIterator((OSharedResourceAdaptiveExternal)this, this.indexEngine.valuesIterator());
            return oSharedResourceIterator;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Iterator<OIdentifiable> valuesInverseIterator() {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            OSharedResourceIterator oSharedResourceIterator = new OSharedResourceIterator((OSharedResourceAdaptiveExternal)this, this.indexEngine.inverseValuesIterator());
            return oSharedResourceIterator;
        }
        finally {
            this.releaseSharedLock();
        }
    }
}

