/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OMultiKey;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordTrackedSet;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.index.OIndexRebuildOutputListener;
import com.orientechnologies.orient.core.index.OIndexes;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OIndexManagerShared
extends OIndexManagerAbstract
implements OIndexManager {
    private static final long serialVersionUID = 1L;
    protected volatile Thread recreateIndexesThread = null;
    private volatile boolean rebuildCompleted = false;

    public OIndexManagerShared(ODatabaseRecord iDatabase) {
        super(iDatabase);
    }

    public OIndex<?> getIndexInternal(String name) {
        this.acquireSharedLock();
        try {
            OIndex oIndex = (OIndex)this.indexes.get(name.toLowerCase());
            return oIndex;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndex<?> createIndex(String iName, String iType, OIndexDefinition indexDefinition, int[] clusterIdsToIndex, OProgressListener iProgressListener) {
        if (this.getDatabase().getTransaction().isActive()) {
            throw new IllegalStateException("Cannot create a new index inside a transaction");
        }
        Character c = OSchemaShared.checkNameIfValid(iName);
        if (c != null) {
            throw new IllegalArgumentException("Invalid index name '" + iName + "'. Character '" + c + "' is invalid");
        }
        this.acquireExclusiveLock();
        try {
            String clusterName;
            OIndexInternal<?> index = OIndexes.createIndex(this.getDatabase(), iType);
            String string = clusterName = indexDefinition != null && indexDefinition.getClassName() != null ? this.defaultClusterName : this.manualClusterName;
            if (iProgressListener == null) {
                iProgressListener = new OIndexRebuildOutputListener(index);
            }
            HashSet<String> clustersToIndex = new HashSet<String>();
            ODatabaseRecord database = this.getDatabase();
            if (clusterIdsToIndex != null) {
                int[] nArray = clusterIdsToIndex;
                int n = clusterIdsToIndex.length;
                int n2 = 0;
                while (n2 < n) {
                    int clusterId = nArray[n2];
                    String clusterNameToIndex = database.getClusterNameById(clusterId);
                    if (clusterNameToIndex == null) {
                        throw new OIndexException("Cluster with id " + clusterId + " does not exist.");
                    }
                    clustersToIndex.add(clusterNameToIndex);
                    ++n2;
                }
            }
            index.create(iName, indexDefinition, clusterName, clustersToIndex, true, iProgressListener);
            this.addIndexInternal(index);
            this.setDirty();
            this.save();
            OIndexInternal<?> oIndexInternal = index;
            return oIndexInternal;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public OIndexManager dropIndex(String iIndexName) {
        if (this.getDatabase().getTransaction().isActive()) {
            throw new IllegalStateException("Cannot drop an index inside a transaction");
        }
        this.acquireExclusiveLock();
        try {
            OIndex idx = (OIndex)this.indexes.remove(iIndexName.toLowerCase());
            if (idx != null) {
                this.removeClassPropertyIndex(idx);
                this.getDatabase().unregisterListener(idx.getInternal());
                idx.delete();
                this.setDirty();
                this.save();
            }
            OIndexManagerShared oIndexManagerShared = this;
            return oIndexManagerShared;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private void removeClassPropertyIndex(OIndex<?> idx) {
        OIndexDefinition indexDefinition = idx.getDefinition();
        if (indexDefinition == null || indexDefinition.getClassName() == null) {
            return;
        }
        Map map = (Map)this.classPropertyIndex.get(indexDefinition.getClassName().toLowerCase());
        if (map == null) {
            return;
        }
        int paramCount = indexDefinition.getParamCount();
        int i = 1;
        while (i <= paramCount) {
            List<String> fields = this.normalizeFieldNames(indexDefinition.getFields().subList(0, i));
            OMultiKey multiKey = new OMultiKey(fields);
            Set indexSet = (Set)map.get(multiKey);
            if (indexSet != null) {
                indexSet.remove(idx);
                if (indexSet.isEmpty()) {
                    map.remove(multiKey);
                }
            }
            ++i;
        }
        if (map.isEmpty()) {
            this.classPropertyIndex.remove(indexDefinition.getClassName().toLowerCase());
        }
    }

    @Override
    protected void fromStream() {
        this.acquireExclusiveLock();
        try {
            HashMap oldIndexes = new HashMap(this.indexes);
            this.clearMetadata();
            Collection idxs = (Collection)this.document.field("indexes");
            if (idxs != null) {
                boolean configUpdated = false;
                Iterator indexConfigurationIterator = idxs.iterator();
                while (indexConfigurationIterator.hasNext()) {
                    ODocument d = (ODocument)indexConfigurationIterator.next();
                    try {
                        OIndexInternal<?> index = OIndexes.createIndex(this.getDatabase(), (String)d.field("type"));
                        OIndexInternal.IndexMetadata newIndexMetadata = index.loadMetadata(d);
                        String normalizedName = newIndexMetadata.getName().toLowerCase();
                        OIndex oldIndex = (OIndex)oldIndexes.get(normalizedName);
                        if (oldIndex != null) {
                            OIndexInternal.IndexMetadata oldIndexMetadata = oldIndex.getInternal().loadMetadata(oldIndex.getConfiguration());
                            if (oldIndexMetadata.equals(newIndexMetadata)) {
                                this.addIndexInternal(oldIndex.getInternal());
                                oldIndexes.remove(normalizedName);
                                continue;
                            }
                            if (newIndexMetadata.getIndexDefinition() != null || !d.field("mapRid").equals(oldIndex.getConfiguration().field("mapRid"))) continue;
                            this.addIndexInternal(oldIndex.getInternal());
                            oldIndexes.remove(normalizedName);
                            continue;
                        }
                        if (index.loadFromConfiguration(d)) {
                            this.addIndexInternal(index);
                            continue;
                        }
                        indexConfigurationIterator.remove();
                        configUpdated = true;
                    }
                    catch (Exception e) {
                        indexConfigurationIterator.remove();
                        configUpdated = true;
                        OLogManager.instance().error((Object)this, "Error on loading index by configuration: %s", (Throwable)e, new Object[]{d});
                    }
                }
                for (OIndex oldIndex : oldIndexes.values()) {
                    try {
                        OLogManager.instance().warn((Object)this, "Index %s was not found after reload and will be removed", new Object[]{oldIndex.getName()});
                        this.getDatabase().unregisterListener(oldIndex.getInternal());
                        oldIndex.delete();
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Error on deletion of index %s", (Throwable)e, new Object[]{oldIndex.getName()});
                    }
                }
                if (configUpdated) {
                    this.document.field("indexes", idxs);
                    this.save();
                }
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public ODocument toStream() {
        this.acquireExclusiveLock();
        try {
            this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
            try {
                ORecordTrackedSet idxs = new ORecordTrackedSet(this.document);
                for (OIndex i : this.indexes.values()) {
                    idxs.add(((OIndexInternal)i).updateConfiguration());
                }
                this.document.field("indexes", idxs, OType.EMBEDDEDSET);
            }
            finally {
                this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
            }
            this.document.setDirty();
            ODocument oDocument = this.document;
            return oDocument;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void recreateIndexes() {
        this.acquireExclusiveLock();
        try {
            if (this.recreateIndexesThread != null && this.recreateIndexesThread.isAlive()) {
                return;
            }
            ODatabaseRecord db = this.getDatabase();
            this.document = (ODocument)db.load(new ORecordId(this.getDatabase().getStorage().getConfiguration().indexMgrRecordId));
            final ODocument doc = new ODocument();
            this.document.copyTo(doc);
            final ODatabaseDocumentTx newDb = new ODatabaseDocumentTx(db.getURL());
            Runnable recreateIndexesTask = new Runnable(){

                @Override
                public void run() {
                    try {
                        newDb.setProperty(ODatabase.OPTIONS.SECURITY.toString(), Boolean.FALSE);
                        newDb.open("admin", "nopass");
                        ODatabaseRecordThreadLocal.INSTANCE.set(newDb);
                        try {
                            int clusterId;
                            int dataId = newDb.getStorage().getDataSegmentIdByName("index");
                            if (dataId > -1) {
                                newDb.getStorage().dropDataSegment("index");
                            }
                            if ((clusterId = newDb.getStorage().getClusterIdByName("index")) > -1) {
                                newDb.dropCluster(clusterId, false);
                            }
                            newDb.addDataSegment("index", null);
                            newDb.getStorage().addCluster("PHYSICAL", "index", null, "index", true, new Object[0]);
                        }
                        catch (IllegalArgumentException ex) {
                            OLogManager.instance().info((Object)this, "Creating 'index' data-segment to store all the index content...", new Object[0]);
                            newDb.addDataSegment("index", null);
                            OCluster indexCluster = newDb.getStorage().getClusterById(newDb.getStorage().getClusterIdByName("index"));
                            try {
                                indexCluster.set(OCluster.ATTRIBUTES.DATASEGMENT, "index");
                                OLogManager.instance().info((Object)this, "Data-segment 'index' create correctly. Indexes will store content into this data-segment", new Object[0]);
                            }
                            catch (IOException e) {
                                OLogManager.instance().error((Object)this, "Error changing data segment for cluster 'index'", (Throwable)e, new Object[0]);
                            }
                        }
                        Collection idxs = (Collection)doc.field("indexes");
                        if (idxs == null) {
                            OLogManager.instance().warn((Object)this, "List of indexes is empty.", new Object[0]);
                            return;
                        }
                        int ok = 0;
                        int errors = 0;
                        for (ODocument idx : idxs) {
                            try {
                                String indexType = (String)idx.field("type");
                                if (indexType == null) {
                                    OLogManager.instance().error((Object)this, "Index type is null, will process other record.", new Object[0]);
                                    ++errors;
                                    continue;
                                }
                                OIndexInternal<?> index = OIndexes.createIndex(newDb, indexType);
                                OIndexInternal.IndexMetadata indexMetadata = index.loadMetadata(idx);
                                OIndexDefinition indexDefinition = indexMetadata.getIndexDefinition();
                                if (indexDefinition == null || !indexDefinition.isAutomatic()) {
                                    OLogManager.instance().info((Object)this, "Index %s is not automatic index and will be added as is.", new Object[]{indexMetadata.getName()});
                                    if (index.loadFromConfiguration(idx)) {
                                        OIndexManagerShared.this.addIndexInternal(index);
                                        OIndexManagerShared.this.setDirty();
                                        OIndexManagerShared.this.save();
                                        ++ok;
                                    } else {
                                        OIndexManagerShared.this.getDatabase().unregisterListener(index.getInternal());
                                        index.delete();
                                        ++errors;
                                    }
                                    OLogManager.instance().info((Object)this, "Index %s was added in DB index list.", new Object[]{index.getName()});
                                    continue;
                                }
                                String indexName = indexMetadata.getName();
                                Set<String> clusters = indexMetadata.getClustersToIndex();
                                String type = indexMetadata.getType();
                                if (indexName != null && indexDefinition != null && clusters != null && !clusters.isEmpty() && type != null) {
                                    OLogManager.instance().info((Object)this, "Start creation of index %s", new Object[]{indexName});
                                    index.create(indexName, indexDefinition, OIndexManagerShared.this.defaultClusterName, clusters, false, new OIndexRebuildOutputListener(index));
                                    index.setRebuildingFlag();
                                    OIndexManagerShared.this.addIndexInternal(index);
                                    OLogManager.instance().info((Object)this, "Index %s was successfully created and rebuild is going to be started.", new Object[]{indexName});
                                    index.rebuild(new OIndexRebuildOutputListener(index));
                                    index.flush();
                                    OIndexManagerShared.this.setDirty();
                                    OIndexManagerShared.this.save();
                                    ++ok;
                                    OLogManager.instance().info((Object)this, "Rebuild of %s index was successfully finished.", new Object[]{indexName});
                                    continue;
                                }
                                ++errors;
                                OLogManager.instance().error((Object)this, "Information about index was restored incorrectly, following data were loaded : index name - %s, index definition %s, clusters %s, type %s.", new Object[]{indexName, indexDefinition, clusters, type});
                            }
                            catch (Exception e) {
                                OLogManager.instance().error((Object)this, "Error during addition of index %s", new Object[]{idx});
                                ++errors;
                            }
                        }
                        OIndexManagerShared.this.rebuildCompleted = true;
                        newDb.close();
                        OLogManager.instance().info((Object)this, "%d indexes were restored successfully, %d errors", new Object[]{ok, errors});
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Error when attempt to restore indexes after crash was performed.", new Object[0]);
                    }
                }
            };
            this.recreateIndexesThread = new Thread(recreateIndexesTask);
            this.recreateIndexesThread.start();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void waitTillIndexRestore() {
        if (this.recreateIndexesThread != null && this.recreateIndexesThread.isAlive()) {
            if (Thread.currentThread().equals(this.recreateIndexesThread)) {
                return;
            }
            OLogManager.instance().info((Object)this, "Wait till indexes restore after crash was finished.", new Object[0]);
            while (this.recreateIndexesThread.isAlive()) {
                try {
                    this.recreateIndexesThread.join();
                    OLogManager.instance().info((Object)this, "Indexes restore after crash was finished.", new Object[0]);
                }
                catch (InterruptedException e) {
                    OLogManager.instance().info((Object)this, "Index rebuild task was interrupted.", new Object[0]);
                }
            }
        }
    }

    @Override
    public boolean autoRecreateIndexesAfterCrash() {
        if (this.rebuildCompleted) {
            return false;
        }
        ODatabaseRecord database = ODatabaseRecordThreadLocal.INSTANCE.get();
        if (!OGlobalConfiguration.INDEX_AUTO_REBUILD_AFTER_NOTSOFTCLOSE.getValueAsBoolean()) {
            return false;
        }
        OStorage storage = database.getStorage();
        if (storage instanceof OStorageLocal) {
            return !((OStorageLocal)storage).wasClusterSoftlyClosed("index");
        }
        if (storage instanceof OLocalPaginatedStorage) {
            return ((OLocalPaginatedStorage)storage).wereDataRestoredAfterOpen();
        }
        return false;
    }
}

