/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Map;
import java.util.Set;

public interface OIndexInternal<T>
extends OIndex<T>,
Iterable<Map.Entry<Object, T>>,
ODatabaseListener {
    public static final String CONFIG_KEYTYPE = "keyType";
    public static final String CONFIG_AUTOMATIC = "automatic";
    public static final String CONFIG_TYPE = "type";
    public static final String CONFIG_NAME = "name";
    public static final String INDEX_DEFINITION = "indexDefinition";
    public static final String INDEX_DEFINITION_CLASS = "indexDefinitionClass";

    public boolean loadFromConfiguration(ODocument var1);

    public ODocument updateConfiguration();

    public OIndex<T> addCluster(String var1);

    public OIndex<T> removeCluster(String var1);

    public boolean canBeUsedInEqualityOperators();

    public boolean hasRangeQuerySupport();

    public void freeze(boolean var1);

    public void release();

    public void acquireModificationLock();

    public void releaseModificationLock();

    public IndexMetadata loadMetadata(ODocument var1);

    public void setRebuildingFlag();

    public void close();

    public static final class IndexMetadata {
        private final String name;
        private final OIndexDefinition indexDefinition;
        private final Set<String> clustersToIndex;
        private final String type;

        public IndexMetadata(String name, OIndexDefinition indexDefinition, Set<String> clustersToIndex, String type) {
            this.name = name;
            this.indexDefinition = indexDefinition;
            this.clustersToIndex = clustersToIndex;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public OIndexDefinition getIndexDefinition() {
            return this.indexDefinition;
        }

        public Set<String> getClustersToIndex() {
            return this.clustersToIndex;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexMetadata that = (IndexMetadata)o;
            if (!this.clustersToIndex.equals(that.clustersToIndex)) {
                return false;
            }
            if (this.indexDefinition != null ? !this.indexDefinition.equals(that.indexDefinition) : that.indexDefinition != null) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
            return this.type.equals(that.type);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.indexDefinition != null ? this.indexDefinition.hashCode() : 0);
            result = 31 * result + this.clustersToIndex.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }
    }
}

