/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexMultiValues;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OIndexFullText
extends OIndexMultiValues {
    private static final String CONFIG_STOP_WORDS = "stopWords";
    private static final String CONFIG_SEPARATOR_CHARS = "separatorChars";
    private static final String CONFIG_IGNORE_CHARS = "ignoreChars";
    private static String DEF_SEPARATOR_CHARS = " \r\n\t:;,.|+*/\\=!?[]()";
    private static String DEF_IGNORE_CHARS = "'\"";
    private static String DEF_STOP_WORDS = "the in a at as and or for his her him this that what which while up with be was is";
    private final String separatorChars = DEF_SEPARATOR_CHARS;
    private final String ignoreChars = DEF_IGNORE_CHARS;
    private final Set<String> stopWords = new HashSet<String>(OStringSerializerHelper.split(DEF_STOP_WORDS, ' ', new char[0]));

    public OIndexFullText(String typeId, OIndexEngine<Set<OIdentifiable>> indexEngine) {
        super(typeId, indexEngine);
    }

    @Override
    public OIndexFullText put(Object key, OIdentifiable iSingleValue) {
        this.checkForRebuild();
        if (key == null) {
            return this;
        }
        this.modificationLock.requestModificationLock();
        try {
            List<String> words = this.splitIntoWords(key.toString());
            for (String word : words) {
                this.acquireExclusiveLock();
                try {
                    Set refs = (Set)this.indexEngine.get(word);
                    if (refs == null) {
                        refs = new OMVRBTreeRIDSet();
                        ((OMVRBTreeRIDSet)refs).setAutoConvertToRecord(false);
                    }
                    refs.add(iSingleValue);
                    this.indexEngine.put(word, refs);
                }
                finally {
                    this.releaseExclusiveLock();
                }
            }
            OIndexFullText oIndexFullText = this;
            return oIndexFullText;
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    @Override
    public boolean remove(Object key, OIdentifiable value) {
        this.checkForRebuild();
        this.modificationLock.requestModificationLock();
        try {
            List<String> words = this.splitIntoWords(key.toString());
            boolean removed = false;
            for (String word : words) {
                this.acquireExclusiveLock();
                try {
                    Set recs = (Set)this.indexEngine.get(word);
                    if (recs == null || recs.isEmpty() || !recs.remove(value)) continue;
                    if (recs.isEmpty()) {
                        this.indexEngine.remove(word);
                    } else {
                        this.indexEngine.put(word, recs);
                    }
                    removed = true;
                }
                finally {
                    this.releaseExclusiveLock();
                }
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    @Override
    public OIndexInternal<?> create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener, OStreamSerializer valueSerializer) {
        if (indexDefinition.getFields().size() > 1) {
            throw new OIndexException(String.valueOf(this.type) + " indexes cannot be used as composite ones.");
        }
        return super.create(name, indexDefinition, clusterIndexName, clustersToIndex, rebuild, progressListener, valueSerializer);
    }

    @Override
    public OIndexMultiValues create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        if (indexDefinition.getFields().size() > 1) {
            throw new OIndexException(String.valueOf(this.type) + " indexes cannot be used as composite ones.");
        }
        return super.create(name, indexDefinition, clusterIndexName, (Set)clustersToIndex, rebuild, progressListener);
    }

    @Override
    public ODocument updateConfiguration() {
        super.updateConfiguration();
        this.configuration.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        try {
            this.configuration.field(CONFIG_SEPARATOR_CHARS, this.separatorChars);
            this.configuration.field(CONFIG_IGNORE_CHARS, this.ignoreChars);
            this.configuration.field(CONFIG_STOP_WORDS, this.stopWords);
        }
        finally {
            this.configuration.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
        return this.configuration;
    }

    private List<String> splitIntoWords(String iKey) {
        ArrayList<String> result = new ArrayList<String>();
        List words = (List)OStringSerializerHelper.split(new ArrayList<String>(), iKey, 0, -1, this.separatorChars, new char[0]);
        StringBuilder buffer = new StringBuilder();
        for (String word : words) {
            buffer.setLength(0);
            int i = 0;
            while (i < word.length()) {
                char c = word.charAt(i);
                boolean ignore = false;
                int k = 0;
                while (k < this.ignoreChars.length()) {
                    if (c == this.ignoreChars.charAt(k)) {
                        ignore = true;
                        break;
                    }
                    ++k;
                }
                if (!ignore) {
                    buffer.append(c);
                }
                ++i;
            }
            word = buffer.toString();
            if (this.stopWords.contains(word)) continue;
            result.add(word);
        }
        return result;
    }

    @Override
    public boolean canBeUsedInEqualityOperators() {
        return false;
    }

    @Override
    public boolean supportsOrderedIterations() {
        return false;
    }
}

