/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.collection.OCompositeKey;
import com.orientechnologies.common.concur.lock.OModificationLock;
import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.annotation.ODocumentInstance;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexRebuildOutputListener;
import com.orientechnologies.orient.core.index.OPropertyIndexDefinition;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerAnyStreamable;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class OIndexAbstract<T>
extends OSharedResourceAdaptiveExternal
implements OIndexInternal<T> {
    protected final OModificationLock modificationLock = new OModificationLock();
    protected static final String CONFIG_MAP_RID = "mapRid";
    protected static final String CONFIG_CLUSTERS = "clusters";
    protected String name;
    protected String type;
    protected final OIndexEngine<T> indexEngine;
    protected Set<String> clustersToIndex = new HashSet<String>();
    protected OIndexDefinition indexDefinition;
    protected final String databaseName;
    @ODocumentInstance
    protected ODocument configuration;
    private volatile boolean rebuilding = false;
    private Thread rebuildThread = null;

    public OIndexAbstract(String type, OIndexEngine<T> indexEngine) {
        super(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), OGlobalConfiguration.MVRBTREE_TIMEOUT.getValueAsInteger(), true);
        this.acquireExclusiveLock();
        try {
            this.databaseName = ODatabaseRecordThreadLocal.INSTANCE.get().getName();
            this.type = type;
            this.indexEngine = indexEngine;
            indexEngine.init();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void flush() {
        this.acquireSharedLock();
        try {
            this.indexEngine.flush();
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public boolean hasRangeQuerySupport() {
        this.acquireSharedLock();
        try {
            boolean bl = this.indexEngine.hasRangeQuerySupport();
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public OIndexInternal<?> create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener, OStreamSerializer valueSerializer) {
        this.acquireExclusiveLock();
        try {
            try {
                this.name = name;
                this.configuration = new ODocument();
                this.indexDefinition = indexDefinition;
                this.clustersToIndex = clustersToIndex != null ? new HashSet<String>(clustersToIndex) : new HashSet<String>(clustersToIndex);
                this.indexEngine.create(this.name, indexDefinition, clusterIndexName, valueSerializer, this.isAutomatic());
                if (rebuild) {
                    this.rebuild(progressListener);
                }
                this.updateConfiguration();
            }
            catch (Exception e) {
                this.indexEngine.delete();
                if (e instanceof OIndexException) {
                    throw (OIndexException)((Object)e);
                }
                throw new OIndexException("Cannot create the index '" + name + "'", e);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
        return this;
    }

    @Override
    public boolean loadFromConfiguration(ODocument config) {
        this.acquireExclusiveLock();
        try {
            block8: {
                this.configuration = config;
                this.clustersToIndex.clear();
                OIndexInternal.IndexMetadata indexMetadata = this.loadMetadata(this.configuration);
                this.name = indexMetadata.getName();
                this.indexDefinition = indexMetadata.getIndexDefinition();
                this.clustersToIndex.addAll(indexMetadata.getClustersToIndex());
                ORID rid = (ORID)config.field(CONFIG_MAP_RID, ORID.class);
                try {
                    this.indexEngine.load(rid, this.name, this.isAutomatic());
                }
                catch (Exception e) {
                    if (!this.onCorruptionRepairDatabase(null, "load", "Index will be rebuilt")) break block8;
                    if (this.isAutomatic() && this.getDatabase().getStorage() instanceof OStorageEmbedded) {
                        OLogManager.instance().warn((Object)this, "Cannot load index '%s' from storage (rid=%s): rebuilt it from scratch", new Object[]{this.getName(), rid});
                    }
                    try {
                        this.rebuild();
                    }
                    catch (Throwable t) {
                        OLogManager.instance().error((Object)this, "Cannot rebuild index '%s' from storage (rid=%s) because '" + t + "'. The index will be removed in configuration", new Object[]{this.getName(), rid});
                        this.releaseExclusiveLock();
                        return false;
                    }
                }
            }
            return true;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public OIndexInternal.IndexMetadata loadMetadata(ODocument config) {
        String indexName = (String)config.field("name");
        ODocument indexDefinitionDoc = (ODocument)config.field("indexDefinition");
        OIndexDefinition loadedIndexDefinition = null;
        if (indexDefinitionDoc != null) {
            try {
                String indexDefClassName = (String)config.field("indexDefinitionClass");
                Class<?> indexDefClass = Class.forName(indexDefClassName);
                loadedIndexDefinition = (OIndexDefinition)indexDefClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                loadedIndexDefinition.fromStream(indexDefinitionDoc);
            }
            catch (ClassNotFoundException e) {
                throw new OIndexException("Error during deserialization of index definition", e);
            }
            catch (NoSuchMethodException e) {
                throw new OIndexException("Error during deserialization of index definition", e);
            }
            catch (InvocationTargetException e) {
                throw new OIndexException("Error during deserialization of index definition", e);
            }
            catch (InstantiationException e) {
                throw new OIndexException("Error during deserialization of index definition", e);
            }
            catch (IllegalAccessException e) {
                throw new OIndexException("Error during deserialization of index definition", e);
            }
        } else {
            Boolean isAutomatic = (Boolean)config.field("automatic");
            if (Boolean.TRUE.equals(isAutomatic)) {
                int pos = indexName.lastIndexOf(46);
                if (pos < 0) {
                    throw new OIndexException("Can not convert from old index model to new one. Invalid index name. Dot (.) separator should be present.");
                }
                String className = indexName.substring(0, pos);
                String propertyName = indexName.substring(pos + 1);
                String keyTypeStr = (String)config.field("keyType");
                if (keyTypeStr == null) {
                    throw new OIndexException("Can not convert from old index model to new one. Index key type is absent.");
                }
                OType keyType = OType.valueOf(keyTypeStr.toUpperCase(Locale.ENGLISH));
                loadedIndexDefinition = new OPropertyIndexDefinition(className, propertyName, keyType);
                config.removeField("automatic");
                config.removeField("keyType");
            } else if (config.field("keyType") != null) {
                String keyTypeStr = (String)config.field("keyType");
                OType keyType = OType.valueOf(keyTypeStr.toUpperCase(Locale.ENGLISH));
                loadedIndexDefinition = new OSimpleKeyIndexDefinition(keyType);
                config.removeField("keyType");
            }
        }
        HashSet<String> clusters = new HashSet<String>((Collection)config.field(CONFIG_CLUSTERS));
        return new OIndexInternal.IndexMetadata(indexName, loadedIndexDefinition, clusters, this.type);
    }

    @Override
    public boolean contains(Object key) {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            boolean bl = this.indexEngine.contains(key);
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Collection<OIdentifiable> getValuesBetween(Object iRangeFrom, Object iRangeTo) {
        this.checkForRebuild();
        return this.getValuesBetween(iRangeFrom, true, iRangeTo, true);
    }

    @Override
    public Collection<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo) {
        this.checkForRebuild();
        return this.getEntriesBetween(iRangeFrom, iRangeTo, true);
    }

    @Override
    public Collection<OIdentifiable> getValuesMajor(Object fromKey, boolean isInclusive) {
        this.checkForRebuild();
        return this.getValuesMajor(fromKey, isInclusive, -1);
    }

    @Override
    public Collection<OIdentifiable> getValuesMinor(Object toKey, boolean isInclusive) {
        this.checkForRebuild();
        return this.getValuesMinor(toKey, isInclusive, -1);
    }

    @Override
    public Collection<ODocument> getEntriesMajor(Object fromKey, boolean isInclusive) {
        this.checkForRebuild();
        return this.getEntriesMajor(fromKey, isInclusive, -1);
    }

    @Override
    public Collection<ODocument> getEntriesMinor(Object toKey, boolean isInclusive) {
        this.checkForRebuild();
        return this.getEntriesMinor(toKey, isInclusive, -1);
    }

    @Override
    public Collection<OIdentifiable> getValuesBetween(Object iRangeFrom, boolean iFromInclusive, Object iRangeTo, boolean iToInclusive) {
        this.checkForRebuild();
        return this.getValuesBetween(iRangeFrom, iFromInclusive, iRangeTo, iToInclusive, -1);
    }

    @Override
    public Collection<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo, boolean iInclusive) {
        this.checkForRebuild();
        return this.getEntriesBetween(iRangeFrom, iRangeTo, iInclusive, -1);
    }

    @Override
    public Collection<OIdentifiable> getValues(Collection<?> iKeys) {
        this.checkForRebuild();
        return this.getValues(iKeys, -1);
    }

    @Override
    public Collection<ODocument> getEntries(Collection<?> iKeys) {
        this.checkForRebuild();
        return this.getEntries(iKeys, -1);
    }

    @Override
    public ORID getIdentity() {
        this.acquireSharedLock();
        try {
            ORID oRID = this.indexEngine.getIdentity();
            return oRID;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long rebuild() {
        return this.rebuild(new OIndexRebuildOutputListener(this));
    }

    @Override
    public void setRebuildingFlag() {
        this.rebuilding = true;
    }

    @Override
    public void close() {
        this.acquireSharedLock();
        try {
            this.indexEngine.close();
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long rebuild(OProgressListener iProgressListener) {
        long documentIndexed = 0L;
        boolean intentInstalled = this.getDatabase().declareIntent(new OIntentMassiveInsert());
        this.modificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                try {
                    this.rebuildThread = Thread.currentThread();
                    this.rebuilding = true;
                    try {
                        this.indexEngine.clear();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    int documentNum = 0;
                    long documentTotal = 0L;
                    for (String cluster : this.clustersToIndex) {
                        documentTotal += this.getDatabase().countClusterElements(cluster);
                    }
                    if (iProgressListener != null) {
                        iProgressListener.onBegin((Object)this, documentTotal);
                    }
                    for (String clusterName : this.clustersToIndex) {
                        try {
                            for (ORecord record : this.getDatabase().browseCluster(clusterName)) {
                                if (Thread.interrupted()) {
                                    throw new OCommandExecutionException("The index rebuild has been interrupted");
                                }
                                if (record instanceof ODocument) {
                                    ODocument doc = (ODocument)record;
                                    if (this.indexDefinition == null) {
                                        throw new OConfigurationException("Index '" + this.name + "' cannot be rebuilt because has no a valid definition (" + this.indexDefinition + ")");
                                    }
                                    Object fieldValue = this.indexDefinition.getDocumentValueToIndex(doc);
                                    if (fieldValue != null) {
                                        try {
                                            if (fieldValue instanceof Collection) {
                                                for (Object fieldValueItem : (Collection)fieldValue) {
                                                    this.put(fieldValueItem, doc);
                                                }
                                            } else {
                                                this.put(fieldValue, doc);
                                            }
                                        }
                                        catch (OIndexException e) {
                                            OLogManager.instance().error((Object)this, "Exception during index rebuild. Exception was caused by following key/ value pair - key %s, value %s. Rebuild will continue from this point.", (Throwable)((Object)e), new Object[]{fieldValue, doc.getIdentity()});
                                        }
                                        ++documentIndexed;
                                    }
                                }
                                ++documentNum;
                                if (iProgressListener == null) continue;
                                iProgressListener.onProgress((Object)this, (long)documentNum, (float)documentNum * 100.0f / (float)documentTotal);
                            }
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            // empty catch block
                        }
                    }
                    this.flush();
                    this.unload();
                    if (iProgressListener != null) {
                        iProgressListener.onCompletition((Object)this, true);
                    }
                }
                catch (Exception e) {
                    if (iProgressListener != null) {
                        iProgressListener.onCompletition((Object)this, false);
                    }
                    try {
                        this.indexEngine.clear();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new OIndexException("Error on rebuilding the index for clusters: " + this.clustersToIndex, e);
                }
            }
            finally {
                this.rebuilding = false;
                this.rebuildThread = null;
                if (intentInstalled) {
                    this.getDatabase().declareIntent(null);
                }
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
        return documentIndexed;
    }

    @Override
    public boolean remove(Object key, OIdentifiable value) {
        this.checkForRebuild();
        this.modificationLock.requestModificationLock();
        try {
            boolean bl = this.remove(key);
            return bl;
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    @Override
    public int remove(OIdentifiable iRID) {
        this.checkForRebuild();
        this.modificationLock.requestModificationLock();
        try {
            int n;
            this.acquireExclusiveLock();
            try {
                n = this.indexEngine.removeValue(iRID, null);
            }
            catch (Throwable throwable) {
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            return n;
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    @Override
    public boolean remove(Object key) {
        this.checkForRebuild();
        this.modificationLock.requestModificationLock();
        try {
            boolean bl;
            this.acquireSharedLock();
            try {
                bl = this.indexEngine.remove(key);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return bl;
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    @Override
    public OIndex<T> clear() {
        this.checkForRebuild();
        this.modificationLock.requestModificationLock();
        try {
            OIndexAbstract oIndexAbstract;
            this.acquireSharedLock();
            try {
                this.indexEngine.clear();
                oIndexAbstract = this;
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return oIndexAbstract;
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    @Override
    public OIndexInternal<T> delete() {
        this.modificationLock.requestModificationLock();
        try {
            OIndexAbstract oIndexAbstract;
            this.acquireExclusiveLock();
            try {
                this.indexEngine.delete();
                oIndexAbstract = this;
            }
            catch (Throwable throwable) {
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            return oIndexAbstract;
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    @Override
    public Iterator<Map.Entry<Object, T>> iterator() {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            Iterator<Map.Entry<Object, T>> iterator = this.indexEngine.iterator();
            return iterator;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Iterator<Map.Entry<Object, T>> inverseIterator() {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            Iterator<Map.Entry<Object, T>> iterator = this.indexEngine.inverseIterator();
            return iterator;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Iterable<Object> keys() {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            Iterable<Object> iterable = this.indexEngine.keys();
            return iterable;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public OIndexInternal<T> getInternal() {
        return this;
    }

    @Override
    public Set<String> getClusters() {
        this.acquireSharedLock();
        try {
            Set<String> set = Collections.unmodifiableSet(this.clustersToIndex);
            return set;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexAbstract<T> addCluster(String iClusterName) {
        this.acquireExclusiveLock();
        try {
            if (this.clustersToIndex.add(iClusterName)) {
                this.updateConfiguration();
            }
            OIndexAbstract oIndexAbstract = this;
            return oIndexAbstract;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public OIndexAbstract<T> removeCluster(String iClusterName) {
        this.acquireExclusiveLock();
        try {
            if (this.clustersToIndex.remove(iClusterName)) {
                this.updateConfiguration();
            }
            OIndexAbstract oIndexAbstract = this;
            return oIndexAbstract;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void checkEntry(OIdentifiable iRecord, Object iKey) {
    }

    @Override
    public void unload() {
        this.acquireSharedLock();
        try {
            this.indexEngine.unload();
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public ODocument updateConfiguration() {
        this.acquireExclusiveLock();
        try {
            this.configuration.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
            try {
                this.configuration.field("type", this.type);
                this.configuration.field("name", this.name);
                if (this.indexDefinition != null) {
                    ODocument indexDefDocument = this.indexDefinition.toStream();
                    if (!indexDefDocument.hasOwners()) {
                        indexDefDocument.addOwner(this.configuration);
                    }
                    this.configuration.field("indexDefinition", indexDefDocument, OType.EMBEDDED);
                    this.configuration.field("indexDefinitionClass", this.indexDefinition.getClass().getName());
                } else {
                    this.configuration.removeField("indexDefinition");
                    this.configuration.removeField("indexDefinitionClass");
                }
                this.configuration.field(CONFIG_CLUSTERS, this.clustersToIndex, OType.EMBEDDEDSET);
                this.configuration.field(CONFIG_MAP_RID, this.indexEngine.getIdentity());
            }
            finally {
                this.configuration.setInternalStatus(ORecordElement.STATUS.LOADED);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
        return this.configuration;
    }

    @Override
    public void commit(ODocument document) {
        this.checkForRebuild();
        if (document == null) {
            return;
        }
        this.acquireExclusiveLock();
        try {
            this.indexEngine.startTransaction();
            Boolean clearAll = (Boolean)document.field("clear");
            if (clearAll != null && clearAll.booleanValue()) {
                this.clear();
            }
            Collection entries = (Collection)document.field("entries");
            for (ODocument entry : entries) {
                Object key;
                String serializedKey = OStringSerializerHelper.decode((String)entry.field("k"));
                try {
                    if (serializedKey.equals("*")) {
                        key = "*";
                    } else {
                        ODocument keyContainer = new ODocument();
                        keyContainer.setLazyLoad(false);
                        keyContainer.fromString(serializedKey);
                        Object storedKey = keyContainer.field("key");
                        key = storedKey instanceof List ? new OCompositeKey((List)storedKey) : (Boolean.TRUE.equals(keyContainer.field("binary")) ? OStreamSerializerAnyStreamable.INSTANCE.fromStream((byte[])storedKey) : storedKey);
                    }
                }
                catch (IOException ioe) {
                    throw new OTransactionException("Error during index changes deserialization. ", ioe);
                }
                List operations = (List)entry.field("ops");
                if (operations == null) continue;
                for (ODocument op : operations) {
                    int operation = (Integer)op.rawField("o");
                    OIdentifiable value = (OIdentifiable)op.field("v", OType.LINK);
                    if (operation == OTransactionIndexChanges.OPERATION.PUT.ordinal()) {
                        this.put(key, value);
                        continue;
                    }
                    if (operation != OTransactionIndexChanges.OPERATION.REMOVE.ordinal()) continue;
                    if (key.equals("*")) {
                        this.remove(value);
                        continue;
                    }
                    if (value == null) {
                        this.remove(key);
                        continue;
                    }
                    this.remove(key, value);
                }
            }
        }
        finally {
            this.indexEngine.stopTransaction();
            this.releaseExclusiveLock();
        }
    }

    @Override
    public ODocument getConfiguration() {
        this.acquireSharedLock();
        try {
            ODocument oDocument = this.configuration;
            return oDocument;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public boolean isAutomatic() {
        this.acquireSharedLock();
        try {
            boolean bl = this.indexDefinition != null && this.indexDefinition.getClassName() != null;
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void onCreate(ODatabase iDatabase) {
    }

    @Override
    public void onDelete(ODatabase iDatabase) {
    }

    @Override
    public void onOpen(ODatabase iDatabase) {
    }

    @Override
    public void onBeforeTxBegin(ODatabase iDatabase) {
        this.acquireSharedLock();
        try {
            this.indexEngine.beforeTxBegin();
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void onBeforeTxRollback(ODatabase iDatabase) {
    }

    @Override
    public boolean onCorruptionRepairDatabase(ODatabase database, String reason, String whatWillbeFixed) {
        return reason.equals("load");
    }

    @Override
    public void onAfterTxRollback(ODatabase database) {
        this.acquireSharedLock();
        try {
            this.indexEngine.afterTxRollback();
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void onBeforeTxCommit(ODatabase database) {
    }

    @Override
    public void onAfterTxCommit(ODatabase iDatabase) {
        this.acquireSharedLock();
        try {
            this.indexEngine.afterTxCommit();
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void onClose(ODatabase iDatabase) {
        if (this.isRebuiding()) {
            return;
        }
        this.acquireSharedLock();
        try {
            this.indexEngine.closeDb();
        }
        finally {
            this.releaseSharedLock();
        }
    }

    protected void checkForKeyType(Object iKey) {
        if (this.indexDefinition == null) {
            OType type = OType.getTypeByClass(iKey.getClass());
            if (type == null) {
                return;
            }
            this.indexDefinition = new OSimpleKeyIndexDefinition(type);
            this.updateConfiguration();
        }
    }

    protected ODatabaseRecord getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    @Override
    public OType[] getKeyTypes() {
        this.acquireSharedLock();
        try {
            if (this.indexDefinition == null) {
                return null;
            }
            OType[] oTypeArray = this.indexDefinition.getTypes();
            return oTypeArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexDefinition getDefinition() {
        this.acquireSharedLock();
        try {
            OIndexDefinition oIndexDefinition = this.indexDefinition;
            return oIndexDefinition;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void freeze(boolean throwException) {
        this.modificationLock.prohibitModifications(throwException);
    }

    @Override
    public void release() {
        this.modificationLock.allowModifications();
    }

    @Override
    public void acquireModificationLock() {
        this.modificationLock.requestModificationLock();
    }

    @Override
    public void releaseModificationLock() {
        try {
            this.modificationLock.releaseModificationLock();
        }
        catch (IllegalMonitorStateException e) {
            OLogManager.instance().error((Object)this, "Error on releasing index lock against %s", (Throwable)e, new Object[]{this.getName()});
            throw e;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OIndexAbstract that = (OIndexAbstract)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public boolean isRebuiding() {
        return this.rebuilding;
    }

    protected void checkForRebuild() {
        if (this.rebuilding && !Thread.currentThread().equals(this.rebuildThread)) {
            throw new OIndexException("Index " + this.name + " is rebuilding now and can not be used.");
        }
    }
}

