/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.id;

import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.id.OClusterPosition;

public final class OClusterPositionLong
extends OClusterPosition {
    private final long value;

    public OClusterPositionLong(long value) {
        this.value = value;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public OClusterPosition inc() {
        return new OClusterPositionLong(this.value + 1L);
    }

    @Override
    public OClusterPosition dec() {
        return new OClusterPositionLong(this.value - 1L);
    }

    @Override
    public boolean isValid() {
        return this.value != -1L;
    }

    @Override
    public boolean isPersistent() {
        return this.value > -1L;
    }

    @Override
    public boolean isNew() {
        return this.value < 0L;
    }

    @Override
    public boolean isTemporary() {
        return this.value < -1L;
    }

    @Override
    public byte[] toStream() {
        byte[] content = new byte[8];
        OLongSerializer.INSTANCE.serialize(Long.valueOf(this.value), content, 0);
        return content;
    }

    @Override
    public int compareTo(OClusterPosition otherPosition) {
        OClusterPositionLong otherLongPosition = (OClusterPositionLong)otherPosition;
        if (this.value > otherLongPosition.value) {
            return 1;
        }
        if (this.value < otherLongPosition.value) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OClusterPositionLong that = (OClusterPositionLong)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public String toString() {
        return Long.toString(this.value);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public long longValueHigh() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }
}

