/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.fetch.json;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OFetchException;
import com.orientechnologies.orient.core.fetch.OFetchContext;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerJSON;
import com.orientechnologies.orient.core.version.ODistributedVersion;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.Stack;

public class OJSONFetchContext
implements OFetchContext {
    protected final OJSONWriter jsonWriter;
    protected final ORecordSerializerJSON.FormatSettings settings;
    protected final Stack<StringBuilder> typesStack = new Stack();
    protected final Stack<ORecordSchemaAware<?>> collectionStack = new Stack();

    public OJSONFetchContext(OJSONWriter iJsonWriter, ORecordSerializerJSON.FormatSettings iSettings) {
        this.jsonWriter = iJsonWriter;
        this.settings = iSettings;
    }

    @Override
    public void onBeforeFetch(ORecordSchemaAware<?> iRootRecord) {
        this.typesStack.add(new StringBuilder());
    }

    @Override
    public void onAfterFetch(ORecordSchemaAware<?> iRootRecord) {
        StringBuilder buffer = this.typesStack.pop();
        if (this.settings.keepTypes && buffer.length() > 0) {
            try {
                this.jsonWriter.writeAttribute(this.settings.indentLevel > -1 ? this.settings.indentLevel + 1 : -1, true, "@fieldTypes", buffer.toString());
            }
            catch (IOException e) {
                throw new OFetchException("Error writing field types", e);
            }
        }
    }

    @Override
    public void onBeforeStandardField(Object iFieldValue, String iFieldName, Object iUserObject) {
        this.manageTypes(iFieldName, iFieldValue);
    }

    @Override
    public void onAfterStandardField(Object iFieldValue, String iFieldName, Object iUserObject) {
    }

    @Override
    public void onBeforeArray(ORecordSchemaAware<?> iRootRecord, String iFieldName, Object iUserObject, OIdentifiable[] iArray) {
        this.onBeforeCollection(iRootRecord, iFieldName, iUserObject, null);
    }

    @Override
    public void onAfterArray(ORecordSchemaAware<?> iRootRecord, String iFieldName, Object iUserObject) {
        this.onAfterCollection(iRootRecord, iFieldName, iUserObject);
    }

    @Override
    public void onBeforeCollection(ORecordSchemaAware<?> iRootRecord, String iFieldName, Object iUserObject, Collection<?> iCollection) {
        ++this.settings.indentLevel;
        try {
            this.manageTypes(iFieldName, iCollection);
            this.jsonWriter.beginCollection(this.settings.indentLevel, true, iFieldName);
            this.collectionStack.add(iRootRecord);
        }
        catch (IOException e) {
            throw new OFetchException("Error writing collection field " + iFieldName + " of record " + iRootRecord.getIdentity(), e);
        }
    }

    @Override
    public void onAfterCollection(ORecordSchemaAware<?> iRootRecord, String iFieldName, Object iUserObject) {
        try {
            this.jsonWriter.endCollection(this.settings.indentLevel, false);
            this.collectionStack.pop();
        }
        catch (IOException e) {
            throw new OFetchException("Error writing collection field " + iFieldName + " of record " + iRootRecord.getIdentity(), e);
        }
        --this.settings.indentLevel;
    }

    @Override
    public void onBeforeMap(ORecordSchemaAware<?> iRootRecord, String iFieldName, Object iUserObject) {
        ++this.settings.indentLevel;
        try {
            this.jsonWriter.beginObject(this.settings.indentLevel, true, iFieldName);
        }
        catch (IOException e) {
            throw new OFetchException("Error writing map field " + iFieldName + " of record " + iRootRecord.getIdentity(), e);
        }
    }

    @Override
    public void onAfterMap(ORecordSchemaAware<?> iRootRecord, String iFieldName, Object iUserObject) {
        try {
            this.jsonWriter.endObject(this.settings.indentLevel, true);
        }
        catch (IOException e) {
            throw new OFetchException("Error writing map field " + iFieldName + " of record " + iRootRecord.getIdentity(), e);
        }
        --this.settings.indentLevel;
    }

    @Override
    public void onBeforeDocument(ORecordSchemaAware<?> iRootRecord, ORecordSchemaAware<?> iDocument, String iFieldName, Object iUserObject) {
        ++this.settings.indentLevel;
        try {
            String fieldName = !this.collectionStack.isEmpty() && this.collectionStack.peek().equals(iRootRecord) ? null : iFieldName;
            this.jsonWriter.beginObject(this.settings.indentLevel, false, fieldName);
            this.writeSignature(this.jsonWriter, iDocument);
        }
        catch (IOException e) {
            throw new OFetchException("Error writing link field " + iFieldName + " of record " + iRootRecord.getIdentity(), e);
        }
    }

    @Override
    public void onAfterDocument(ORecordSchemaAware<?> iRootRecord, ORecordSchemaAware<?> iDocument, String iFieldName, Object iUserObject) {
        try {
            this.jsonWriter.endObject(this.settings.indentLevel--, true);
        }
        catch (IOException e) {
            throw new OFetchException("Error writing link field " + iFieldName + " of record " + iRootRecord.getIdentity(), e);
        }
    }

    public void writeLinkedValue(OIdentifiable iRecord, String iFieldName) throws IOException {
        this.jsonWriter.writeValue(this.settings.indentLevel, true, OJSONWriter.encode(iRecord.getIdentity()));
    }

    public void writeLinkedAttribute(OIdentifiable iRecord, String iFieldName) throws IOException {
        this.jsonWriter.writeAttribute(this.settings.indentLevel, true, iFieldName, OJSONWriter.encode(iRecord.getIdentity()));
    }

    public boolean isInCollection(ORecordSchemaAware<?> record) {
        return !this.collectionStack.isEmpty() && this.collectionStack.peek().equals(record);
    }

    public OJSONWriter getJsonWriter() {
        return this.jsonWriter;
    }

    public int getIndentLevel() {
        return this.settings.indentLevel;
    }

    private void appendType(StringBuilder iBuffer, String iFieldName, char iType) {
        if (iBuffer.length() > 0) {
            iBuffer.append(',');
        }
        iBuffer.append(iFieldName);
        iBuffer.append('=');
        iBuffer.append(iType);
    }

    public void writeSignature(OJSONWriter json, ORecordInternal<?> record) throws IOException {
        boolean firstAttribute = true;
        if (this.settings.indentLevel > -1) {
            ++this.settings.indentLevel;
        }
        if (this.settings.includeType) {
            json.writeAttribute(firstAttribute ? this.settings.indentLevel : 0, firstAttribute, "@type", "" + (char)record.getRecordType());
            if (this.settings.attribSameRow) {
                firstAttribute = false;
            }
        }
        if (this.settings.includeId && record.getIdentity() != null && record.getIdentity().isValid()) {
            json.writeAttribute(!firstAttribute ? this.settings.indentLevel : 0, firstAttribute, "@rid", record.getIdentity().toString());
            if (this.settings.attribSameRow) {
                firstAttribute = false;
            }
        }
        if (this.settings.includeVer) {
            json.writeAttribute(firstAttribute ? this.settings.indentLevel : 0, firstAttribute, "@version", record.getRecordVersion().getCounter());
            if (this.settings.attribSameRow) {
                firstAttribute = false;
            }
            if (OGlobalConfiguration.DB_USE_DISTRIBUTED_VERSION.getValueAsBoolean()) {
                ODistributedVersion ver = (ODistributedVersion)record.getRecordVersion();
                json.writeAttribute(firstAttribute ? this.settings.indentLevel : 0, firstAttribute, "@version_time", ver.getTimestamp());
                json.writeAttribute(firstAttribute ? this.settings.indentLevel : 0, firstAttribute, "@version_mac", ver.getMacAddress());
            }
        }
        if (this.settings.includeClazz && record instanceof ORecordSchemaAware && ((ORecordSchemaAware)record).getClassName() != null) {
            json.writeAttribute(firstAttribute ? this.settings.indentLevel : 0, firstAttribute, "@class", ((ORecordSchemaAware)record).getClassName());
            if (this.settings.attribSameRow) {
                firstAttribute = false;
            }
        }
    }

    @Override
    public boolean fetchEmbeddedDocuments() {
        return this.settings.alwaysFetchEmbeddedDocuments;
    }

    protected void manageTypes(String iFieldName, Object iFieldValue) {
        if (this.settings.keepTypes) {
            if (iFieldValue instanceof Long) {
                this.appendType(this.typesStack.peek(), iFieldName, 'l');
            } else if (iFieldValue instanceof Float) {
                this.appendType(this.typesStack.peek(), iFieldName, 'f');
            } else if (iFieldValue instanceof Short) {
                this.appendType(this.typesStack.peek(), iFieldName, 's');
            } else if (iFieldValue instanceof Double) {
                this.appendType(this.typesStack.peek(), iFieldName, 'd');
            } else if (iFieldValue instanceof Date) {
                this.appendType(this.typesStack.peek(), iFieldName, 't');
            } else if (iFieldValue instanceof Byte || iFieldValue instanceof byte[]) {
                this.appendType(this.typesStack.peek(), iFieldName, 'b');
            } else if (iFieldValue instanceof BigDecimal) {
                this.appendType(this.typesStack.peek(), iFieldName, 'c');
            } else if (iFieldValue instanceof Set) {
                this.appendType(this.typesStack.peek(), iFieldName, 'e');
            }
        }
    }
}

