/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.exception;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OFastConcurrentModificationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;

public class OConcurrentModificationException
extends ONeedRetryException {
    private static final String MESSAGE_OPERATION = "are";
    private static final String MESSAGE_RECORD_VERSION = "your=v";
    private static final String MESSAGE_DB_VERSION = "db=v";
    private static final long serialVersionUID = 1L;
    private ORID rid;
    private ORecordVersion databaseVersion = OVersionFactory.instance().createVersion();
    private ORecordVersion recordVersion = OVersionFactory.instance().createVersion();
    private int recordOperation;

    protected OConcurrentModificationException() {
        this.rid = new ORecordId();
    }

    public OConcurrentModificationException(String message) {
        int beginPos = message.indexOf(35);
        int endPos = message.indexOf(32, beginPos);
        this.rid = new ORecordId(message.substring(beginPos, endPos));
        beginPos = message.indexOf(MESSAGE_OPERATION, endPos) + MESSAGE_OPERATION.length() + 1;
        endPos = message.indexOf("ing", beginPos);
        this.recordOperation = ORecordOperation.getId(String.valueOf(message.substring(beginPos, endPos).toUpperCase()) + "E");
        beginPos = message.indexOf(MESSAGE_DB_VERSION, endPos) + MESSAGE_DB_VERSION.length();
        endPos = message.indexOf(32, beginPos);
        this.databaseVersion.getSerializer().fromString(message.substring(beginPos, endPos), this.databaseVersion);
        beginPos = message.indexOf(MESSAGE_RECORD_VERSION, endPos) + MESSAGE_RECORD_VERSION.length();
        endPos = message.indexOf(41, beginPos);
        this.recordVersion.getSerializer().fromString(message.substring(beginPos, endPos), this.databaseVersion);
    }

    public OConcurrentModificationException(ORID iRID, ORecordVersion iDatabaseVersion, ORecordVersion iRecordVersion, int iRecordOperation) {
        if (OFastConcurrentModificationException.enabled()) {
            throw new IllegalStateException("Fast-throw is enabled. Use OFastConcurrentModificationException.instance() instead");
        }
        this.rid = iRID;
        this.databaseVersion.copyFrom(iDatabaseVersion);
        this.recordVersion.copyFrom(iRecordVersion);
        this.recordOperation = iRecordOperation;
    }

    @Deprecated
    public int getDatabaseVersion() {
        return this.databaseVersion.getCounter();
    }

    @Deprecated
    public int getRecordVersion() {
        return this.recordVersion.getCounter();
    }

    public ORecordVersion getEnhancedDatabaseVersion() {
        return this.databaseVersion;
    }

    public ORecordVersion getEnhancedRecordVersion() {
        return this.recordVersion;
    }

    public ORID getRid() {
        return this.rid;
    }

    public String getMessage() {
        String operation = ORecordOperation.getName(this.recordOperation);
        StringBuilder sb = new StringBuilder();
        sb.append("Cannot ");
        sb.append(operation);
        sb.append(" the record ");
        sb.append(this.rid);
        sb.append(" because the version is not the latest. Probably you are ");
        sb.append(operation.toLowerCase().substring(0, operation.length() - 1));
        sb.append("ing an old record or it has been modified by another user (db=v");
        sb.append(this.databaseVersion);
        sb.append(" your=v");
        sb.append(this.recordVersion);
        sb.append(")");
        return sb.toString();
    }
}

