/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.tool;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.tool.ODatabaseExportException;
import com.orientechnologies.orient.core.db.tool.ODatabaseImpExpAbstract;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.id.OClusterPositionFactory;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.index.ORuntimeKeyIndexDefinition;
import com.orientechnologies.orient.core.index.hashindex.local.OLocalHashTable;
import com.orientechnologies.orient.core.index.hashindex.local.OMurmurHash3HashFunction;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OJSONReader;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OLinkSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerJSON;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalAbstract;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import com.orientechnologies.orient.core.version.OVersionFactory;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;

public class ODatabaseImport
extends ODatabaseImpExpAbstract {
    public static final String EXPORT_IMPORT_MAP_NAME = "exportImportRIDMap";
    public static final String EXPORT_IMPORT_MAP_METADATA_EXT = ".eihtmcf";
    public static final String EXPORT_IMPORT_MAP_TREE_STATE_EXT = ".eihtsf";
    public static final String EXPORT_IMPORT_MAP_BF_EXT = ".eihtb";
    protected Map<OPropertyImpl, String> linkedClasses = new HashMap<OPropertyImpl, String>();
    protected Map<OClass, String> superClasses = new HashMap<OClass, String>();
    protected OJSONReader jsonReader;
    protected ORecordInternal<?> record;
    protected boolean schemaImported = false;
    protected int exporterVersion = -1;
    protected ORID schemaRecordId;
    protected ORID indexMgrRecordId;
    protected boolean deleteRIDMapping = true;
    private OLocalHashTable<OIdentifiable, OIdentifiable> exportImportHashTable;

    public ODatabaseImport(ODatabaseDocument database, String iFileName, OCommandOutputListener iListener) throws IOException {
        super(database, iFileName, iListener);
        FilterInputStream inStream;
        BufferedInputStream bf = new BufferedInputStream(new FileInputStream(this.fileName));
        bf.mark(1024);
        try {
            inStream = new GZIPInputStream(bf);
        }
        catch (Exception e) {
            bf.reset();
            inStream = bf;
        }
        OMurmurHash3HashFunction<OIdentifiable> keyHashFunction = new OMurmurHash3HashFunction<OIdentifiable>();
        keyHashFunction.setValueSerializer(OLinkSerializer.INSTANCE);
        this.exportImportHashTable = new OLocalHashTable(EXPORT_IMPORT_MAP_METADATA_EXT, EXPORT_IMPORT_MAP_TREE_STATE_EXT, EXPORT_IMPORT_MAP_BF_EXT, keyHashFunction);
        this.jsonReader = new OJSONReader(new InputStreamReader(inStream));
        database.declareIntent(new OIntentMassiveInsert());
    }

    public ODatabaseImport(ODatabaseDocument database, InputStream iStream, OCommandOutputListener iListener) throws IOException {
        super(database, "streaming", iListener);
        this.jsonReader = new OJSONReader(new InputStreamReader(iStream));
        database.declareIntent(new OIntentMassiveInsert());
    }

    @Override
    public ODatabaseImport setOptions(String iOptions) {
        super.setOptions(iOptions);
        return this;
    }

    @Override
    protected void parseSetting(String option, List<String> items) {
        if (option.equalsIgnoreCase("-deleteRIDMapping")) {
            this.deleteRIDMapping = Boolean.parseBoolean(items.get(0));
        } else {
            super.parseSetting(option, items);
        }
    }

    public ODatabaseImport importDatabase() {
        try {
            if (!(this.database.getStorage() instanceof OStorageLocalAbstract)) {
                this.listener.onMessage("\nError ! Only local databases with local storage can be imported. Import is terminated !");
                ODatabaseImport oDatabaseImport = this;
                return oDatabaseImport;
            }
            try {
                this.listener.onMessage("\nStarted import of database '" + this.database.getURL() + "' from " + this.fileName + "...");
                long time = System.currentTimeMillis();
                this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
                this.database.getLevel1Cache().setEnable(false);
                this.database.getLevel2Cache().setEnable(false);
                this.database.setMVCC(false);
                this.database.setValidationEnabled(false);
                this.exportImportHashTable.create(EXPORT_IMPORT_MAP_NAME, OLinkSerializer.INSTANCE, OLinkSerializer.INSTANCE, (OStorageLocalAbstract)this.database.getStorage());
                this.database.setStatus(ODatabase.STATUS.IMPORTING);
                while (this.jsonReader.hasNext() && this.jsonReader.lastChar() != '}') {
                    String tag = this.jsonReader.readString(OJSONReader.FIELD_ASSIGNMENT);
                    if (tag.equals("info")) {
                        this.importInfo();
                        continue;
                    }
                    if (tag.equals("clusters")) {
                        this.importClusters();
                        continue;
                    }
                    if (tag.equals("schema")) {
                        this.importSchema();
                        continue;
                    }
                    if (tag.equals("records")) {
                        this.importRecords();
                        continue;
                    }
                    if (tag.equals("indexes")) {
                        this.importIndexes();
                        continue;
                    }
                    if (!tag.equals("manualIndexes")) continue;
                    this.importManualIndexes();
                }
                this.database.getStorage().synch();
                this.exportImportHashTable.close();
                this.database.setStatus(ODatabase.STATUS.OPEN);
                if (this.isDeleteRIDMapping()) {
                    this.removeExportImportRIDsMap();
                }
                this.listener.onMessage("\n\nDatabase import completed in " + (System.currentTimeMillis() - time) + " ms");
            }
            catch (Exception e) {
                System.err.println("Error on database import happened just before line " + this.jsonReader.getLineNumber() + ", column " + this.jsonReader.getColumnNumber());
                e.printStackTrace();
                throw new ODatabaseExportException("Error on importing database '" + this.database.getName() + "' from file: " + this.fileName, e);
            }
        }
        finally {
            this.close();
        }
        return this;
    }

    private void importInfo() throws IOException, ParseException {
        this.listener.onMessage("\nImporting database info...");
        this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
        while (this.jsonReader.lastChar() != '}') {
            String fieldName = this.jsonReader.readString(OJSONReader.FIELD_ASSIGNMENT);
            if (fieldName.equals("exporter-version")) {
                this.exporterVersion = this.jsonReader.readInteger(OJSONReader.NEXT_IN_OBJECT);
                continue;
            }
            if (fieldName.equals("schemaRecordId")) {
                this.schemaRecordId = new ORecordId(this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT));
                continue;
            }
            if (fieldName.equals("indexMgrRecordId")) {
                this.indexMgrRecordId = new ORecordId(this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT));
                continue;
            }
            this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
        }
        this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
        if (this.schemaRecordId == null) {
            this.schemaRecordId = new ORecordId(this.database.getStorage().getConfiguration().schemaRecordId);
        }
        if (this.indexMgrRecordId == null) {
            this.indexMgrRecordId = new ORecordId(this.database.getStorage().getConfiguration().indexMgrRecordId);
        }
        this.listener.onMessage("OK");
    }

    private void importManualIndexes() throws IOException, ParseException {
        this.listener.onMessage("\nImporting manual index entries...");
        ODocument doc = new ODocument();
        this.database.getMetadata().getIndexManager().reload();
        int n = 0;
        do {
            this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
            this.jsonReader.readString(OJSONReader.FIELD_ASSIGNMENT);
            String indexName = this.jsonReader.readString(OJSONReader.NEXT_IN_ARRAY);
            if (indexName == null || indexName.length() == 0) {
                return;
            }
            this.listener.onMessage("\n- Index '" + indexName + "'...");
            OIndex<?> index = this.database.getMetadata().getIndexManager().getIndex(indexName);
            long tot = 0L;
            this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
            do {
                String value;
                if ((value = this.jsonReader.readString(OJSONReader.NEXT_IN_ARRAY).trim()).isEmpty()) continue;
                doc = (ODocument)ORecordSerializerJSON.INSTANCE.fromString(value, doc, null);
                doc.setLazyLoad(false);
                if (!((Boolean)doc.field("binary")).booleanValue()) {
                    ORID newRid = this.exportImportHashTable.get((OIdentifiable)doc.field("rid")).getIdentity();
                    assert (newRid != null);
                    index.put(doc.field("key"), newRid);
                } else {
                    ORuntimeKeyIndexDefinition runtimeKeyIndexDefinition = (ORuntimeKeyIndexDefinition)index.getDefinition();
                    OBinarySerializer binarySerializer = runtimeKeyIndexDefinition.getSerializer();
                    ORID newRid = this.exportImportHashTable.get((OIdentifiable)doc.field("rid")).getIdentity();
                    assert (newRid != null);
                    index.put(binarySerializer.deserialize((byte[])doc.field("key"), 0), newRid);
                }
                ++tot;
            } while (this.jsonReader.lastChar() == ',');
            if (index != null) {
                this.listener.onMessage("OK (" + tot + " entries)");
                ++n;
            } else {
                this.listener.onMessage("ERR, the index wasn't found in configuration");
            }
            this.jsonReader.readNext(OJSONReader.END_OBJECT);
            this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
        } while (this.jsonReader.lastChar() == ',');
        this.listener.onMessage("\nDone. Imported " + n + " indexes.");
        this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
    }

    private void importSchema() throws IOException, ParseException {
        this.listener.onMessage("\nImporting database schema...");
        this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
        int schemaVersion = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"version\"").readNumber(OJSONReader.ANY_NUMBER, true);
        this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR).readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"classes\"").readNext(OJSONReader.BEGIN_COLLECTION);
        long classImported = 0L;
        try {
            do {
                int classDefClusterId;
                this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
                String string = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"name\"").readString(OJSONReader.COMMA_SEPARATOR);
                String next = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).getValue();
                if (next.equals("\"id\"")) {
                    next = this.jsonReader.readString(OJSONReader.COMMA_SEPARATOR);
                    next = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).getValue();
                }
                if (this.jsonReader.isContent("\"default-cluster-id\"")) {
                    next = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                    classDefClusterId = Integer.parseInt(next);
                } else {
                    classDefClusterId = this.database.getDefaultClusterId();
                }
                String classClusterIds = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"cluster-ids\"").readString(OJSONReader.END_COLLECTION, true).trim();
                this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
                OClassImpl cls = (OClassImpl)this.database.getMetadata().getSchema().getClass(string);
                if (cls != null) {
                    if (cls.getDefaultClusterId() != classDefClusterId) {
                        cls.setDefaultClusterId(classDefClusterId);
                    }
                } else {
                    cls = (OClassImpl)this.database.getMetadata().getSchema().createClass(string, classDefClusterId);
                }
                if (classClusterIds != null) {
                    classClusterIds = classClusterIds.substring(1, classClusterIds.length() - 1);
                    int[] nArray = OStringSerializerHelper.splitIntArray(classClusterIds);
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int i = nArray[n2];
                        if (i != -1) {
                            cls.addClusterId(i);
                        }
                        ++n2;
                    }
                }
                while (this.jsonReader.lastChar() == ',') {
                    this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT);
                    String value = this.jsonReader.getValue();
                    if (value.equals("\"strictMode\"")) {
                        cls.setStrictMode(this.jsonReader.readBoolean(OJSONReader.NEXT_IN_OBJECT));
                        continue;
                    }
                    if (value.equals("\"abstract\"")) {
                        cls.setAbstract(this.jsonReader.readBoolean(OJSONReader.NEXT_IN_OBJECT));
                        continue;
                    }
                    if (value.equals("\"oversize\"")) {
                        String oversize = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                        cls.setOverSize(Float.parseFloat(oversize));
                        continue;
                    }
                    if (value.equals("\"short-name\"")) {
                        String shortName = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                        cls.setShortName(shortName);
                        continue;
                    }
                    if (value.equals("\"super-class\"")) {
                        String classSuper = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                        this.superClasses.put(cls, classSuper);
                        continue;
                    }
                    if (!value.equals("\"properties\"")) continue;
                    this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
                    while (this.jsonReader.lastChar() != ']') {
                        this.importProperty(cls);
                        if (this.jsonReader.lastChar() != '}') continue;
                        this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                    }
                    this.jsonReader.readNext(OJSONReader.END_OBJECT);
                }
                ++classImported;
                this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
            } while (this.jsonReader.lastChar() == ',');
            for (Map.Entry<OClass, String> entry : this.superClasses.entrySet()) {
                entry.getKey().setSuperClass(this.database.getMetadata().getSchema().getClass(entry.getValue()));
            }
            for (Map.Entry<Comparable<OClass>, String> entry : this.linkedClasses.entrySet()) {
                ((OPropertyImpl)entry.getKey()).setLinkedClass(this.database.getMetadata().getSchema().getClass(entry.getValue()));
            }
            this.database.getMetadata().getSchema().save();
            this.listener.onMessage("OK (" + classImported + " classes)");
            this.schemaImported = true;
            this.jsonReader.readNext(OJSONReader.END_OBJECT);
            this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.listener.onMessage("ERROR (" + classImported + " entries): " + exception);
        }
    }

    private void importProperty(OClass iClass) throws IOException, ParseException {
        this.jsonReader.readNext(OJSONReader.NEXT_OBJ_IN_ARRAY);
        if (this.jsonReader.lastChar() == ']') {
            return;
        }
        String propName = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"name\"").readString(OJSONReader.COMMA_SEPARATOR);
        String next = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).getValue();
        if (next.equals("\"id\"")) {
            next = this.jsonReader.readString(OJSONReader.COMMA_SEPARATOR);
            next = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).getValue();
        }
        next = this.jsonReader.checkContent("\"type\"").readString(OJSONReader.NEXT_IN_OBJECT);
        OType type = OType.valueOf(next);
        String value = null;
        String min = null;
        String max = null;
        String linkedClass = null;
        OType linkedType = null;
        boolean mandatory = false;
        boolean readonly = false;
        boolean notNull = false;
        Map<String, String> customFields = null;
        while (this.jsonReader.lastChar() == ',') {
            this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT);
            String attrib = this.jsonReader.getValue();
            if (!attrib.equals("\"customFields\"")) {
                value = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
            }
            if (attrib.equals("\"min\"")) {
                min = value;
                continue;
            }
            if (attrib.equals("\"max\"")) {
                max = value;
                continue;
            }
            if (attrib.equals("\"linked-class\"")) {
                linkedClass = value;
                continue;
            }
            if (attrib.equals("\"mandatory\"")) {
                mandatory = Boolean.parseBoolean(value);
                continue;
            }
            if (attrib.equals("\"readonly\"")) {
                readonly = Boolean.parseBoolean(value);
                continue;
            }
            if (attrib.equals("\"not-null\"")) {
                notNull = Boolean.parseBoolean(value);
                continue;
            }
            if (attrib.equals("\"linked-type\"")) {
                linkedType = OType.valueOf(value);
                continue;
            }
            if (!attrib.equals("\"customFields\"")) continue;
            customFields = this.importCustomFields();
        }
        OPropertyImpl prop = (OPropertyImpl)iClass.getProperty(propName);
        if (prop == null) {
            prop = (OPropertyImpl)iClass.createProperty(propName, type);
        }
        prop.setMandatory(mandatory);
        prop.setReadonly(readonly);
        prop.setNotNull(notNull);
        if (min != null) {
            prop.setMin(min);
        }
        if (max != null) {
            prop.setMax(max);
        }
        if (linkedClass != null) {
            this.linkedClasses.put(prop, linkedClass);
        }
        if (linkedType != null) {
            prop.setLinkedType(linkedType);
        }
        if (customFields != null) {
            for (Map.Entry entry : customFields.entrySet()) {
                prop.setCustom((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private Map<String, String> importCustomFields() throws ParseException, IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
        while (this.jsonReader.lastChar() != '}') {
            String key = this.jsonReader.readString(OJSONReader.FIELD_ASSIGNMENT);
            String value = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
            result.put(key, value);
        }
        this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
        return result;
    }

    private long importClusters() throws ParseException, IOException {
        this.listener.onMessage("\nImporting clusters...");
        long total = 0L;
        this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
        boolean makeFullCheckPointAfterClusterCreation = false;
        if (this.database.getStorage() instanceof OLocalPaginatedStorage) {
            makeFullCheckPointAfterClusterCreation = ((OLocalPaginatedStorage)this.database.getStorage()).isMakeFullCheckPointAfterClusterCreate();
            ((OLocalPaginatedStorage)this.database.getStorage()).disableFullCheckPointAfterClusterCreate();
        }
        boolean recreateManualIndex = false;
        if (this.exporterVersion <= 4) {
            this.removeDefaultClusters();
            recreateManualIndex = true;
        }
        ORecordId rid = null;
        while (this.jsonReader.lastChar() != ']') {
            int clusterId;
            this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
            String name = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"name\"").readString(OJSONReader.COMMA_SEPARATOR);
            if (name.length() == 0) {
                name = null;
            }
            if (name != null) {
                if (this.includeClusters != null) {
                    if (!this.includeClusters.contains(name)) {
                        this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                        continue;
                    }
                } else if (this.excludeClusters != null && this.excludeClusters.contains(name)) {
                    this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                    continue;
                }
            }
            int id = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"id\"").readInteger(OJSONReader.COMMA_SEPARATOR);
            String type = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"type\"").readString(OJSONReader.NEXT_IN_OBJECT);
            rid = this.jsonReader.lastChar() == ',' ? new ORecordId(this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"rid\"").readString(OJSONReader.NEXT_IN_OBJECT)) : null;
            this.listener.onMessage("\n- Creating cluster " + (name != null ? "'" + name + "'" : "NULL") + "...");
            int n = clusterId = name != null ? this.database.getClusterIdByName(name) : -1;
            if (clusterId == -1) {
                clusterId = this.database.addCluster(type, name, null, null, new Object[0]);
            }
            if (clusterId != id) {
                if (this.database.countClusterElements(clusterId - 1) == 0L) {
                    this.listener.onMessage("Found previous version: migrating old clusters...");
                    this.database.dropCluster(name, true);
                    this.database.addCluster(type, "temp_" + clusterId, null, null, new Object[0]);
                    clusterId = this.database.addCluster(type, name, null, null, new Object[0]);
                } else {
                    throw new OConfigurationException("Imported cluster '" + name + "' has id=" + clusterId + " different from the original: " + id + ". To continue the import drop the cluster '" + this.database.getClusterNameById(clusterId - 1) + "' that has " + this.database.countClusterElements(clusterId - 1) + " records");
                }
            }
            if (!(name == null || name.equalsIgnoreCase("manindex") || name.equalsIgnoreCase("internal") || name.equalsIgnoreCase("index"))) {
                this.database.getStorage().getClusterById(clusterId).truncate();
            }
            this.listener.onMessage("OK, assigned id=" + clusterId);
            ++total;
            this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
        }
        this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
        if (recreateManualIndex) {
            this.database.addCluster(OStorage.CLUSTER_TYPE.PHYSICAL.toString(), "manindex", null, null, new Object[0]);
            this.database.getMetadata().getIndexManager().create();
            this.listener.onMessage("\nManual index cluster was recreated.");
        }
        this.listener.onMessage("\nDone. Imported " + total + " clusters");
        if (this.database.load(new ORecordId(this.database.getStorage().getConfiguration().indexMgrRecordId)) == null) {
            ODocument indexDocument = new ODocument();
            indexDocument.save("internal");
            this.database.getStorage().getConfiguration().indexMgrRecordId = indexDocument.getIdentity().toString();
            this.database.getStorage().getConfiguration().update();
        }
        if (this.database.getStorage() instanceof OLocalPaginatedStorage && makeFullCheckPointAfterClusterCreation) {
            ((OLocalPaginatedStorage)this.database.getStorage()).enableFullCheckPointAfterClusterCreate();
        }
        return total;
    }

    protected void removeDefaultClusters() {
        this.listener.onMessage("\nWARN: Exported database does not support manual index separation. Manual index cluster will be dropped.");
        this.database.dropCluster("manindex", true);
        OSchema schema = this.database.getMetadata().getSchema();
        if (schema.existsClass("OUser")) {
            schema.dropClass("OUser");
        }
        if (schema.existsClass("ORole")) {
            schema.dropClass("ORole");
        }
        if (schema.existsClass("ORestricted")) {
            schema.dropClass("ORestricted");
        }
        if (schema.existsClass("OFunction")) {
            schema.dropClass("OFunction");
        }
        if (schema.existsClass("ORIDs")) {
            schema.dropClass("ORIDs");
        }
        if (schema.existsClass("OTriggered")) {
            schema.dropClass("OTriggered");
        }
        schema.save();
        this.database.dropCluster("default", true);
        this.database.getStorage().setDefaultClusterId(this.database.addCluster(OStorage.CLUSTER_TYPE.PHYSICAL.toString(), "default", null, null, new Object[0]));
        new ODocument().save("default");
        this.database.getMetadata().getSecurity().create();
    }

    private long importRecords() throws Exception {
        long total = 0L;
        this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
        long totalRecords = 0L;
        System.out.print("\nImporting records...");
        int lastClusterId = -1;
        long clusterRecords = 0L;
        while (this.jsonReader.lastChar() != ']') {
            ORID rid = this.importRecord();
            if (rid != null) {
                ++clusterRecords;
                if (lastClusterId == -1) {
                    lastClusterId = rid.getClusterId();
                } else if (rid.getClusterId() != lastClusterId || this.jsonReader.lastChar() == ']') {
                    System.out.print("\n- Imported records into cluster '" + this.database.getClusterNameById(lastClusterId) + "' (id=" + lastClusterId + "): " + clusterRecords + " records");
                    clusterRecords = 0L;
                    lastClusterId = rid.getClusterId();
                }
                ++totalRecords;
            }
            this.record = null;
        }
        this.rewriteLinksInImportedDocuments();
        this.listener.onMessage("\n\nDone. Imported " + totalRecords + " records\n");
        this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
        return total;
    }

    private ORID importRecord() throws Exception {
        String value = this.jsonReader.readString(OJSONReader.END_OBJECT, true);
        while (!value.isEmpty() && value.charAt(0) != '{') {
            value = value.substring(1);
        }
        this.record = null;
        try {
            this.record = ORecordSerializerJSON.INSTANCE.fromString(value, this.record, null);
            if (this.schemaImported && this.record.getIdentity().equals(this.schemaRecordId)) {
                return null;
            }
            if (this.includeClusters != null) {
                if (!this.includeClusters.contains(this.database.getClusterNameById(this.record.getIdentity().getClusterId()))) {
                    this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                    return null;
                }
            } else if (this.excludeClusters != null && this.excludeClusters.contains(this.database.getClusterNameById(this.record.getIdentity().getClusterId()))) {
                return null;
            }
            if (this.record.getIdentity().getClusterId() == 0 && this.record.getIdentity().getClusterPosition().longValue() == 1L) {
                return null;
            }
            if (this.exporterVersion >= 3) {
                int oridsId = this.database.getClusterIdByName("ORIDs");
                int indexId = this.database.getClusterIdByName("index");
                if (this.record.getIdentity().getClusterId() == indexId || this.record.getIdentity().getClusterId() == oridsId) {
                    return null;
                }
            }
            int manualIndexCluster = this.database.getClusterIdByName("manindex");
            int internalCluster = this.database.getClusterIdByName("internal");
            int indexCluster = this.database.getClusterIdByName("index");
            if (this.exporterVersion >= 4 && this.record.getIdentity().getClusterId() == manualIndexCluster) {
                return null;
            }
            if (this.record.getIdentity().equals(this.indexMgrRecordId)) {
                return null;
            }
            try {
                ORID rid = this.record.getIdentity();
                int clusterId = rid.getClusterId();
                if (clusterId != manualIndexCluster && clusterId != internalCluster && clusterId != indexCluster) {
                    this.record.getRecordVersion().copyFrom(OVersionFactory.instance().createVersion());
                    this.record.setDirty();
                    this.record.setIdentity(new ORecordId());
                    this.record.save(this.database.getClusterNameById(clusterId));
                    this.exportImportHashTable.put(rid, this.record.getIdentity());
                }
            }
            catch (Exception t) {
                if (this.record != null) {
                    System.err.println("Error importing record " + this.record.getIdentity() + ". Source line " + this.jsonReader.getLineNumber() + ", column " + this.jsonReader.getColumnNumber());
                } else {
                    System.err.println("Error importing record. Source line " + this.jsonReader.getLineNumber() + ", column " + this.jsonReader.getColumnNumber());
                }
                throw t;
            }
        }
        finally {
            this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
        }
        return this.record.getIdentity();
    }

    private void importIndexes() throws IOException, ParseException {
        this.listener.onMessage("\nImporting indexes ...");
        ((ORecordInternal)this.database.load(new ORecordId(this.database.getStorage().getConfiguration().indexMgrRecordId))).clear().save();
        OIndexManagerProxy indexManager = this.database.getMetadata().getIndexManager();
        indexManager.reload();
        this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
        int n = 0;
        while (this.jsonReader.lastChar() != ']') {
            this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
            String indexName = null;
            String indexType = null;
            Set<Object> clustersToIndex = new HashSet();
            OIndexDefinition indexDefinition = null;
            while (this.jsonReader.lastChar() != '}') {
                String fieldName = this.jsonReader.readString(OJSONReader.FIELD_ASSIGNMENT);
                if (fieldName.equals("name")) {
                    indexName = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                    continue;
                }
                if (fieldName.equals("type")) {
                    indexType = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                    continue;
                }
                if (fieldName.equals("clustersToIndex")) {
                    clustersToIndex = this.importClustersToIndex();
                    continue;
                }
                if (!fieldName.equals("definition")) continue;
                indexDefinition = this.importIndexDefinition();
            }
            this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
            this.listener.onMessage("\n- Index '" + indexName + "'...");
            indexManager.dropIndex(indexName);
            int[] clusterIdsToIndex = new int[clustersToIndex.size()];
            int i = 0;
            for (String string : clustersToIndex) {
                clusterIdsToIndex[i] = this.database.getClusterIdByName(string);
                ++i;
            }
            indexManager.createIndex(indexName, indexType, indexDefinition, clusterIdsToIndex, null);
            ++n;
            this.listener.onMessage("OK");
        }
        this.listener.onMessage("\nDone. Created " + n + " indexes.");
        this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
    }

    private Set<String> importClustersToIndex() throws IOException, ParseException {
        HashSet<String> clustersToIndex = new HashSet<String>();
        this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
        while (this.jsonReader.lastChar() != ']') {
            String clusterToIndex = this.jsonReader.readString(OJSONReader.NEXT_IN_ARRAY);
            clustersToIndex.add(clusterToIndex);
        }
        this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
        return clustersToIndex;
    }

    private OIndexDefinition importIndexDefinition() throws IOException, ParseException {
        OIndexDefinition indexDefinition;
        this.jsonReader.readString(OJSONReader.BEGIN_OBJECT);
        this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT);
        String className = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
        this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT);
        String value = this.jsonReader.readString(OJSONReader.END_OBJECT, true);
        ODocument indexDefinitionDoc = (ODocument)ORecordSerializerJSON.INSTANCE.fromString(value, null, null);
        try {
            Class<?> indexDefClass = Class.forName(className);
            indexDefinition = (OIndexDefinition)indexDefClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            indexDefinition.fromStream(indexDefinitionDoc);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Error during deserialization of index definition", e);
        }
        catch (NoSuchMethodException e) {
            throw new IOException("Error during deserialization of index definition", e);
        }
        catch (InvocationTargetException e) {
            throw new IOException("Error during deserialization of index definition", e);
        }
        catch (InstantiationException e) {
            throw new IOException("Error during deserialization of index definition", e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Error during deserialization of index definition", e);
        }
        this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
        return indexDefinition;
    }

    private void rewriteLinksInImportedDocuments() throws IOException {
        this.listener.onMessage("\nLinks are going to be updated according to new RIDs");
        Collection<String> clusterNames = this.database.getClusterNames();
        for (String clusterName : clusterNames) {
            if ("index".equals(clusterName) || "internal".equals(clusterName) || "manindex".equals(clusterName)) continue;
            long documents = 0L;
            this.listener.onMessage("\nRewrite links for " + clusterName + " cluster...");
            int clusterId = this.database.getClusterIdByName(clusterName);
            OCluster cluster = this.database.getStorage().getClusterById(clusterId);
            OPhysicalPosition[] positions = cluster.ceilingPositions(new OPhysicalPosition(OClusterPositionFactory.INSTANCE.valueOf(0L)));
            while (positions.length > 0) {
                OPhysicalPosition[] oPhysicalPositionArray = positions;
                int n = positions.length;
                int n2 = 0;
                while (n2 < n) {
                    OPhysicalPosition position = oPhysicalPositionArray[n2];
                    ORecord record = (ORecord)this.database.load(new ORecordId(clusterId, position.clusterPosition));
                    if (record instanceof ODocument) {
                        ODocument document = (ODocument)record;
                        this.rewriteLinksInDocument(document);
                        if (++documents % 10000L == 0L) {
                            this.listener.onMessage("\n" + documents + " documents were processed...");
                        }
                    }
                    ++n2;
                }
                positions = cluster.higherPositions(positions[positions.length - 1]);
            }
            this.listener.onMessage("\nLinks for " + clusterName + " cluster were updated, " + documents + " were processed...");
        }
        this.listener.onMessage("\nLinks are successfully updated.");
    }

    private void rewriteLinksInDocument(ODocument document) {
        RewritersFactory.INSTANCE.setExportImportHashTable(this.exportImportHashTable);
        DocumentRewriter documentRewriter = new DocumentRewriter();
        document = documentRewriter.rewriteValue(document);
        if (document != null) {
            document.save();
        }
    }

    public ODatabaseImport removeExportImportRIDsMap() {
        this.listener.onMessage("\nDeleting RID Mapping table...");
        this.exportImportHashTable.delete();
        this.listener.onMessage("OK\n");
        return this;
    }

    public void close() {
        this.database.declareIntent(null);
    }

    public boolean isDeleteRIDMapping() {
        return this.deleteRIDMapping;
    }

    public void setDeleteRIDMapping(boolean deleteRIDMapping) {
        this.deleteRIDMapping = deleteRIDMapping;
    }

    private static class DocumentRewriter
    implements FieldRewriter<ODocument> {
        private DocumentRewriter() {
        }

        @Override
        public ODocument rewriteValue(ODocument documentValue) {
            boolean wasRewritten = false;
            documentValue.setLazyLoad(false);
            String[] stringArray = documentValue.fieldNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fieldName = stringArray[n2];
                Object fieldValue = documentValue.field(fieldName);
                FieldRewriter fieldRewriter = RewritersFactory.INSTANCE.findRewriter(documentValue, fieldName, fieldValue);
                Object newFieldValue = fieldRewriter.rewriteValue(fieldValue);
                if (newFieldValue != null) {
                    documentValue.field(fieldName, newFieldValue);
                    wasRewritten = true;
                }
                ++n2;
            }
            if (wasRewritten) {
                return documentValue;
            }
            return null;
        }
    }

    private static interface FieldRewriter<T> {
        public T rewriteValue(T var1);
    }

    private static class IdentityRewriter<T>
    implements FieldRewriter<T> {
        private IdentityRewriter() {
        }

        @Override
        public T rewriteValue(T value) {
            return null;
        }
    }

    private static class LinkRewriter
    implements FieldRewriter<ORID> {
        private final OLocalHashTable<OIdentifiable, OIdentifiable> exportImportHashTable;

        private LinkRewriter(OLocalHashTable<OIdentifiable, OIdentifiable> exportImportHashTable) {
            this.exportImportHashTable = exportImportHashTable;
        }

        @Override
        public ORID rewriteValue(ORID value) {
            if (!value.isPersistent()) {
                return null;
            }
            OIdentifiable result = this.exportImportHashTable.get(value);
            assert (result != null);
            return result.getIdentity();
        }
    }

    private static class LinkSetRewriter
    implements FieldRewriter<OMVRBTreeRIDSet> {
        private LinkSetRewriter() {
        }

        @Override
        public OMVRBTreeRIDSet rewriteValue(OMVRBTreeRIDSet setValue) {
            setValue.setAutoConvertToRecord(false);
            OMVRBTreeRIDSet result = new OMVRBTreeRIDSet();
            result.setAutoConvertToRecord(false);
            boolean wasRewritten = false;
            for (OIdentifiable identifiable : setValue) {
                FieldRewriter<ORID> fieldRewriter = RewritersFactory.INSTANCE.findRewriter(null, null, identifiable.getIdentity());
                ORID newRid = fieldRewriter.rewriteValue(identifiable.getIdentity());
                if (newRid != null) {
                    wasRewritten = true;
                    result.add(newRid);
                    continue;
                }
                result.add(identifiable);
            }
            if (wasRewritten) {
                return result;
            }
            result.clear();
            return null;
        }
    }

    private static class ListRewriter
    implements FieldRewriter<List<?>> {
        private ListRewriter() {
        }

        @Override
        public List<?> rewriteValue(List<?> listValue) {
            boolean wasRewritten = false;
            ArrayList result = new ArrayList(listValue.size());
            for (Object listItem : listValue) {
                FieldRewriter<?> fieldRewriter = RewritersFactory.INSTANCE.findRewriter(null, null, listItem);
                Object rewrittenItem = fieldRewriter.rewriteValue(listItem);
                if (rewrittenItem != null) {
                    wasRewritten = true;
                    result.add(rewrittenItem);
                    continue;
                }
                result.add(listItem);
            }
            if (!wasRewritten) {
                return null;
            }
            return result;
        }
    }

    private static class MapRewriter
    implements FieldRewriter<Map<String, Object>> {
        private MapRewriter() {
        }

        @Override
        public Map<String, Object> rewriteValue(Map<String, Object> mapValue) {
            boolean wasRewritten = false;
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : mapValue.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                FieldRewriter<Object> fieldRewriter = RewritersFactory.INSTANCE.findRewriter(null, null, value);
                Object newValue = fieldRewriter.rewriteValue(value);
                if (newValue != null) {
                    result.put(key, newValue);
                    wasRewritten = true;
                    continue;
                }
                result.put(key, value);
            }
            if (wasRewritten) {
                return result;
            }
            return null;
        }
    }

    private static class RewritersFactory {
        public static final RewritersFactory INSTANCE = new RewritersFactory();
        private OLocalHashTable<OIdentifiable, OIdentifiable> exportImportHashTable;
        private static /* synthetic */ int[] $SWITCH_TABLE$com$orientechnologies$orient$core$metadata$schema$OType;

        private RewritersFactory() {
        }

        public <T> FieldRewriter<T> findRewriter(ODocument document, String fieldName, T value) {
            if (value == null) {
                return new IdentityRewriter();
            }
            Enum fieldType = null;
            if (document != null) {
                OClass docClass = document.getSchemaClass();
                if (docClass != null) {
                    OProperty property = docClass.getProperty(fieldName);
                    if (property != null) {
                        fieldType = property.getType();
                    }
                } else {
                    fieldType = document.fieldType(fieldName);
                }
            }
            if (fieldType == null) {
                if (value instanceof ODocument) {
                    return new DocumentRewriter();
                }
                if (value instanceof List) {
                    return new ListRewriter();
                }
                if (value instanceof Map) {
                    return new MapRewriter();
                }
                if (value instanceof OMVRBTreeRIDSet) {
                    return new LinkSetRewriter();
                }
                if (value instanceof ORID) {
                    return new LinkRewriter(this.exportImportHashTable);
                }
                if (value instanceof Set) {
                    return new SetRewriter();
                }
                return new IdentityRewriter();
            }
            switch (RewritersFactory.$SWITCH_TABLE$com$orientechnologies$orient$core$metadata$schema$OType()[fieldType.ordinal()]) {
                case 10: {
                    return new DocumentRewriter();
                }
                case 15: {
                    return new ListRewriter();
                }
                case 17: {
                    return new MapRewriter();
                }
                case 16: {
                    return new LinkSetRewriter();
                }
                case 14: {
                    return new LinkRewriter(this.exportImportHashTable);
                }
                case 11: {
                    return new ListRewriter();
                }
                case 13: {
                    return new MapRewriter();
                }
                case 12: {
                    return new SetRewriter();
                }
            }
            return new IdentityRewriter();
        }

        private void setExportImportHashTable(OLocalHashTable<OIdentifiable, OIdentifiable> exportImportHashTable) {
            this.exportImportHashTable = exportImportHashTable;
        }

        static /* synthetic */ int[] $SWITCH_TABLE$com$orientechnologies$orient$core$metadata$schema$OType() {
            if ($SWITCH_TABLE$com$orientechnologies$orient$core$metadata$schema$OType != null) {
                return $SWITCH_TABLE$com$orientechnologies$orient$core$metadata$schema$OType;
            }
            int[] nArray = new int[OType.values().length];
            try {
                nArray[OType.BINARY.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[OType.BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[OType.BYTE.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[OType.CUSTOM.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[OType.DATE.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[OType.DATETIME.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[OType.DECIMAL.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[OType.DOUBLE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[OType.EMBEDDED.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[OType.EMBEDDEDLIST.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[OType.EMBEDDEDMAP.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[OType.EMBEDDEDSET.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[OType.FLOAT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[OType.INTEGER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[OType.LINK.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[OType.LINKLIST.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[OType.LINKMAP.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[OType.LINKSET.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[OType.LONG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[OType.SHORT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[OType.STRING.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[OType.TRANSIENT.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $SWITCH_TABLE$com$orientechnologies$orient$core$metadata$schema$OType = nArray;
            return nArray;
        }
    }

    private static class SetRewriter
    implements FieldRewriter<Set<?>> {
        private SetRewriter() {
        }

        @Override
        public Set<?> rewriteValue(Set<?> setValue) {
            boolean wasRewritten = false;
            HashSet result = new HashSet();
            for (Object item : setValue) {
                FieldRewriter<?> fieldRewriter = RewritersFactory.INSTANCE.findRewriter(null, null, item);
                Object newItem = fieldRewriter.rewriteValue(item);
                if (newItem != null) {
                    wasRewritten = true;
                    result.add(newItem);
                    continue;
                }
                result.add(item);
            }
            if (wasRewritten) {
                return result;
            }
            return null;
        }
    }
}

