/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeListener;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.WeakHashMap;

public class OTrackedSet<T>
extends HashSet<T>
implements ORecordElement,
OTrackedMultiValue<T, T>,
Serializable {
    protected final ORecord<?> sourceRecord;
    private ORecordElement.STATUS status = ORecordElement.STATUS.NOT_LOADED;
    private Set<OMultiValueChangeListener<T, T>> changeListeners = Collections.newSetFromMap(new WeakHashMap());
    protected Class<?> genericClass;

    public OTrackedSet(ORecord<?> iRecord, Collection<? extends T> iOrigin, Class<?> cls) {
        this(iRecord);
        this.genericClass = cls;
        if (iOrigin != null && !iOrigin.isEmpty()) {
            this.addAll(iOrigin);
        }
    }

    public OTrackedSet(ORecord<?> iSourceRecord) {
        this.sourceRecord = iSourceRecord;
    }

    @Override
    public boolean add(T e) {
        if (super.add(e)) {
            this.fireCollectionChangedEvent(new OMultiValueChangeEvent<T, T>(OMultiValueChangeEvent.OChangeType.ADD, e, e));
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (super.remove(o)) {
            this.fireCollectionChangedEvent(new OMultiValueChangeEvent<Object, Object>(OMultiValueChangeEvent.OChangeType.REMOVE, o, null, o));
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        HashSet origValues = this.changeListeners.isEmpty() ? null : new HashSet(this);
        super.clear();
        if (origValues != null) {
            for (Object item : origValues) {
                this.fireCollectionChangedEvent(new OMultiValueChangeEvent(OMultiValueChangeEvent.OChangeType.REMOVE, item, null, item));
            }
        } else {
            this.setDirty();
        }
    }

    public OTrackedSet<T> setDirty() {
        if (this.status != ORecordElement.STATUS.UNMARSHALLING && this.sourceRecord != null && !this.sourceRecord.isDirty()) {
            this.sourceRecord.setDirty();
        }
        return this;
    }

    @Override
    public void onBeforeIdentityChanged(ORID iRID) {
    }

    @Override
    public void onAfterIdentityChanged(ORecord<?> iRecord) {
    }

    @Override
    public ORecordElement.STATUS getInternalStatus() {
        return this.status;
    }

    @Override
    public void setInternalStatus(ORecordElement.STATUS iStatus) {
        this.status = iStatus;
    }

    @Override
    public void addChangeListener(OMultiValueChangeListener<T, T> changeListener) {
        this.changeListeners.add(changeListener);
    }

    @Override
    public void removeRecordChangeListener(OMultiValueChangeListener<T, T> changeListener) {
        this.changeListeners.remove(changeListener);
    }

    public Set<T> returnOriginalState(List<OMultiValueChangeEvent<T, T>> multiValueChangeEvents) {
        HashSet<T> reverted = new HashSet<T>(this);
        ListIterator<OMultiValueChangeEvent<T, T>> listIterator = multiValueChangeEvents.listIterator(multiValueChangeEvents.size());
        block4: while (listIterator.hasPrevious()) {
            OMultiValueChangeEvent<T, T> event = listIterator.previous();
            switch (event.getChangeType()) {
                case ADD: {
                    reverted.remove(event.getKey());
                    continue block4;
                }
                case REMOVE: {
                    reverted.add(event.getOldValue());
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Invalid change type : " + (Object)((Object)event.getChangeType()));
        }
        return reverted;
    }

    protected void fireCollectionChangedEvent(OMultiValueChangeEvent<T, T> event) {
        if (this.status == ORecordElement.STATUS.UNMARSHALLING) {
            return;
        }
        this.setDirty();
        for (OMultiValueChangeListener<T, T> changeListener : this.changeListeners) {
            if (changeListener == null) continue;
            changeListener.onAfterRecordChanged(event);
        }
    }

    @Override
    public Class<?> getGenericClass() {
        return this.genericClass;
    }

    public void setGenericClass(Class<?> genericClass) {
        this.genericClass = genericClass;
    }

    private Object writeReplace() {
        return new HashSet(this);
    }
}

