/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.common.collection.OLazyIterator;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OResettable;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import java.util.Iterator;

public class OLazyRecordIterator
implements OLazyIterator<OIdentifiable>,
OResettable {
    private final ORecord<?> sourceRecord;
    private final Iterable<? extends OIdentifiable> source;
    private Iterator<? extends OIdentifiable> underlying;
    private final boolean autoConvert2Record;

    public OLazyRecordIterator(Iterator<? extends OIdentifiable> iIterator, boolean iConvertToRecord) {
        this.sourceRecord = null;
        this.underlying = iIterator;
        this.autoConvert2Record = iConvertToRecord;
        this.source = null;
    }

    public OLazyRecordIterator(ORecord<?> iSourceRecord, Iterator<? extends OIdentifiable> iIterator, boolean iConvertToRecord) {
        this.sourceRecord = iSourceRecord;
        this.underlying = iIterator;
        this.autoConvert2Record = iConvertToRecord;
        this.source = null;
    }

    public OLazyRecordIterator(Iterable<? extends OIdentifiable> iSource, boolean iConvertToRecord) {
        this.sourceRecord = null;
        this.autoConvert2Record = iConvertToRecord;
        this.source = iSource;
        this.underlying = iSource.iterator();
    }

    public OIdentifiable next() {
        OIdentifiable value = this.underlying.next();
        if (value == null) {
            return null;
        }
        if (value instanceof ORecordId && this.autoConvert2Record) {
            try {
                Object rec = ((ORecordId)value).getRecord();
                if (this.underlying instanceof OLazyIterator) {
                    ((OLazyIterator)this.underlying).update(rec);
                }
                value = rec;
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error on iterating record collection", (Throwable)e, new Object[0]);
                value = null;
            }
        }
        return value;
    }

    public boolean hasNext() {
        return this.underlying.hasNext();
    }

    public OIdentifiable update(OIdentifiable iValue) {
        if (this.underlying instanceof OLazyIterator) {
            OIdentifiable old = (OIdentifiable)((OLazyIterator)this.underlying).update((Object)iValue);
            if (this.sourceRecord != null && !old.equals(iValue)) {
                this.sourceRecord.setDirty();
            }
            return old;
        }
        throw new UnsupportedOperationException("Underlying iterator not supports lazy updates (Interface OLazyIterator");
    }

    public void remove() {
        this.underlying.remove();
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirty();
        }
    }

    public void reset() {
        if (this.underlying instanceof OResettable) {
            ((OResettable)this.underlying).reset();
        } else if (this.source != null) {
            this.underlying = this.source.iterator();
        }
    }
}

