/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.raw;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OLevel1RecordCache;
import com.orientechnologies.orient.core.cache.OLevel2RecordCache;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.graph.OGraphDatabase;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalAbstract;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;

public class ODatabaseRaw
implements ODatabase {
    protected String url;
    protected OStorage storage;
    protected ODatabase.STATUS status;
    protected OIntent currentIntent;
    private ODatabaseRecord databaseOwner;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Set<ODatabaseListener> listeners = Collections.newSetFromMap(new IdentityHashMap(64));

    public ODatabaseRaw(String iURL) {
        if (iURL == null) {
            throw new IllegalArgumentException("URL parameter is null");
        }
        try {
            this.url = iURL.replace('\\', '/');
            this.status = ODatabase.STATUS.CLOSED;
            this.setProperty("fetch-max", 50);
        }
        catch (Throwable t) {
            throw new ODatabaseException("Error on opening database '" + iURL + "'", t);
        }
    }

    @Override
    public <DB extends ODatabase> DB open(String iUserName, String iUserPassword) {
        try {
            if (this.status == ODatabase.STATUS.OPEN) {
                throw new IllegalStateException("Database " + this.getName() + " is already open");
            }
            if (this.storage == null) {
                this.storage = Orient.instance().loadStorage(this.url);
            }
            this.storage.open(iUserName, iUserPassword, this.properties);
            this.status = ODatabase.STATUS.OPEN;
            this.callOnOpenListeners();
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ODatabaseException("Cannot open database", e);
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabase> DB create() {
        try {
            if (this.status == ODatabase.STATUS.OPEN) {
                throw new IllegalStateException("Database " + this.getName() + " is already open");
            }
            if (this.storage == null) {
                this.storage = Orient.instance().loadStorage(this.url);
            }
            this.storage.create(this.properties);
            Iterator<ODatabaseLifecycleListener> it = Orient.instance().getDbLifecycleListeners();
            while (it.hasNext()) {
                it.next().onOpen(this.getDatabaseOwner());
            }
            for (ODatabaseListener listener : this.listeners) {
                try {
                    listener.onCreate(this);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.status = ODatabase.STATUS.OPEN;
        }
        catch (Exception e) {
            throw new ODatabaseException("Cannot create database", e);
        }
        return (DB)this;
    }

    @Override
    @Deprecated
    public void delete() {
        this.drop();
    }

    @Override
    public void drop() {
        ArrayList<ODatabaseListener> tmpListeners = new ArrayList<ODatabaseListener>(this.listeners);
        this.close();
        try {
            if (this.storage == null) {
                this.storage = Orient.instance().loadStorage(this.url);
            }
            this.storage.delete();
            this.storage = null;
            for (ODatabaseListener listener : tmpListeners) {
                try {
                    listener.onDelete(this);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.status = ODatabase.STATUS.CLOSED;
            ODatabaseRecordThreadLocal.INSTANCE.set(null);
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ODatabaseException("Cannot delete database", e);
        }
    }

    @Override
    public void reload() {
        this.storage.reload();
    }

    @Override
    public ODatabase.STATUS getStatus() {
        return this.status;
    }

    @Override
    public <DB extends ODatabase> DB setStatus(ODatabase.STATUS status) {
        this.status = status;
        return (DB)this;
    }

    public <DB extends ODatabase> DB setDefaultClusterId(int iDefClusterId) {
        this.storage.setDefaultClusterId(iDefClusterId);
        return (DB)this;
    }

    @Override
    public boolean exists() {
        if (this.status == ODatabase.STATUS.OPEN) {
            return true;
        }
        if (this.storage == null) {
            this.storage = Orient.instance().loadStorage(this.url);
        }
        return this.storage.exists();
    }

    @Override
    public long countClusterElements(String iClusterName) {
        int clusterId = this.getClusterIdByName(iClusterName);
        if (clusterId < 0) {
            throw new IllegalArgumentException("Cluster '" + iClusterName + "' was not found");
        }
        return this.storage.count(clusterId);
    }

    @Override
    public long countClusterElements(int iClusterId) {
        return this.storage.count(iClusterId);
    }

    @Override
    public long countClusterElements(int[] iClusterIds) {
        return this.storage.count(iClusterIds);
    }

    @Override
    public long countClusterElements(int iCurrentClusterId, boolean countTombstones) {
        return this.storage.count(iCurrentClusterId, countTombstones);
    }

    @Override
    public long countClusterElements(int[] iClusterIds, boolean countTombstones) {
        return this.storage.count(iClusterIds, countTombstones);
    }

    public OStorageOperationResult<ORawBuffer> read(ORecordId iRid, String iFetchPlan, boolean iIgnoreCache, boolean loadTombstones) {
        if (!iRid.isValid()) {
            return new OStorageOperationResult<Object>(null);
        }
        OFetchHelper.checkFetchPlanValid(iFetchPlan);
        try {
            return this.storage.readRecord(iRid, iFetchPlan, iIgnoreCache, null, loadTombstones);
        }
        catch (Throwable t) {
            if (iRid.isTemporary()) {
                throw new ODatabaseException("Error on retrieving record using temporary RecordId: " + iRid, t);
            }
            throw new ODatabaseException("Error on retrieving record " + iRid + " (cluster: " + this.storage.getPhysicalClusterNameById(iRid.clusterId) + ")", t);
        }
    }

    public OStorageOperationResult<ORecordVersion> save(int iDataSegmentId, ORecordId iRid, byte[] iContent, ORecordVersion iVersion, byte iRecordType, int iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<ORecordVersion> iRecordUpdatedCallback) {
        Orient.instance().getRecordFactoryManager().getRecordTypeClass(iRecordType);
        try {
            if (iForceCreate || iRid.clusterPosition.isNew()) {
                OStorageOperationResult<OPhysicalPosition> ppos = this.storage.createRecord(iDataSegmentId, iRid, iContent, iVersion, iRecordType, iMode, iRecordCreatedCallback);
                return new OStorageOperationResult<ORecordVersion>(ppos.getResult().recordVersion, ppos.isMoved());
            }
            return this.storage.updateRecord(iRid, iContent, iVersion, iRecordType, iMode, iRecordUpdatedCallback);
        }
        catch (OException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ODatabaseException("Error on saving record " + iRid, t);
        }
    }

    public boolean updateReplica(int dataSegmentId, ORecordId rid, byte[] content, ORecordVersion version, byte recordType) {
        Orient.instance().getRecordFactoryManager().getRecordTypeClass(recordType);
        try {
            if (rid.clusterPosition.isNew()) {
                throw new ODatabaseException("Passed in record was not stored and can not be treated as replica.");
            }
            return this.storage.updateReplica(dataSegmentId, rid, content, version, recordType);
        }
        catch (OException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ODatabaseException("Error on replica update " + rid, t);
        }
    }

    public OStorageOperationResult<Boolean> delete(ORecordId iRid, ORecordVersion iVersion, boolean iRequired, int iMode) {
        try {
            OStorageOperationResult<Boolean> result = this.storage.deleteRecord(iRid, iVersion, iMode, null);
            if (!result.getResult().booleanValue() && iRequired) {
                throw new ORecordNotFoundException("The record with id " + iRid + " was not found");
            }
            return result;
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error on deleting record " + iRid, e, ODatabaseException.class, new Object[0]);
            return new OStorageOperationResult<Boolean>(Boolean.FALSE);
        }
    }

    public boolean cleanOutRecord(ORecordId iRid, ORecordVersion iVersion, boolean iRequired, int iMode) {
        try {
            boolean result = this.storage.cleanOutRecord(iRid, iVersion, iMode, null);
            if (!result && iRequired) {
                throw new ORecordNotFoundException("The record with id " + iRid + " was not found");
            }
            return result;
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error on deleting record " + iRid, e, ODatabaseException.class, new Object[0]);
            return false;
        }
    }

    @Override
    public OStorage getStorage() {
        return this.storage;
    }

    @Override
    public void replaceStorage(OStorage iNewStorage) {
        this.storage = iNewStorage;
    }

    @Override
    public boolean isClosed() {
        return this.status == ODatabase.STATUS.CLOSED || this.storage.isClosed();
    }

    @Override
    public String getName() {
        return this.storage != null ? this.storage.getName() : this.url;
    }

    @Override
    public String getURL() {
        return this.url != null ? this.url : this.storage.getURL();
    }

    @Override
    public int getDataSegmentIdByName(String iDataSegmentName) {
        return this.storage.getDataSegmentIdByName(iDataSegmentName);
    }

    @Override
    public String getDataSegmentNameById(int dataSegmentId) {
        return this.storage.getDataSegmentById(dataSegmentId).getName();
    }

    @Override
    public int getClusters() {
        return this.storage.getClusters();
    }

    @Override
    public boolean existsCluster(String iClusterName) {
        return this.storage.getClusterNames().contains(iClusterName);
    }

    @Override
    public String getClusterType(String iClusterName) {
        return this.storage.getClusterTypeByName(iClusterName);
    }

    @Override
    public int getClusterIdByName(String iClusterName) {
        return this.storage.getClusterIdByName(iClusterName);
    }

    @Override
    public String getClusterNameById(int iClusterId) {
        if (iClusterId == -1) {
            return null;
        }
        return this.storage.getPhysicalClusterNameById(iClusterId);
    }

    @Override
    public long getClusterRecordSizeById(int iClusterId) {
        try {
            return this.storage.getClusterById(iClusterId).getRecordsSize();
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error on reading records size for cluster with id '" + iClusterId + "'", e, ODatabaseException.class, new Object[0]);
            return 0L;
        }
    }

    @Override
    public long getClusterRecordSizeByName(String iClusterName) {
        try {
            return this.storage.getClusterById(this.getClusterIdByName(iClusterName)).getRecordsSize();
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error on reading records size for cluster '" + iClusterName + "'", e, ODatabaseException.class, new Object[0]);
            return 0L;
        }
    }

    @Override
    public int addCluster(String iClusterName, OStorage.CLUSTER_TYPE iType, Object ... iParameters) {
        return this.addCluster(iType.toString(), iClusterName, null, null, iParameters);
    }

    @Override
    public int addCluster(String iType, String iClusterName, String iLocation, String iDataSegmentName, Object ... iParameters) {
        return this.storage.addCluster(iType, iClusterName, iLocation, iDataSegmentName, false, iParameters);
    }

    @Override
    public int addCluster(String iType, String iClusterName, int iRequestedId, String iLocation, String iDataSegmentName, Object ... iParameters) {
        return this.storage.addCluster(iType, iClusterName, iRequestedId, iLocation, iDataSegmentName, false, iParameters);
    }

    @Override
    public int addPhysicalCluster(String iClusterName, String iLocation, int iStartSize) {
        return this.storage.addCluster(OStorage.CLUSTER_TYPE.PHYSICAL.toString(), iClusterName, null, null, false, iLocation, iStartSize);
    }

    @Override
    public boolean dropCluster(String iClusterName, boolean iTruncate) {
        return this.storage.dropCluster(iClusterName, iTruncate);
    }

    @Override
    public boolean dropCluster(int iClusterId, boolean iTruncate) {
        return this.storage.dropCluster(iClusterId, iTruncate);
    }

    @Override
    public int addDataSegment(String iSegmentName, String iLocation) {
        return this.storage.addDataSegment(iSegmentName, iLocation);
    }

    @Override
    public boolean dropDataSegment(String iName) {
        return this.storage.dropDataSegment(iName);
    }

    @Override
    public Collection<String> getClusterNames() {
        return this.storage.getClusterNames();
    }

    @Override
    public OLevel1RecordCache getLevel1Cache() {
        return null;
    }

    @Override
    public int getDefaultClusterId() {
        return this.storage.getDefaultClusterId();
    }

    @Override
    public boolean declareIntent(OIntent iIntent) {
        if (this.currentIntent != null) {
            if (iIntent != null && iIntent.getClass().equals(this.currentIntent.getClass())) {
                return false;
            }
            this.currentIntent.end(this);
        }
        this.currentIntent = iIntent;
        if (iIntent != null) {
            iIntent.begin(this, new Object[0]);
        }
        return true;
    }

    public ODatabaseRecord getDatabaseOwner() {
        return this.databaseOwner;
    }

    public ODatabaseRaw setOwner(ODatabaseRecord iOwner) {
        this.databaseOwner = iOwner;
        return this;
    }

    @Override
    public Object setProperty(String iName, Object iValue) {
        if (iValue == null) {
            return this.properties.remove(iName.toLowerCase());
        }
        return this.properties.put(iName.toLowerCase(), iValue);
    }

    @Override
    public Object getProperty(String iName) {
        return this.properties.get(iName.toLowerCase());
    }

    @Override
    public Iterator<Map.Entry<String, Object>> getProperties() {
        return this.properties.entrySet().iterator();
    }

    @Override
    public void registerListener(ODatabaseListener iListener) {
        if (iListener == null) {
            return;
        }
        this.listeners.add(iListener);
    }

    @Override
    public void unregisterListener(ODatabaseListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public List<ODatabaseListener> getListeners() {
        return new ArrayList<ODatabaseListener>(this.listeners);
    }

    @Override
    public OLevel2RecordCache getLevel2Cache() {
        return this.storage.getLevel2Cache();
    }

    @Override
    public void close() {
        if (this.status != ODatabase.STATUS.OPEN) {
            return;
        }
        if (this.currentIntent != null) {
            this.currentIntent.end(this);
            this.currentIntent = null;
        }
        this.callOnCloseListeners();
        this.listeners.clear();
        if (this.storage != null) {
            this.storage.close();
        }
        this.storage = null;
        this.status = ODatabase.STATUS.CLOSED;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("OrientDB[");
        buffer.append(this.url != null ? this.url : "?");
        buffer.append(']');
        if (this.getStorage() != null) {
            buffer.append(" (users: ");
            buffer.append(this.getStorage().getUsers());
            buffer.append(')');
        }
        return buffer.toString();
    }

    @Override
    public Object get(ODatabase.ATTRIBUTES iAttribute) {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        switch (iAttribute) {
            case STATUS: {
                return this.getStatus();
            }
            case DEFAULTCLUSTERID: {
                return this.getDefaultClusterId();
            }
            case TYPE: {
                ODatabaseRecord db = this.getDatabaseOwner() instanceof ODatabaseRecord ? this.getDatabaseOwner() : new OGraphDatabase(this.url);
                return db.getMetadata().getSchema().existsClass("V") ? "graph" : "document";
            }
            case DATEFORMAT: {
                return this.storage.getConfiguration().dateFormat;
            }
            case DATETIMEFORMAT: {
                return this.storage.getConfiguration().dateTimeFormat;
            }
            case TIMEZONE: {
                return this.storage.getConfiguration().getTimeZone().getID();
            }
            case LOCALECOUNTRY: {
                return this.storage.getConfiguration().getLocaleCountry();
            }
            case LOCALELANGUAGE: {
                return this.storage.getConfiguration().getLocaleLanguage();
            }
            case CHARSET: {
                return this.storage.getConfiguration().getCharset();
            }
            case CUSTOM: {
                return this.storage.getConfiguration().properties;
            }
        }
        return null;
    }

    @Override
    public <DB extends ODatabase> DB set(ODatabase.ATTRIBUTES iAttribute, Object iValue) {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        switch (iAttribute) {
            case STATUS: {
                this.setStatus(ODatabase.STATUS.valueOf(stringValue.toUpperCase(Locale.ENGLISH)));
                break;
            }
            case DEFAULTCLUSTERID: {
                if (iValue == null) break;
                if (iValue instanceof Number) {
                    this.storage.setDefaultClusterId(((Number)iValue).intValue());
                    break;
                }
                this.storage.setDefaultClusterId(this.storage.getClusterIdByName(iValue.toString()));
                break;
            }
            case TYPE: {
                if (stringValue.equalsIgnoreCase("graph")) {
                    if (this.getDatabaseOwner() instanceof OGraphDatabase) {
                        ((OGraphDatabase)this.getDatabaseOwner()).checkForGraphSchema();
                        break;
                    }
                    if (this.getDatabaseOwner() instanceof ODatabaseRecordTx) {
                        new OGraphDatabase((ODatabaseRecordTx)this.getDatabaseOwner()).checkForGraphSchema();
                        break;
                    }
                    new OGraphDatabase(this.url).checkForGraphSchema();
                    break;
                }
                throw new IllegalArgumentException("Database type '" + stringValue + "' is not supported");
            }
            case DATEFORMAT: {
                this.storage.getConfiguration().dateFormat = stringValue;
                this.storage.getConfiguration().update();
                break;
            }
            case DATETIMEFORMAT: {
                this.storage.getConfiguration().dateTimeFormat = stringValue;
                this.storage.getConfiguration().update();
                break;
            }
            case TIMEZONE: {
                this.storage.getConfiguration().setTimeZone(TimeZone.getTimeZone(stringValue.toUpperCase()));
                this.storage.getConfiguration().update();
                break;
            }
            case LOCALECOUNTRY: {
                this.storage.getConfiguration().setLocaleCountry(stringValue);
                this.storage.getConfiguration().update();
                break;
            }
            case LOCALELANGUAGE: {
                this.storage.getConfiguration().setLocaleLanguage(stringValue);
                this.storage.getConfiguration().update();
                break;
            }
            case CHARSET: {
                this.storage.getConfiguration().setCharset(stringValue);
                this.storage.getConfiguration().update();
                break;
            }
            case CUSTOM: {
                if (iValue.toString().indexOf("=") == -1) {
                    if (iValue.toString().equalsIgnoreCase("clear")) {
                        this.clearCustomInternal();
                        break;
                    }
                    throw new IllegalArgumentException("Syntax error: expected <name> = <value> or clear, instead found: " + iValue);
                }
                List<String> words = OStringSerializerHelper.smartSplit(iValue.toString(), '=', new char[0]);
                this.setCustomInternal(words.get(0).trim(), words.get(1).trim());
                break;
            }
            default: {
                throw new IllegalArgumentException("Option '" + (Object)((Object)iAttribute) + "' not supported on alter database");
            }
        }
        return (DB)this;
    }

    public String getCustom(String iName) {
        if (this.storage.getConfiguration().properties == null) {
            return null;
        }
        for (OStorageEntryConfiguration e : this.storage.getConfiguration().properties) {
            if (!e.name.equals(iName)) continue;
            return e.value;
        }
        return null;
    }

    public void setCustomInternal(String iName, String iValue) {
        if (iValue == null || "null".equalsIgnoreCase(iValue)) {
            if (this.storage.getConfiguration().properties != null) {
                Iterator<OStorageEntryConfiguration> it = this.storage.getConfiguration().properties.iterator();
                while (it.hasNext()) {
                    OStorageEntryConfiguration e = it.next();
                    if (!e.name.equals(iName)) continue;
                    it.remove();
                    break;
                }
            }
        } else {
            if (this.storage.getConfiguration().properties == null) {
                this.storage.getConfiguration().properties = new ArrayList<OStorageEntryConfiguration>();
            }
            boolean found = false;
            for (OStorageEntryConfiguration e : this.storage.getConfiguration().properties) {
                if (!e.name.equals(iName)) continue;
                e.value = iValue;
                found = true;
                break;
            }
            if (!found) {
                this.storage.getConfiguration().properties.add(new OStorageEntryConfiguration(iName, iValue));
            }
        }
        this.storage.getConfiguration().update();
    }

    public void clearCustomInternal() {
        this.storage.getConfiguration().properties = null;
    }

    @Override
    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        return this.storage.callInLock(iCallable, iExclusiveLock);
    }

    @Override
    public <V> V callInRecordLock(Callable<V> iCallable, ORID rid, boolean iExclusiveLock) {
        return this.storage.callInRecordLock(iCallable, rid, iExclusiveLock);
    }

    @Override
    public ORecordMetadata getRecordMetadata(ORID rid) {
        return this.storage.getRecordMetadata(rid);
    }

    public void callOnOpenListeners() {
        Iterator<ODatabaseLifecycleListener> it = Orient.instance().getDbLifecycleListeners();
        while (it.hasNext()) {
            it.next().onOpen(this.getDatabaseOwner());
        }
        for (ODatabaseListener listener : new ArrayList<ODatabaseListener>(this.listeners)) {
            try {
                listener.onOpen(this.getDatabaseOwner());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void callOnCloseListeners() {
        Iterator<ODatabaseLifecycleListener> it = Orient.instance().getDbLifecycleListeners();
        while (it.hasNext()) {
            it.next().onClose(this.getDatabaseOwner());
        }
        for (ODatabaseListener listener : new ArrayList<ODatabaseListener>(this.listeners)) {
            try {
                listener.onClose(this.getDatabaseOwner());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    protected boolean isClusterBoundedToClass(int iClusterId) {
        return false;
    }

    @Override
    public long getSize() {
        return this.storage.getSize();
    }

    @Override
    public void freeze() {
        if (!(this.getStorage() instanceof OStorageLocalAbstract)) {
            OLogManager.instance().error((Object)this, "We can not freeze non local storage.", new Object[0]);
            return;
        }
        OStorageLocalAbstract storage = (OStorageLocalAbstract)this.getStorage();
        storage.freeze(false);
    }

    @Override
    public void freeze(boolean throwException) {
        if (!(this.getStorage() instanceof OStorageLocalAbstract)) {
            OLogManager.instance().error((Object)this, "We can not freeze non local storage.", new Object[0]);
            return;
        }
        OStorageLocalAbstract storage = (OStorageLocalAbstract)this.getStorage();
        storage.freeze(throwException);
    }

    @Override
    public void release() {
        if (!(this.getStorage() instanceof OStorageLocalAbstract)) {
            OLogManager.instance().error((Object)this, "We can not freeze non local storage.", new Object[0]);
            return;
        }
        OStorageLocalAbstract storage = (OStorageLocalAbstract)this.getStorage();
        storage.release();
    }

    @Override
    public void freezeCluster(int iClusterId) {
        this.freezeCluster(iClusterId, false);
    }

    @Override
    public void releaseCluster(int iClusterId) {
        if (!(this.getStorage() instanceof OLocalPaginatedStorage)) {
            OLogManager.instance().error((Object)this, "We can not freeze non local storage.", new Object[0]);
            return;
        }
        OLocalPaginatedStorage storage = (OLocalPaginatedStorage)this.getStorage();
        storage.release(iClusterId);
    }

    @Override
    public void freezeCluster(int iClusterId, boolean throwException) {
        if (this.getStorage() instanceof OLocalPaginatedStorage) {
            OLocalPaginatedStorage paginatedStorage = (OLocalPaginatedStorage)this.getStorage();
            paginatedStorage.freeze(throwException, iClusterId);
        } else {
            OLogManager.instance().error((Object)this, "Only local paginated storage supports cluster freeze.", new Object[0]);
        }
    }
}

