/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseRecordWrapperAbstract;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalAbstract;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ODatabaseDocumentTx
extends ODatabaseRecordWrapperAbstract<ODatabaseRecordTx>
implements ODatabaseDocument {
    public ODatabaseDocumentTx(String iURL) {
        super(new ODatabaseRecordTx(iURL, 100));
    }

    public ODatabaseDocumentTx(ODatabaseRecordTx iSource) {
        super(iSource);
    }

    private void freezeIndexes(List<OIndexAbstract<?>> indexesToFreeze, boolean throwException) {
        if (indexesToFreeze != null) {
            for (OIndexAbstract<?> indexToLock : indexesToFreeze) {
                indexToLock.freeze(throwException);
            }
        }
    }

    private void flushIndexes(List<OIndexAbstract<?>> indexesToFlush) {
        for (OIndexAbstract<?> index : indexesToFlush) {
            index.flush();
        }
    }

    private List<OIndexAbstract<?>> prepareIndexesToFreeze(Collection<? extends OIndex<?>> indexes) {
        ArrayList<OIndexAbstract> indexesToFreeze = null;
        if (indexes != null && !indexes.isEmpty()) {
            indexesToFreeze = new ArrayList<OIndexAbstract>(indexes.size());
            for (OIndex<?> index : indexes) {
                indexesToFreeze.add((OIndexAbstract)index.getInternal());
            }
            Collections.sort(indexesToFreeze, new Comparator<OIndex<?>>(){

                @Override
                public int compare(OIndex<?> o1, OIndex<?> o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
        return indexesToFreeze;
    }

    private void releaseIndexes(Collection<? extends OIndex<?>> indexesToRelease) {
        if (indexesToRelease != null) {
            Iterator<OIndex<?>> it = indexesToRelease.iterator();
            while (it.hasNext()) {
                it.next().getInternal().release();
                it.remove();
            }
        }
    }

    @Override
    public void freeze(boolean throwException) {
        if (!(this.getStorage() instanceof OStorageLocalAbstract)) {
            OLogManager.instance().error((Object)this, "We can not freeze non local storage. If you use remote client please use OServerAdmin instead.", new Object[0]);
            return;
        }
        long startTime = Orient.instance().getProfiler().startChrono();
        Collection<? extends OIndex<?>> indexes = this.getMetadata().getIndexManager().getIndexes();
        List<OIndexAbstract<?>> indexesToLock = this.prepareIndexesToFreeze(indexes);
        this.freezeIndexes(indexesToLock, true);
        this.flushIndexes(indexesToLock);
        super.freeze(throwException);
        Orient.instance().getProfiler().stopChrono("db." + this.getName() + ".freeze", "Time to freeze the database", startTime, "db.*.freeze");
    }

    @Override
    public void freeze() {
        if (!(this.getStorage() instanceof OStorageLocalAbstract)) {
            OLogManager.instance().error((Object)this, "We can not freeze non local storage. If you use remote client please use OServerAdmin instead.", new Object[0]);
            return;
        }
        long startTime = Orient.instance().getProfiler().startChrono();
        Collection<? extends OIndex<?>> indexes = this.getMetadata().getIndexManager().getIndexes();
        List<OIndexAbstract<?>> indexesToLock = this.prepareIndexesToFreeze(indexes);
        this.freezeIndexes(indexesToLock, false);
        this.flushIndexes(indexesToLock);
        super.freeze();
        Orient.instance().getProfiler().stopChrono("db." + this.getName() + ".freeze", "Time to freeze the database", startTime, "db.*.freeze");
    }

    @Override
    public void release() {
        if (!(this.getStorage() instanceof OStorageLocalAbstract)) {
            OLogManager.instance().error((Object)this, "We can not release non local storage. If you use remote client please use OServerAdmin instead.", new Object[0]);
            return;
        }
        long startTime = Orient.instance().getProfiler().startChrono();
        super.release();
        Collection<? extends OIndex<?>> indexes = this.getMetadata().getIndexManager().getIndexes();
        this.releaseIndexes(indexes);
        Orient.instance().getProfiler().stopChrono("db." + this.getName() + ".release", "Time to release the database", startTime, "db.*.release");
    }

    @Override
    public ODocument newInstance() {
        return new ODocument();
    }

    @Override
    public ODocument newInstance(String iClassName) {
        this.checkSecurity("database.class", ORole.PERMISSION_CREATE, (Object)iClassName);
        return new ODocument(iClassName);
    }

    @Override
    public ORecordIteratorClass<ODocument> browseClass(String iClassName) {
        return this.browseClass(iClassName, true);
    }

    @Override
    public ORecordIteratorClass<ODocument> browseClass(String iClassName, boolean iPolymorphic) {
        if (this.getMetadata().getSchema().getClass(iClassName) == null) {
            throw new IllegalArgumentException("Class '" + iClassName + "' not found in current database");
        }
        this.checkSecurity("database.class", ORole.PERMISSION_READ, (Object)iClassName);
        return new ORecordIteratorClass<ODocument>(this, (ODatabaseRecord)this.underlying, iClassName, iPolymorphic, true, false);
    }

    @Override
    public ORecordIteratorCluster<ODocument> browseCluster(String iClusterName) {
        this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)iClusterName);
        return new ORecordIteratorCluster<ODocument>((ODatabaseRecord)this, (ODatabaseRecordAbstract)this.underlying, this.getClusterIdByName(iClusterName), true);
    }

    public ORecordIteratorCluster<ODocument> browseCluster(String iClusterName, OClusterPosition startClusterPosition, OClusterPosition endClusterPosition, boolean loadTombstones) {
        this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)iClusterName);
        return new ORecordIteratorCluster<ODocument>(this, (ODatabaseRecordAbstract)this.underlying, this.getClusterIdByName(iClusterName), startClusterPosition, endClusterPosition, true, loadTombstones);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iRecord) {
        return this.save(iRecord, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, false, (ORecordCallback<? extends Number>)null, (ORecordCallback<ORecordVersion>)null);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iRecord, ODatabaseComplex.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<ORecordVersion> iRecordUpdatedCallback) {
        if (!(iRecord instanceof ODocument)) {
            return super.save(iRecord, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
        }
        ODocument doc = (ODocument)iRecord;
        doc.validate();
        doc.convertAllMultiValuesToTrackedVersions();
        try {
            if (iForceCreate || doc.getIdentity().isNew()) {
                if (doc.getClassName() != null) {
                    this.checkSecurity("database.class", ORole.PERMISSION_CREATE, (Object)doc.getClassName());
                }
                if (doc.getSchemaClass() != null && doc.getIdentity().getClusterId() < 0) {
                    String clusterName = this.getClusterNameById(doc.getSchemaClass().getDefaultClusterId());
                    return super.save(doc, clusterName, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
                }
            } else if (doc.getClassName() != null) {
                this.checkSecurity("database.class", ORole.PERMISSION_UPDATE, (Object)doc.getClassName());
            }
            doc = (ODocument)super.save(doc, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error on saving record %s of class '%s'", e, ODatabaseException.class, new Object[]{iRecord.getIdentity(), doc.getClassName() != null ? doc.getClassName() : "?"});
        }
        return (RET)doc;
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iRecord, String iClusterName) {
        return this.save(iRecord, iClusterName, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, false, (ORecordCallback<? extends Number>)null, (ORecordCallback<ORecordVersion>)null);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iRecord, String iClusterName, ODatabaseComplex.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<ORecordVersion> iRecordUpdatedCallback) {
        if (!(iRecord instanceof ODocument)) {
            return super.save(iRecord, iClusterName, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
        }
        ODocument doc = (ODocument)iRecord;
        if (iForceCreate || !doc.getIdentity().isValid()) {
            int id;
            if (doc.getClassName() != null) {
                this.checkSecurity("database.class", ORole.PERMISSION_CREATE, (Object)doc.getClassName());
            }
            if (iClusterName == null && doc.getSchemaClass() != null) {
                iClusterName = this.getClusterNameById(doc.getSchemaClass().getDefaultClusterId());
            }
            if ((id = this.getClusterIdByName(iClusterName)) == -1) {
                throw new IllegalArgumentException("Cluster name " + iClusterName + " is not configured");
            }
            if (doc.getSchemaClass() != null) {
                int[] clusterIds = doc.getSchemaClass().getClusterIds();
                int i = 0;
                while (i < clusterIds.length) {
                    if (clusterIds[i] == id) break;
                    ++i;
                }
                if (i == clusterIds.length) {
                    throw new IllegalArgumentException("Cluster name " + iClusterName + " is not configured to store the class " + doc.getClassName());
                }
            } else {
                int[] nArray = new int[]{id};
            }
        } else if (doc.getClassName() != null) {
            this.checkSecurity("database.class", ORole.PERMISSION_UPDATE, (Object)doc.getClassName());
        }
        doc.validate();
        doc.convertAllMultiValuesToTrackedVersions();
        doc = (ODocument)super.save(doc, iClusterName, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
        return (RET)doc;
    }

    public ODatabaseDocumentTx delete(ORecordInternal<?> iRecord) {
        if (iRecord == null) {
            throw new ODatabaseException("Cannot delete null document");
        }
        if (iRecord instanceof ODocument && ((ODocument)iRecord).getClassName() != null) {
            this.checkSecurity("database.class", ORole.PERMISSION_DELETE, (Object)((ODocument)iRecord).getClassName());
        }
        try {
            ((ODatabaseRecordTx)this.underlying).delete(iRecord);
        }
        catch (Exception e) {
            if (iRecord instanceof ODocument) {
                OLogManager.instance().exception("Error on deleting record %s of class '%s'", e, ODatabaseException.class, new Object[]{iRecord.getIdentity(), ((ODocument)iRecord).getClassName()});
            }
            OLogManager.instance().exception("Error on deleting record %s", e, ODatabaseException.class, new Object[]{iRecord.getIdentity()});
        }
        return this;
    }

    @Override
    public long countClass(String iClassName) {
        OClass cls = this.getMetadata().getSchema().getClass(iClassName);
        if (cls == null) {
            throw new IllegalArgumentException("Class '" + iClassName + "' not found in database");
        }
        return cls.count();
    }

    @Override
    public ODatabaseComplex<ORecordInternal<?>> commit() {
        try {
            ODatabaseRecord oDatabaseRecord = ((ODatabaseRecordTx)this.underlying).commit();
            return oDatabaseRecord;
        }
        finally {
            this.getTransaction().close();
        }
    }

    @Override
    public ODatabaseComplex<ORecordInternal<?>> rollback() {
        try {
            ODatabaseRecord oDatabaseRecord = ((ODatabaseRecordTx)this.underlying).rollback();
            return oDatabaseRecord;
        }
        finally {
            this.getTransaction().close();
        }
    }

    @Override
    public String getType() {
        return "document";
    }
}

