/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.concur.resource.OAdaptiveLock;
import com.orientechnologies.common.concur.resource.OResourcePool;
import com.orientechnologies.common.concur.resource.OResourcePoolListener;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.OOrientListener;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabasePooled;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class ODatabasePoolAbstract<DB extends ODatabase>
extends OAdaptiveLock
implements OResourcePoolListener<String, DB>,
OOrientListener {
    private final HashMap<String, OResourcePool<String, DB>> pools = new HashMap();
    private int maxSize;
    private int timeout;
    protected Object owner;

    public ODatabasePoolAbstract(Object iOwner, int iMinSize, int iMaxSize) {
        this(iOwner, iMinSize, iMaxSize, OGlobalConfiguration.CLIENT_CONNECT_POOL_WAIT_TIMEOUT.getValueAsInteger());
    }

    public ODatabasePoolAbstract(Object iOwner, int iMinSize, int iMaxSize, int iTimeout) {
        super(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), OGlobalConfiguration.STORAGE_LOCK_TIMEOUT.getValueAsInteger(), true);
        this.maxSize = iMaxSize;
        this.timeout = iTimeout;
        this.owner = iOwner;
        Orient.instance().registerListener(this);
    }

    public DB acquire(String iURL, String iUserName, String iUserPassword) throws OLockException {
        return this.acquire(iURL, iUserName, iUserPassword, null);
    }

    public DB acquire(String iURL, String iUserName, String iUserPassword, Map<String, Object> iOptionalParams) throws OLockException {
        String dbPooledName = OIOUtils.getUnixFileName((String)(String.valueOf(iUserName) + "@" + iURL));
        this.lock();
        try {
            OResourcePool pool = this.pools.get(dbPooledName);
            if (pool == null) {
                pool = new OResourcePool(this.maxSize, (OResourcePoolListener)this);
            }
            ODatabase db = (ODatabase)pool.getResource((Object)iURL, (long)this.timeout, new Object[]{iUserName, iUserPassword, iOptionalParams});
            this.pools.put(dbPooledName, pool);
            ODatabase oDatabase = db;
            return (DB)oDatabase;
        }
        finally {
            this.unlock();
        }
    }

    public void release(DB iDatabase) {
        String dbPooledName = iDatabase instanceof ODatabaseComplex ? String.valueOf(((ODatabaseComplex)iDatabase).getUser().getName()) + "@" + iDatabase.getURL() : iDatabase.getURL();
        this.lock();
        try {
            OResourcePool<String, DB> pool = this.pools.get(dbPooledName);
            if (pool == null) {
                throw new OLockException("Cannot release a database URL not acquired before. URL: " + iDatabase.getName());
            }
            pool.returnResource(iDatabase);
        }
        finally {
            this.unlock();
        }
    }

    public DB reuseResource(String iKey, DB iValue) {
        return iValue;
    }

    public Map<String, OResourcePool<String, DB>> getPools() {
        this.lock();
        try {
            Map<String, OResourcePool<String, DB>> map = Collections.unmodifiableMap(this.pools);
            return map;
        }
        finally {
            this.unlock();
        }
    }

    public void close() {
        this.lock();
        try {
            for (Map.Entry<String, OResourcePool<String, DB>> pool : this.pools.entrySet()) {
                for (ODatabase db : pool.getValue().getResources()) {
                    pool.getValue().close();
                    try {
                        OLogManager.instance().debug((Object)this, "Closing pooled database '%s'...", new Object[]{db.getName()});
                        ((ODatabasePooled)((Object)db)).forceClose();
                        OLogManager.instance().debug((Object)this, "OK", new Object[]{db.getName()});
                    }
                    catch (Exception e) {
                        OLogManager.instance().debug((Object)this, "Error: %d", new Object[]{e.toString()});
                    }
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    public void remove(String iName, String iUser) {
        this.remove(String.valueOf(iUser) + "@" + iName);
    }

    public void remove(String iPoolName) {
        this.lock();
        try {
            OResourcePool<String, DB> pool = this.pools.get(iPoolName);
            if (pool != null) {
                for (ODatabase db : pool.getResources()) {
                    if (db.getStorage().getStatus() != OStorage.STATUS.OPEN) continue;
                    try {
                        OLogManager.instance().debug((Object)this, "Closing pooled database '%s'...", new Object[]{db.getName()});
                        ((ODatabasePooled)((Object)db)).forceClose();
                        OLogManager.instance().debug((Object)this, "OK", new Object[]{db.getName()});
                    }
                    catch (Exception e) {
                        OLogManager.instance().debug((Object)this, "Error: %d", new Object[]{e.toString()});
                    }
                }
                pool.close();
                this.pools.remove(iPoolName);
            }
        }
        finally {
            this.unlock();
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void onStorageRegistered(OStorage iStorage) {
    }

    @Override
    public void onStorageUnregistered(OStorage iStorage) {
        String storageURL = iStorage.getURL();
        this.lock();
        try {
            HashSet<String> poolToClose = null;
            for (Map.Entry<String, OResourcePool<String, DB>> e : this.pools.entrySet()) {
                int pos = e.getKey().indexOf("@");
                String dbName = e.getKey().substring(pos + 1);
                if (!storageURL.equals(dbName)) continue;
                if (poolToClose == null) {
                    poolToClose = new HashSet<String>();
                }
                poolToClose.add(e.getKey());
            }
            if (poolToClose != null) {
                for (String pool : poolToClose) {
                    this.remove(pool);
                }
            }
        }
        finally {
            this.unlock();
        }
    }
}

