/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.graph.OGraphDatabase;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.WeakHashMap;

public class ODatabaseFactory {
    final WeakHashMap<ODatabaseComplex<?>, Thread> instances = new WeakHashMap();

    public synchronized List<ODatabaseComplex<?>> getInstances(String iDatabaseName) {
        ArrayList result = new ArrayList();
        for (ODatabaseComplex<?> i : this.instances.keySet()) {
            if (i == null || !i.getName().equals(iDatabaseName)) continue;
            result.add(i);
        }
        return result;
    }

    public synchronized ODatabaseComplex<?> register(ODatabaseComplex<?> db) {
        this.instances.put(db, Thread.currentThread());
        return db;
    }

    public synchronized void unregister(ODatabaseComplex<?> db) {
        this.instances.remove(db);
    }

    public synchronized void unregister(OStorage iStorage) {
        for (ODatabaseComplex<?> db : new HashSet(this.instances.keySet())) {
            if (db == null || db.getStorage() != iStorage) continue;
            db.close();
            this.instances.remove(db);
        }
    }

    public synchronized void shutdown() {
        if (this.instances.size() > 0) {
            OLogManager.instance().debug(null, "Found %d databases opened during OrientDB shutdown. Assure to always close database instances after usage", new Object[]{this.instances.size()});
            for (ODatabaseComplex<?> db : new HashSet(this.instances.keySet())) {
                if (db == null || db.isClosed()) continue;
                db.close();
            }
        }
    }

    public ODatabaseDocumentTx createDatabase(String iType, String url) {
        if ("graph".equals(iType)) {
            return new OGraphDatabase(url);
        }
        return new ODatabaseDocumentTx(url);
    }

    public ODatabaseDocumentTx createObjectDatabase(String url) {
        return new ODatabaseDocumentTx(url);
    }

    public OGraphDatabase createGraphDatabase(String url) {
        return new OGraphDatabase(url);
    }

    public ODatabaseDocumentTx createDocumentDatabase(String url) {
        return new ODatabaseDocumentTx(url);
    }
}

