/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.config;

import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterHoleConfiguration;
import com.orientechnologies.orient.core.config.OStorageDataConfiguration;
import com.orientechnologies.orient.core.config.OStorageDataHoleConfiguration;
import com.orientechnologies.orient.core.config.OStorageEHClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import com.orientechnologies.orient.core.config.OStorageMemoryClusterConfiguration;
import com.orientechnologies.orient.core.config.OStoragePaginatedClusterConfiguration;
import com.orientechnologies.orient.core.config.OStoragePhysicalClusterConfigurationLocal;
import com.orientechnologies.orient.core.config.OStorageSegmentConfiguration;
import com.orientechnologies.orient.core.config.OStorageTxConfiguration;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.OClusterPositionFactory;
import com.orientechnologies.orient.core.id.OImmutableRecordId;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalAbstract;
import com.orientechnologies.orient.core.version.OVersionFactory;
import java.io.IOException;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class OStorageConfiguration
implements OSerializableStream {
    public static final ORecordId CONFIG_RID = new OImmutableRecordId(0, OClusterPositionFactory.INSTANCE.valueOf(0L));
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final int CURRENT_VERSION = 5;
    public int version = -1;
    public String name;
    public String schemaRecordId;
    public String dictionaryRecordId;
    public String indexMgrRecordId;
    private String localeLanguage = Locale.getDefault().getLanguage();
    private String localeCountry = Locale.getDefault().getCountry();
    public String dateFormat = "yyyy-MM-dd";
    public String dateTimeFormat = "yyyy-MM-dd HH:mm:ss";
    private TimeZone timeZone = TimeZone.getDefault();
    private String charset = "UTF-8";
    public OStorageSegmentConfiguration fileTemplate;
    public List<OStorageClusterConfiguration> clusters = new ArrayList<OStorageClusterConfiguration>();
    public List<OStorageDataConfiguration> dataSegments = new ArrayList<OStorageDataConfiguration>();
    public OStorageTxConfiguration txSegment = new OStorageTxConfiguration();
    public List<OStorageEntryConfiguration> properties = new ArrayList<OStorageEntryConfiguration>();
    private transient Locale localeInstance;
    private transient DecimalFormatSymbols unusualSymbols;
    protected transient OStorage storage;

    public OStorageConfiguration(OStorage iStorage) {
        this.storage = iStorage;
        this.fileTemplate = new OStorageSegmentConfiguration();
    }

    public OStorageConfiguration load() throws OSerializationException {
        byte[] record = this.storage.readRecord((ORecordId)OStorageConfiguration.CONFIG_RID, null, (boolean)false, null, (boolean)false).getResult().buffer;
        if (record == null) {
            throw new OStorageException("Cannot load database's configuration. The database seems to be corrupted.");
        }
        this.fromStream(record);
        return this;
    }

    public void update() throws OSerializationException {
        byte[] record = this.toStream();
        this.storage.updateRecord(CONFIG_RID, record, OVersionFactory.instance().createUntrackedVersion(), (byte)98, 0, null);
    }

    public boolean isEmpty() {
        return this.clusters.isEmpty();
    }

    public String getDirectory() {
        return this.fileTemplate.location != null ? this.fileTemplate.getLocation() : ((OStorageLocalAbstract)this.storage).getStoragePath();
    }

    public Locale getLocaleInstance() {
        if (this.localeInstance == null) {
            this.localeInstance = new Locale(this.localeLanguage, this.localeCountry);
        }
        return this.localeInstance;
    }

    public void resetLocaleInstance() {
        this.localeInstance = null;
    }

    public SimpleDateFormat getDateFormatInstance() {
        SimpleDateFormat dateFormatInstance = new SimpleDateFormat(this.dateFormat);
        dateFormatInstance.setLenient(false);
        dateFormatInstance.setTimeZone(this.timeZone);
        return dateFormatInstance;
    }

    public SimpleDateFormat getDateTimeFormatInstance() {
        SimpleDateFormat dateTimeFormatInstance = new SimpleDateFormat(this.dateTimeFormat);
        dateTimeFormatInstance.setLenient(false);
        dateTimeFormatInstance.setTimeZone(this.timeZone);
        return dateTimeFormatInstance;
    }

    public DecimalFormatSymbols getUnusualSymbols() {
        if (this.unusualSymbols == null) {
            this.unusualSymbols = new DecimalFormatSymbols(this.getLocaleInstance());
        }
        return this.unusualSymbols;
    }

    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        String[] values = new String(iStream).split("\\|");
        int index = 0;
        this.version = Integer.parseInt(this.read(values[index++]));
        this.name = this.read(values[index++]);
        this.schemaRecordId = this.read(values[index++]);
        this.dictionaryRecordId = this.read(values[index++]);
        this.indexMgrRecordId = this.version > 0 ? this.read(values[index++]) : null;
        this.localeLanguage = this.read(values[index++]);
        this.localeCountry = this.read(values[index++]);
        this.dateFormat = this.read(values[index++]);
        this.dateTimeFormat = this.read(values[index++]);
        if (this.version >= 4) {
            this.timeZone = TimeZone.getTimeZone(this.read(values[index++]));
            this.charset = this.read(values[index++]);
        }
        if (this.version > 1) {
            index = this.phySegmentFromStream(values, index, this.fileTemplate);
        }
        int size = Integer.parseInt(this.read(values[index++]));
        this.clusters = new ArrayList<OStorageClusterConfiguration>(size);
        int i = 0;
        while (i < size) {
            int clusterId;
            if ((clusterId = Integer.parseInt(this.read(values[index++]))) != -1) {
                OStorageClusterConfiguration currentCluster;
                String clusterType;
                String clusterName = this.read(values[index++]);
                int targetDataSegmentId = this.version >= 3 ? Integer.parseInt(this.read(values[index++])) : 0;
                if ((clusterType = this.read(values[index++])).equals("p")) {
                    OStoragePhysicalClusterConfigurationLocal phyClusterLocal = new OStoragePhysicalClusterConfigurationLocal(this, clusterId, targetDataSegmentId);
                    phyClusterLocal.name = clusterName;
                    index = this.phySegmentFromStream(values, index, phyClusterLocal);
                    String holeFlag = this.version > 4 ? this.read(values[index++]) : "f";
                    if (holeFlag.equals("f")) {
                        phyClusterLocal.setHoleFile(new OStorageClusterHoleConfiguration(phyClusterLocal, this.read(values[index++]), this.read(values[index++]), this.read(values[index++])));
                    }
                    currentCluster = phyClusterLocal;
                } else if (clusterType.equals("m")) {
                    currentCluster = new OStorageMemoryClusterConfiguration(clusterName, clusterId, targetDataSegmentId);
                } else if (clusterType.equals("h")) {
                    currentCluster = new OStorageEHClusterConfiguration(this, clusterId, clusterName, null, targetDataSegmentId);
                } else if (clusterType.equals("d")) {
                    currentCluster = new OStoragePaginatedClusterConfiguration(this, clusterId, clusterName, null, Boolean.valueOf(this.read(values[index++])), Float.valueOf(this.read(values[index++])).floatValue(), Float.valueOf(this.read(values[index++])).floatValue(), this.read(values[index++]));
                } else {
                    throw new IllegalArgumentException("Unsupported cluster type: " + clusterType);
                }
                int c = this.clusters.size();
                while (c <= clusterId) {
                    this.clusters.add(null);
                    ++c;
                }
                this.clusters.set(clusterId, currentCluster);
            }
            ++i;
        }
        size = Integer.parseInt(this.read(values[index++]));
        this.dataSegments = new ArrayList<OStorageDataConfiguration>(size);
        i = 0;
        while (i < size) {
            this.dataSegments.add(null);
            ++i;
        }
        int i2 = 0;
        while (i2 < size) {
            int dataId;
            if ((dataId = Integer.parseInt(this.read(values[index++]))) != -1) {
                String dataName = this.read(values[index++]);
                OStorageDataConfiguration data = new OStorageDataConfiguration(this, dataName, dataId);
                index = this.phySegmentFromStream(values, index, data);
                data.holeFile = new OStorageDataHoleConfiguration(data, this.read(values[index++]), this.read(values[index++]), this.read(values[index++]));
                this.dataSegments.set(dataId, data);
            }
            ++i2;
        }
        this.txSegment = new OStorageTxConfiguration(this.read(values[index++]), this.read(values[index++]), this.read(values[index++]), this.read(values[index++]), this.read(values[index++]));
        size = Integer.parseInt(this.read(values[index++]));
        this.properties = new ArrayList<OStorageEntryConfiguration>(size);
        i2 = 0;
        while (i2 < size) {
            this.properties.add(new OStorageEntryConfiguration(this.read(values[index++]), this.read(values[index++])));
            ++i2;
        }
        return this;
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        StringBuilder buffer = new StringBuilder();
        this.write(buffer, 5);
        this.write(buffer, this.name);
        this.write(buffer, this.schemaRecordId);
        this.write(buffer, this.dictionaryRecordId);
        this.write(buffer, this.indexMgrRecordId);
        this.write(buffer, this.localeLanguage);
        this.write(buffer, this.localeCountry);
        this.write(buffer, this.dateFormat);
        this.write(buffer, this.dateTimeFormat);
        this.write(buffer, this.timeZone.getID());
        this.write(buffer, this.charset);
        this.phySegmentToStream(buffer, this.fileTemplate);
        this.write(buffer, this.clusters.size());
        for (OStorageClusterConfiguration c : this.clusters) {
            if (c == null) {
                this.write(buffer, -1);
                continue;
            }
            this.write(buffer, c.getId());
            this.write(buffer, c.getName());
            this.write(buffer, c.getDataSegmentId());
            if (c instanceof OStoragePhysicalClusterConfigurationLocal) {
                this.write(buffer, "p");
                this.phySegmentToStream(buffer, (OStoragePhysicalClusterConfigurationLocal)c);
                OStorageFileConfiguration holeFile = ((OStoragePhysicalClusterConfigurationLocal)c).getHoleFile();
                if (holeFile == null) {
                    this.write(buffer, "e");
                } else {
                    this.write(buffer, "f");
                }
                if (holeFile == null) continue;
                this.fileToStream(buffer, holeFile);
                continue;
            }
            if (c instanceof OStorageMemoryClusterConfiguration) {
                this.write(buffer, "m");
                continue;
            }
            if (c instanceof OStorageEHClusterConfiguration) {
                this.write(buffer, "h");
                continue;
            }
            if (!(c instanceof OStoragePaginatedClusterConfiguration)) continue;
            this.write(buffer, "d");
            OStoragePaginatedClusterConfiguration paginatedClusterConfiguration = (OStoragePaginatedClusterConfiguration)c;
            this.write(buffer, paginatedClusterConfiguration.useWal);
            this.write(buffer, Float.valueOf(paginatedClusterConfiguration.recordOverflowGrowFactor));
            this.write(buffer, Float.valueOf(paginatedClusterConfiguration.recordGrowFactor));
            this.write(buffer, paginatedClusterConfiguration.compression);
        }
        this.write(buffer, this.dataSegments.size());
        for (OStorageDataConfiguration d : this.dataSegments) {
            if (d == null) {
                this.write(buffer, -1);
                continue;
            }
            this.write(buffer, d.id);
            this.write(buffer, d.name);
            this.phySegmentToStream(buffer, d);
            this.fileToStream(buffer, d.holeFile);
        }
        this.fileToStream(buffer, this.txSegment);
        this.write(buffer, this.txSegment.isSynchRecord());
        this.write(buffer, this.txSegment.isSynchTx());
        this.write(buffer, this.properties.size());
        for (OStorageEntryConfiguration e : this.properties) {
            this.entryToStream(buffer, e);
        }
        buffer.append("|");
        return buffer.toString().getBytes();
    }

    private int phySegmentFromStream(String[] values, int index, OStorageSegmentConfiguration iSegment) {
        iSegment.location = this.version > 2 ? this.read(values[index++]) : null;
        iSegment.maxSize = this.read(values[index++]);
        iSegment.fileType = this.read(values[index++]);
        iSegment.fileStartSize = this.read(values[index++]);
        iSegment.fileMaxSize = this.read(values[index++]);
        iSegment.fileIncrementSize = this.read(values[index++]);
        iSegment.defrag = this.read(values[index++]);
        int size = Integer.parseInt(this.read(values[index++]));
        iSegment.infoFiles = new OStorageFileConfiguration[size];
        int i = 0;
        while (i < size) {
            int pos;
            String fileName;
            if (!(fileName = this.read(values[index++])).contains("$") && (pos = fileName.indexOf("/databases")) > -1) {
                fileName = "${ORIENTDB_HOME}" + fileName.substring(pos);
            }
            iSegment.infoFiles[i] = new OStorageFileConfiguration(iSegment, fileName, this.read(values[index++]), this.read(values[index++]), iSegment.fileIncrementSize);
            ++i;
        }
        return index;
    }

    private void phySegmentToStream(StringBuilder iBuffer, OStorageSegmentConfiguration iSegment) {
        this.write(iBuffer, iSegment.location);
        this.write(iBuffer, iSegment.maxSize);
        this.write(iBuffer, iSegment.fileType);
        this.write(iBuffer, iSegment.fileStartSize);
        this.write(iBuffer, iSegment.fileMaxSize);
        this.write(iBuffer, iSegment.fileIncrementSize);
        this.write(iBuffer, iSegment.defrag);
        this.write(iBuffer, iSegment.infoFiles.length);
        OStorageFileConfiguration[] oStorageFileConfigurationArray = iSegment.infoFiles;
        int n = iSegment.infoFiles.length;
        int n2 = 0;
        while (n2 < n) {
            OStorageFileConfiguration f = oStorageFileConfigurationArray[n2];
            this.fileToStream(iBuffer, f);
            ++n2;
        }
    }

    private void fileToStream(StringBuilder iBuffer, OStorageFileConfiguration iFile) {
        this.write(iBuffer, iFile.path);
        this.write(iBuffer, iFile.type);
        this.write(iBuffer, iFile.maxSize);
    }

    private void entryToStream(StringBuilder iBuffer, OStorageEntryConfiguration iEntry) {
        this.write(iBuffer, iEntry.name);
        this.write(iBuffer, iEntry.value);
    }

    private String read(String iValue) {
        if (iValue.equals(" ")) {
            return null;
        }
        return iValue;
    }

    private void write(StringBuilder iBuffer, Object iValue) {
        if (iBuffer.length() > 0) {
            iBuffer.append('|');
        }
        iBuffer.append(iValue != null ? iValue.toString() : Character.valueOf(' '));
    }

    public void create() throws IOException {
        this.storage.createRecord(0, CONFIG_RID, new byte[4], OVersionFactory.instance().createVersion(), (byte)98, 0, null);
    }

    public void synch() throws IOException {
    }

    public void setSoftlyClosed(boolean softlyClosed) throws IOException {
    }

    public void close() throws IOException {
    }

    public void setCluster(OStorageClusterConfiguration config) {
        while (config.getId() >= this.clusters.size()) {
            this.clusters.add(null);
        }
        this.clusters.set(config.getId(), config);
    }

    public void dropCluster(int iClusterId) {
        if (iClusterId < this.clusters.size()) {
            this.clusters.set(iClusterId, null);
            this.update();
        }
    }

    public void dropDataSegment(int iId) {
        if (iId < this.dataSegments.size()) {
            this.dataSegments.set(iId, null);
            this.update();
        }
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String getLocaleLanguage() {
        return this.localeLanguage;
    }

    public String getLocaleCountry() {
        return this.localeCountry;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setLocaleLanguage(String iValue) {
        this.localeLanguage = iValue;
        this.localeInstance = null;
    }

    public void setLocaleCountry(String iValue) {
        this.localeCountry = iValue;
        this.localeInstance = null;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }
}

