/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.traverse;

import com.orientechnologies.orient.core.command.traverse.OTraverse;
import com.orientechnologies.orient.core.command.traverse.OTraverseAbstractProcess;
import com.orientechnologies.orient.core.command.traverse.OTraverseFieldProcess;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;

public class OTraverseRecordProcess
extends OTraverseAbstractProcess<ODocument> {
    private boolean skipDocument = false;

    public OTraverseRecordProcess(OTraverse iCommand, ODocument iTarget) {
        this(iCommand, iTarget, false);
    }

    public OTraverseRecordProcess(OTraverse iCommand, ODocument iTarget, boolean iSkipDocument) {
        super(iCommand, iTarget);
        this.skipDocument = iSkipDocument;
        if (!this.skipDocument) {
            ((OTraverse)this.command).getContext().incrementDepth();
        }
    }

    @Override
    public OIdentifiable process() {
        Object conditionResult;
        if (this.target == null) {
            return this.drop();
        }
        if (((OTraverse)this.command).getContext().isAlreadyTraversed((OIdentifiable)this.target)) {
            return this.drop();
        }
        if (((ODocument)this.target).getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            try {
                ((ODocument)this.target).reload();
            }
            catch (ORecordNotFoundException e) {
                return this.drop();
            }
        }
        if (((OTraverse)this.command).getPredicate() != null && (conditionResult = ((OTraverse)this.command).getPredicate().evaluate((ORecord)this.target, null, ((OTraverse)this.command).getContext())) != Boolean.TRUE) {
            return this.drop();
        }
        ((OTraverse)this.command).getContext().addTraversed((OIdentifiable)this.target);
        ArrayList<Object> fields = new ArrayList<Object>();
        for (Object cfgFieldObject : ((OTraverse)this.command).getFields()) {
            String cfgField = cfgFieldObject.toString();
            if ("*".equals(cfgField) || "ALL()".equalsIgnoreCase(cfgField) || "ANY()".equalsIgnoreCase(cfgField)) {
                String[] stringArray = ((ODocument)this.target).fieldNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String f = stringArray[n2];
                    fields.add(f);
                    ++n2;
                }
                break;
            }
            int pos = cfgField.indexOf(46);
            if (pos > -1) {
                String className;
                OClass cls = ((ODocument)this.target).getSchemaClass();
                if (cls == null || !cls.isSubClassOf(className = cfgField.substring(0, pos))) continue;
                cfgField = cfgField.substring(pos + 1);
                fields.add(cfgField);
                continue;
            }
            fields.add(cfgFieldObject);
        }
        OTraverseFieldProcess field = new OTraverseFieldProcess((OTraverse)this.command, fields.iterator());
        if (this.skipDocument) {
            OIdentifiable res = field.process();
            if (res != null) {
                return res;
            }
            return this.drop();
        }
        return (OIdentifiable)this.target;
    }

    @Override
    public String getStatus() {
        return this.target != null ? ((ODocument)this.target).getIdentity().toString() : null;
    }

    @Override
    public String toString() {
        return this.target != null ? ((ODocument)this.target).getIdentity().toString() : "-";
    }

    @Override
    public OIdentifiable drop() {
        if (!this.skipDocument) {
            ((OTraverse)this.command).getContext().decrementDepth();
        }
        return super.drop();
    }
}

