/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.script;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandExecutorAbstract;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.command.script.OCommandScriptException;
import com.orientechnologies.orient.core.command.script.OScriptManager;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class OCommandExecutorScript
extends OCommandExecutorAbstract {
    protected OCommandScript request;

    public OCommandExecutorScript parse(OCommandRequest iRequest) {
        this.request = (OCommandScript)iRequest;
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        return this.executeInContext(this.context, iArgs);
    }

    public Object executeInContext(OCommandContext iContext, Map<Object, Object> iArgs) {
        Object lib;
        String language = this.request.getLanguage();
        this.parserText = this.request.getText();
        ODatabaseRecord db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (db != null && !(db instanceof ODatabaseRecordTx)) {
            db = (ODatabaseRecord)db.getUnderlying();
        }
        OScriptManager scriptManager = Orient.instance().getScriptManager();
        CompiledScript compiledScript = this.request.getCompiledScript();
        if (compiledScript == null) {
            ScriptEngine scriptEngine = scriptManager.getEngine(language);
            lib = scriptManager.getLibrary(db, language);
            if (lib == null) {
                lib = "";
            }
            this.parserText = (String)lib + this.parserText;
            Compilable c = (Compilable)((Object)scriptEngine);
            try {
                compiledScript = c.compile(this.parserText);
            }
            catch (ScriptException e) {
                scriptManager.getErrorMessage(e, (String)lib);
            }
            this.request.setCompiledScript(compiledScript);
        }
        Bindings binding = scriptManager.bind(compiledScript.getEngine().createBindings(), (ODatabaseRecordTx)db, iContext, iArgs);
        try {
            lib = compiledScript.eval(binding);
            return lib;
        }
        catch (ScriptException e) {
            throw new OCommandScriptException("Error on execution of the script", this.request.getText(), e.getColumnNumber(), e);
        }
        finally {
            scriptManager.unbind(binding);
        }
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }

    protected void throwSyntaxErrorException(String iText) {
        throw new OCommandScriptException("Error on execution of the script: " + iText, this.request.getText(), 0);
    }
}

