/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.script;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandExecutorAbstract;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandFunction;
import com.orientechnologies.orient.core.command.script.OCommandScriptException;
import com.orientechnologies.orient.core.command.script.OScriptManager;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class OCommandExecutorFunction
extends OCommandExecutorAbstract {
    protected OCommandFunction request;

    public OCommandExecutorFunction parse(OCommandRequest iRequest) {
        this.request = (OCommandFunction)iRequest;
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        return this.executeInContext(null, iArgs);
    }

    public Object executeInContext(OCommandContext iContext, Map<Object, Object> iArgs) {
        this.parserText = this.request.getText();
        ODatabaseRecord db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (db != null && !(db instanceof ODatabaseRecordTx)) {
            db = (ODatabaseRecord)db.getUnderlying();
        }
        OFunction f = db.getMetadata().getFunctionLibrary().getFunction(this.parserText);
        OScriptManager scriptManager = Orient.instance().getScriptManager();
        ScriptEngine scriptEngine = scriptManager.getEngine(f.getLanguage());
        Bindings binding = scriptManager.bind(scriptEngine.getBindings(100), (ODatabaseRecordTx)db, iContext, iArgs);
        try {
            String lib = scriptManager.getLibrary(db, f.getLanguage());
            if (lib != null) {
                try {
                    scriptEngine.eval(lib);
                }
                catch (ScriptException e) {
                    scriptManager.getErrorMessage(e, lib);
                }
            }
            if (scriptEngine instanceof Invocable) {
                Invocable invocableEngine = (Invocable)((Object)scriptEngine);
                Object[] args = null;
                if (iArgs != null) {
                    args = new Object[iArgs.size()];
                    int i = 0;
                    for (Map.Entry<Object, Object> arg : iArgs.entrySet()) {
                        args[i++] = arg.getValue();
                    }
                }
                Object object = invocableEngine.invokeFunction(this.parserText, args);
                return object;
            }
            Object[] args = iArgs == null ? null : iArgs.values().toArray();
            Object object = scriptEngine.eval(scriptManager.getFunctionInvoke(f, args), binding);
            return object;
        }
        catch (ScriptException e) {
            throw new OCommandScriptException("Error on execution of the script", this.request.getText(), e.getColumnNumber(), e);
        }
        catch (NoSuchMethodException e) {
            throw new OCommandScriptException("Error on execution of the script", this.request.getText(), 0, e);
        }
        catch (OCommandScriptException e) {
            throw e;
        }
        finally {
            scriptManager.unbind(binding);
        }
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }

    protected void throwSyntaxErrorException(String iText) {
        throw new OCommandScriptException("Error on execution of the script: " + iText, this.request.getText(), 0);
    }
}

