/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import java.util.HashMap;
import java.util.Map;

public class OBasicCommandContext
implements OCommandContext {
    public static final String EXECUTION_BEGUN = "EXECUTION_BEGUN";
    public static final String TIMEOUT_MS = "TIMEOUT_MS";
    public static final String TIMEOUT_STRATEGY = "TIMEOUT_STARTEGY";
    protected boolean recordMetrics = false;
    protected OCommandContext parent;
    protected OCommandContext child;
    protected Map<String, Object> variables;
    private long executionStartedOn;
    private long timeoutMs;
    private OCommandContext.TIMEOUT_STRATEGY timeoutStrategy;

    @Override
    public Object getVariable(String iName) {
        String lastPart;
        String firstPart;
        int pos;
        if (iName == null) {
            return null;
        }
        if (iName.startsWith("$")) {
            iName = iName.substring(1);
        }
        if ((pos = OStringSerializerHelper.getLowerIndexOf(iName, 0, ".", "[")) > -1) {
            firstPart = iName.substring(0, pos);
            if (iName.charAt(pos) == '.') {
                ++pos;
            }
            lastPart = iName.substring(pos);
            if (firstPart.equalsIgnoreCase("PARENT") && this.parent != null) {
                if (lastPart.startsWith("$")) {
                    return this.parent.getVariable(lastPart.substring(1));
                }
                return ODocumentHelper.getFieldValue(this.parent, lastPart);
            }
            if (firstPart.equalsIgnoreCase("ROOT")) {
                OCommandContext p = this;
                while (p.getParent() != null) {
                    p = p.getParent();
                }
                if (lastPart.startsWith("$")) {
                    return p.getVariable(lastPart.substring(1));
                }
                return ODocumentHelper.getFieldValue(p, lastPart, this);
            }
        } else {
            firstPart = iName;
            lastPart = null;
        }
        Object result = null;
        if (firstPart.equalsIgnoreCase("CONTEXT")) {
            result = this.getVariables();
        } else {
            if (firstPart.equalsIgnoreCase("PARENT")) {
                return this.parent;
            }
            if (firstPart.equalsIgnoreCase("ROOT")) {
                OCommandContext p = this;
                while (p.getParent() != null) {
                    p = p.getParent();
                }
                return p;
            }
            if (this.variables != null && this.variables.containsKey(firstPart)) {
                result = this.variables.get(firstPart);
            } else if (this.child != null) {
                result = this.child.getVariable(firstPart);
            }
        }
        if (pos > -1) {
            result = ODocumentHelper.getFieldValue(result, lastPart, this);
        }
        return result;
    }

    @Override
    public OCommandContext setVariable(String iName, Object iValue) {
        if (iName == null) {
            return null;
        }
        if (iName.startsWith("$")) {
            iName = iName.substring(1);
        }
        this.init();
        int pos = OStringSerializerHelper.getHigherIndexOf(iName, 0, ".", "[");
        if (pos > -1) {
            Object nested = this.getVariable(iName.substring(0, pos));
            if (nested != null && nested instanceof OCommandContext) {
                ((OCommandContext)nested).setVariable(iName.substring(pos + 1), iValue);
            }
        } else {
            this.variables.put(iName, iValue);
        }
        return this;
    }

    @Override
    public long updateMetric(String iName, long iValue) {
        if (!this.recordMetrics) {
            return -1L;
        }
        this.init();
        Long value = (Long)this.variables.get(iName);
        value = value == null ? Long.valueOf(iValue) : new Long(value + iValue);
        this.variables.put(iName, value);
        return value;
    }

    @Override
    public Map<String, Object> getVariables() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.child != null) {
            map.putAll(this.child.getVariables());
        }
        if (this.variables != null) {
            map.putAll(this.variables);
        }
        return map;
    }

    @Override
    public OCommandContext setChild(OCommandContext iContext) {
        if (iContext == null) {
            if (this.child != null) {
                this.child.setParent(null);
                this.child = null;
            }
        } else if (this.child != iContext) {
            this.child = iContext;
            iContext.setParent(this);
        }
        return this;
    }

    @Override
    public OCommandContext getParent() {
        return this.parent;
    }

    @Override
    public OCommandContext setParent(OCommandContext iParentContext) {
        if (this.parent != iParentContext) {
            this.parent = iParentContext;
            if (this.parent != null) {
                this.parent.setChild(this);
            }
        }
        return this;
    }

    public String toString() {
        return this.getVariables().toString();
    }

    private void init() {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
    }

    @Override
    public boolean isRecordingMetrics() {
        return this.recordMetrics;
    }

    @Override
    public OCommandContext setRecordingMetrics(boolean recordMetrics) {
        this.recordMetrics = recordMetrics;
        return this;
    }

    @Override
    public void beginExecution(long iTimeout, OCommandContext.TIMEOUT_STRATEGY iStrategy) {
        if (iTimeout > 0L) {
            this.executionStartedOn = System.currentTimeMillis();
            this.timeoutMs = iTimeout;
            this.timeoutStrategy = iStrategy;
        }
    }

    @Override
    public boolean checkTimeout() {
        if (this.timeoutMs > 0L && System.currentTimeMillis() - this.executionStartedOn > this.timeoutMs) {
            switch (this.timeoutStrategy) {
                case RETURN: {
                    return false;
                }
                case EXCEPTION: {
                    throw new OTimeoutException("Command execution timeout exceed (" + this.timeoutMs + "ms)");
                }
            }
        }
        return true;
    }
}

