/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.output;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.layout.output.DisplayAllFlowSelector;
import org.pentaho.reporting.engine.classic.core.layout.output.FlowSelector;
import org.pentaho.reporting.engine.classic.core.layout.output.YieldReportListener;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.SinglePageFlowSelector;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.AllItemsHtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.PageableHtmlOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.URLRewriter;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultNameGenerator;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.file.FileRepository;
import org.pentaho.reporting.libraries.repository.stream.StreamRepository;
import org.pentaho.reporting.platform.plugin.messages.Messages;
import org.pentaho.reporting.platform.plugin.output.ProxyOutputStream;
import org.pentaho.reporting.platform.plugin.output.ReportOutputHandler;
import org.pentaho.reporting.platform.plugin.repository.PentahoNameGenerator;
import org.pentaho.reporting.platform.plugin.repository.PentahoURLRewriter;

public class PageableHTMLOutput
implements ReportOutputHandler {
    private String contentHandlerPattern;
    private ProxyOutputStream proxyOutputStream;
    private PageableReportProcessor proc;
    private AllItemsHtmlPrinter printer;

    @Override
    public Object getReportLock() {
        return this;
    }

    public void setContentHandlerPattern(String contentHandlerPattern) {
        this.contentHandlerPattern = contentHandlerPattern;
    }

    public String getContentHandlerPattern() {
        return this.contentHandlerPattern;
    }

    public ProxyOutputStream getProxyOutputStream() {
        return this.proxyOutputStream;
    }

    public void setProxyOutputStream(ProxyOutputStream proxyOutputStream) {
        this.proxyOutputStream = proxyOutputStream;
    }

    public HtmlPrinter getPrinter() {
        return this.printer;
    }

    public void setPrinter(AllItemsHtmlPrinter printer) {
        this.printer = printer;
    }

    public PageableReportProcessor getReportProcessor() {
        return this.proc;
    }

    public void setReportProcessor(PageableReportProcessor proc) {
        this.proc = proc;
    }

    protected PageableReportProcessor createReportProcessor(MasterReport report, int yieldRate) throws ReportProcessingException {
        this.proxyOutputStream = new ProxyOutputStream();
        this.printer = new AllItemsHtmlPrinter(report.getResourceManager());
        this.printer.setUrlRewriter((URLRewriter)new PentahoURLRewriter(this.contentHandlerPattern, false));
        PageableHtmlOutputProcessor outputProcessor = new PageableHtmlOutputProcessor(report.getConfiguration());
        outputProcessor.setPrinter((HtmlPrinter)this.printer);
        this.proc = new PageableReportProcessor(report, (PageableOutputProcessor)outputProcessor);
        if (yieldRate > 0) {
            this.proc.addReportProgressListener((ReportProgressListener)new YieldReportListener(yieldRate));
        }
        return this.proc;
    }

    protected void reinitOutputTarget() throws ReportProcessingException, ContentIOException {
        PentahoNameGenerator dataNameGenerator;
        ContentLocation dataLocation;
        IApplicationContext ctx = PentahoSystem.getApplicationContext();
        if (ctx != null) {
            File dataDirectory = new File(ctx.getFileOutputPath("system/tmp/"));
            if (dataDirectory.exists() && !dataDirectory.isDirectory()) {
                if (!(dataDirectory = dataDirectory.getParentFile()).isDirectory()) {
                    throw new ReportProcessingException("Dead " + dataDirectory.getPath());
                }
            } else if (!dataDirectory.exists()) {
                dataDirectory.mkdirs();
            }
            FileRepository dataRepository = new FileRepository(dataDirectory);
            dataLocation = dataRepository.getRoot();
            dataNameGenerator = (PentahoNameGenerator)PentahoSystem.get(PentahoNameGenerator.class);
            if (dataNameGenerator == null) {
                throw new IllegalStateException(Messages.getInstance().getString("ReportPlugin.errorNameGeneratorMissingConfiguration"));
            }
            dataNameGenerator.initialize(dataLocation, true);
        } else {
            dataLocation = null;
            dataNameGenerator = null;
        }
        StreamRepository targetRepository = new StreamRepository(null, (OutputStream)this.proxyOutputStream, "report");
        ContentLocation targetRoot = targetRepository.getRoot();
        this.printer.setContentWriter(targetRoot, (NameGenerator)new DefaultNameGenerator(targetRoot, "index", "html"));
        this.printer.setDataWriter(dataLocation, (NameGenerator)dataNameGenerator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int paginate(MasterReport report, int yieldRate) throws ReportProcessingException, IOException, ContentIOException {
        if (this.proc == null) {
            this.proc = this.createReportProcessor(report, yieldRate);
        }
        this.reinitOutputTarget();
        try {
            if (!this.proc.isPaginated()) {
                this.proc.paginate();
            }
        }
        finally {
            this.printer.setContentWriter(null, null);
            this.printer.setDataWriter(null, null);
        }
        return this.proc.getLogicalPageCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int generate(MasterReport report, int acceptedPage, OutputStream outputStream, int yieldRate) throws ReportProcessingException, IOException, ContentIOException {
        if (this.proc == null) {
            this.proc = this.createReportProcessor(report, yieldRate);
        }
        PageableHtmlOutputProcessor outputProcessor = (PageableHtmlOutputProcessor)this.proc.getOutputProcessor();
        if (acceptedPage >= 0) {
            outputProcessor.setFlowSelector((FlowSelector)new SinglePageFlowSelector(acceptedPage));
        } else {
            outputProcessor.setFlowSelector((FlowSelector)new DisplayAllFlowSelector());
        }
        this.proxyOutputStream.setParent(outputStream);
        this.reinitOutputTarget();
        try {
            this.proc.processReport();
            int n = this.proc.getLogicalPageCount();
            return n;
        }
        finally {
            outputStream.flush();
            this.printer.setContentWriter(null, null);
            this.printer.setDataWriter(null, null);
        }
    }

    @Override
    public boolean supportsPagination() {
        return true;
    }

    @Override
    public void close() {
        if (this.proc != null) {
            this.proc.close();
            this.proxyOutputStream = null;
        }
    }
}

