/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.drilldown;

import java.util.HashSet;
import java.util.Set;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;
import org.pentaho.reporting.engine.classic.core.function.ReportFormulaContext;
import org.pentaho.reporting.libraries.base.util.CSVTokenizer;
import org.pentaho.reporting.libraries.formula.ErrorValue;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.ArrayCallback;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.LogicalType;

public class IsContentLinkFunction
implements Function {
    public String getCanonicalName() {
        return "ISCONTENTLINK";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        if (parameters.getParameterCount() != 1) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        HashSet<String> params = new HashSet<String>();
        Object o = parameters.getValue(0);
        if (o instanceof Object[][]) {
            Object[][] o2 = (Object[][])o;
            for (int i = 0; i < o2.length; ++i) {
                Object[] values = o2[i];
                if (values == null || values.length == 0) {
                    throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_ILLEGAL_ARRAY_VALUE);
                }
                params.add(String.valueOf(values[0]));
            }
        } else {
            Type type = parameters.getType(0);
            ArrayCallback callback = context.getTypeRegistry().convertToArray(type, o);
            if (callback.getColumnCount() != 2) {
                throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_ILLEGAL_ARRAY_VALUE);
            }
            int n = callback.getRowCount();
            for (int i = 0; i < n; ++i) {
                params.add(String.valueOf(callback.getValue(i, 0)));
            }
        }
        return new TypeValuePair((Type)LogicalType.TYPE, (Object)this.isContentLink(context, params));
    }

    private Boolean isContentLink(FormulaContext context, Set<String> parameters) {
        if (!(context instanceof ReportFormulaContext)) {
            return Boolean.FALSE;
        }
        ReportFormulaContext reportFormulaContext = (ReportFormulaContext)context;
        String exportType = reportFormulaContext.getExportType();
        if (!exportType.startsWith("table/html") || "application/zip;content=table/html;page-mode=flow".equals(exportType)) {
            return Boolean.FALSE;
        }
        ReportEnvironment environment = reportFormulaContext.getRuntime().getProcessingContext().getEnvironment();
        Object clText = environment.getEnvironmentProperty("contentLink");
        if (clText == null) {
            return Boolean.FALSE;
        }
        CSVTokenizer csvTokenizer = new CSVTokenizer(String.valueOf(clText), ",", "\"");
        while (csvTokenizer.hasMoreTokens()) {
            String el = csvTokenizer.nextToken();
            if (!parameters.contains(el)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

