/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.pentaho.platform.api.data.IDBDatasourceService;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ConnectionProvider;
import org.pentaho.reporting.platform.plugin.connection.Messages;

public class PentahoJndiDatasourceConnectionProvider
implements ConnectionProvider {
    private String jndiName;
    private String username;
    private String password;

    public Connection createConnection(String user, String password) throws SQLException {
        try {
            IDBDatasourceService datasourceService = (IDBDatasourceService)PentahoSystem.getObjectFactory().get(IDBDatasourceService.class, null);
            DataSource dataSource = datasourceService.getDataSource(this.jndiName);
            if (dataSource != null) {
                String realUser = this.username != null ? this.username : user;
                String realPassword = this.password != null ? this.password : password;
                if (realUser == null) {
                    Connection connection = dataSource.getConnection();
                    if (connection == null) {
                        datasourceService.clearDataSource(this.jndiName);
                        throw new SQLException(Messages.getInstance().getErrorString("PentahoDatasourceConnectionProvider.ERROR_0001_INVALID_CONNECTION", new Object[]{this.jndiName}));
                    }
                    return connection;
                }
                try {
                    Connection connection = dataSource.getConnection(realUser, realPassword);
                    if (connection == null) {
                        datasourceService.clearDataSource(this.jndiName);
                        throw new SQLException("JNDI DataSource is invalid; it returned null without throwing a meaningful error.");
                    }
                    return connection;
                }
                catch (UnsupportedOperationException uoe) {
                    Connection connection = dataSource.getConnection();
                    if (connection == null) {
                        datasourceService.clearDataSource(this.jndiName);
                        throw new SQLException(Messages.getInstance().getErrorString("PentahoDatasourceConnectionProvider.ERROR_0001_INVALID_CONNECTION", new Object[]{this.jndiName}));
                    }
                    return connection;
                }
                catch (SQLException ex) {
                    Connection nativeConnection = dataSource.getConnection();
                    if (nativeConnection == null) {
                        datasourceService.clearDataSource(this.jndiName);
                        throw new SQLException(Messages.getInstance().getErrorString("PentahoDatasourceConnectionProvider.ERROR_0001_INVALID_CONNECTION", new Object[]{this.jndiName}));
                    }
                    return nativeConnection;
                }
            }
            datasourceService.clearDataSource(this.jndiName);
            throw new SQLException(Messages.getInstance().getErrorString("PentahoDatasourceConnectionProvider.ERROR_0001_INVALID_CONNECTION", new Object[]{this.jndiName}));
        }
        catch (Exception e) {
            try {
                IDBDatasourceService datasourceService = (IDBDatasourceService)PentahoSystem.getObjectFactory().get(IDBDatasourceService.class, null);
                datasourceService.clearDataSource(this.jndiName);
                throw new SQLException(Messages.getInstance().getErrorString("PentahoDatasourceConnectionProvider.ERROR_0002_UNABLE_TO_FACTORY_OBJECT", new Object[]{this.jndiName, e.getLocalizedMessage()}));
            }
            catch (ObjectFactoryException objface) {
                throw new SQLException(Messages.getInstance().getErrorString("PentahoDatasourceConnectionProvider.ERROR_0002_UNABLE_TO_FACTORY_OBJECT", new Object[]{this.jndiName, e.getLocalizedMessage()}));
            }
        }
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Object getConnectionHash() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getClass().getName());
        list.add(this.jndiName);
        list.add(this.username);
        return list;
    }
}

