/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.connection;

import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DefaultCubeFileProvider;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.platform.plugin.messages.Messages;

public class PentahoCubeFileProvider
extends DefaultCubeFileProvider {
    public PentahoCubeFileProvider() {
    }

    public PentahoCubeFileProvider(String definedFile) {
        super(definedFile);
    }

    public PentahoCubeFileProvider(String mondrianCubeFile, String cubeConnectionName) {
        super(mondrianCubeFile, cubeConnectionName);
    }

    public String getCubeFile(ResourceManager resourceManager, ResourceKey contextKey) throws ReportDataFactoryException {
        if (!StringUtils.isEmpty((String)this.getCubeConnectionName())) {
            IMondrianCatalogService catalogService = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class, (IPentahoSession)PentahoSessionHolder.getSession());
            MondrianCatalog catalog = catalogService.getCatalog(this.getCubeConnectionName(), PentahoSessionHolder.getSession());
            if (catalog == null) {
                throw new ReportDataFactoryException("Unable to locate mondrian schema with name '" + this.getCubeConnectionName() + "'");
            }
            return catalog.getDefinition();
        }
        return this.getLegacyCubeFile(resourceManager, contextKey);
    }

    private String getLegacyCubeFile(ResourceManager resourceManager, ResourceKey contextKey) throws ReportDataFactoryException {
        String superDef = this.getMondrianCubeFile();
        if (superDef == null) {
            throw new ReportDataFactoryException(Messages.getInstance().getString("ReportPlugin.noSchemaDefined"));
        }
        return super.getCubeFile(resourceManager, contextKey);
    }
}

