/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin;

import java.io.IOException;
import java.io.OutputStream;

public class TrackingOutputStream
extends OutputStream {
    private int trackingSize;
    private OutputStream wrappedStream;

    public TrackingOutputStream(OutputStream wrapped) {
        this.wrappedStream = wrapped;
    }

    @Override
    public void write(int b) throws IOException {
        this.wrappedStream.write(b);
        ++this.trackingSize;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.wrappedStream.write(b);
        this.trackingSize += b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.wrappedStream.write(b, off, len);
        this.trackingSize += len;
    }

    @Override
    public void flush() throws IOException {
        this.wrappedStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.wrappedStream.close();
    }

    public OutputStream getWrappedStream() {
        return this.wrappedStream;
    }

    public int getTrackingSize() {
        return this.trackingSize;
    }
}

