/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin;

import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IFileInfo;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.engine.SolutionFileMetaAdapter;
import org.pentaho.platform.engine.core.solution.FileInfo;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.platform.plugin.messages.Messages;

public class ReportFileMetaDataProvider
extends SolutionFileMetaAdapter {
    private static final Log logger = LogFactory.getLog(ReportFileMetaDataProvider.class);

    public void setLogger(ILogger logger) {
    }

    private DocumentMetaData loadMetaData(String reportDefinitionPath) throws ResourceException {
        ResourceManager resourceManager = new ResourceManager();
        resourceManager.registerDefaults();
        HashMap helperObjects = new HashMap();
        ResourceKey key = resourceManager.createKey((Object)("pentaho2://" + reportDefinitionPath), helperObjects);
        Resource resource = resourceManager.create(key, null, DocumentBundle.class);
        DocumentBundle bundle = (DocumentBundle)resource.getResource();
        return bundle.getMetaData();
    }

    public IFileInfo getFileInfo(ISolutionFile solutionFile, InputStream in) {
        try {
            DocumentMetaData metaData = this.loadMetaData(solutionFile.getSolutionPath() + "/" + solutionFile.getFileName());
            String title = (String)metaData.getBundleAttribute("http://purl.org/dc/elements/1.1/", "title");
            String author = (String)metaData.getBundleAttribute("http://purl.org/dc/elements/1.1/", "creator");
            String description = (String)metaData.getBundleAttribute("http://purl.org/dc/elements/1.1/", "description");
            FileInfo fileInfo = new FileInfo();
            if (StringUtils.isEmpty((String)title)) {
                fileInfo.setTitle(solutionFile.getFileName());
            } else {
                fileInfo.setTitle(title);
            }
            fileInfo.setAuthor(author);
            fileInfo.setDescription(description);
            if ("false".equals(metaData.getBundleAttribute("http://reporting.pentaho.org/namespaces/engine/classic/metadata/1.0", "visible"))) {
                fileInfo.setDisplayType("none");
            } else {
                fileInfo.setDisplayType("report");
            }
            return fileInfo;
        }
        catch (Exception e) {
            logger.warn((Object)Messages.getInstance().getString("ReportPlugin.errorMetadataNotReadable"), (Throwable)e);
            return null;
        }
    }
}

