/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin;

import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.SimpleContentGenerator;
import org.pentaho.reporting.platform.plugin.ParameterXmlContentHandler;

public class ParameterContentGenerator
extends SimpleContentGenerator {
    private static final long serialVersionUID = 1L;
    private String path = null;
    private IParameterProvider requestParameters;
    private IParameterProvider pathParameters;

    public void createContent(OutputStream outputStream) throws Exception {
        IUnifiedRepository unifiedRepository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class, null);
        IParameterProvider requestParams = this.getRequestParameters();
        IParameterProvider pathParams = this.getPathParameters();
        if (requestParams != null && requestParams.getStringParameter("path", null) != null) {
            this.path = requestParams.getStringParameter("path", "");
        } else if (pathParams != null && pathParams.getStringParameter("path", null) != null) {
            this.path = pathParams.getStringParameter("path", "");
        }
        this.path = this.idTopath(URLDecoder.decode(this.path, "UTF-8"));
        RepositoryFile prptFile = unifiedRepository.getFile(this.path);
        RENDER_TYPE renderMode = RENDER_TYPE.valueOf(requestParams.getStringParameter("renderMode", RENDER_TYPE.XML.toString()).toUpperCase());
        switch (renderMode) {
            case XML: {
                ParameterXmlContentHandler parameterXmlContentHandler = new ParameterXmlContentHandler(this, true);
                parameterXmlContentHandler.createParameterContent(outputStream, prptFile.getId(), prptFile.getPath(), false, null);
                break;
            }
            case PARAMETER: {
                ParameterXmlContentHandler parameterXmlContentHandler = new ParameterXmlContentHandler(this, false);
                parameterXmlContentHandler.createParameterContent(outputStream, prptFile.getId(), prptFile.getPath(), false, null);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public String getMimeType() {
        return "text/xml";
    }

    public Log getLogger() {
        return LogFactory.getLog(ParameterContentGenerator.class);
    }

    protected String idTopath(String path) {
        if (path != null && path.length() > 0 && path.charAt(0) != '/') {
            path = "/" + path;
        }
        return path;
    }

    public IParameterProvider getRequestParameters() {
        IParameterProvider requestParams;
        if (this.requestParameters != null) {
            return this.requestParameters;
        }
        if (this.parameterProviders == null) {
            return new SimpleParameterProvider();
        }
        this.requestParameters = requestParams = (IParameterProvider)this.parameterProviders.get("request");
        return requestParams;
    }

    public IParameterProvider getPathParameters() {
        IParameterProvider pathParams;
        if (this.pathParameters != null) {
            return this.pathParameters;
        }
        this.pathParameters = pathParams = (IParameterProvider)this.parameterProviders.get("path");
        return pathParams;
    }

    public Map<String, Object> createInputs() {
        return ParameterContentGenerator.createInputs(this.getRequestParameters());
    }

    protected static Map<String, Object> createInputs(IParameterProvider requestParams) {
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        if (requestParams == null) {
            return inputs;
        }
        Iterator paramIter = requestParams.getParameterNames();
        while (paramIter.hasNext()) {
            String paramName = (String)paramIter.next();
            Object paramValue = requestParams.getParameter(paramName);
            if (paramValue == null) continue;
            inputs.put(paramName, paramValue);
        }
        return inputs;
    }

    public IPentahoSession getUserSession() {
        return this.userSession;
    }

    public static enum RENDER_TYPE {
        REPORT,
        XML,
        PARAMETER,
        SUBSCRIBE,
        DOWNLOAD;

    }
}

