/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.audit.AuditHelper;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.RepositoryPathEncoder;
import org.pentaho.platform.util.UUIDUtil;
import org.pentaho.platform.util.web.MimeHelper;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.util.StagingMode;
import org.pentaho.reporting.platform.plugin.ReportContentGenerator;
import org.pentaho.reporting.platform.plugin.SimpleReportingComponent;
import org.pentaho.reporting.platform.plugin.StagingHandler;
import org.pentaho.reporting.platform.plugin.messages.Messages;

public class ExecuteReportContentHandler {
    private static final String FORCED_BUFFERED_WRITING = "org.pentaho.reporting.engine.classic.core.modules.output.table.html.ForceBufferedWriting";
    private static final Log logger = LogFactory.getLog(ExecuteReportContentHandler.class);
    private static final StagingMode DEFAULT = StagingMode.THRU;
    private IPentahoSession userSession;
    private ReportContentGenerator contentGenerator;

    public ExecuteReportContentHandler(ReportContentGenerator contentGenerator) {
        this.contentGenerator = contentGenerator;
        this.userSession = contentGenerator.getUserSession();
    }

    public void createReportContent(OutputStream outputStream, Serializable fileId, String path, boolean forceDefaultOutputTarget) throws Exception {
        long start = System.currentTimeMillis();
        Map<String, Object> inputs = this.contentGenerator.createInputs();
        AuditHelper.audit((String)this.userSession.getId(), (String)this.userSession.getName(), (String)path, (String)this.contentGenerator.getObjectName(), (String)this.getClass().getName(), (String)"instance_start", (String)this.contentGenerator.getInstanceId(), (String)"", (float)0.0f, (ILogger)this.contentGenerator);
        String result = "instance_end";
        StagingHandler reportStagingHandler = null;
        try {
            Object httpResponse;
            Object rawSessionId = inputs.get("::session");
            if (!(rawSessionId instanceof String) || "".equals(rawSessionId)) {
                inputs.put("::session", UUIDUtil.getUUIDAsString());
            }
            SimpleReportingComponent reportComponent = new SimpleReportingComponent();
            reportComponent.setReportFileId(fileId);
            reportComponent.setPaginateOutput(true);
            reportComponent.setForceDefaultOutputTarget(forceDefaultOutputTarget);
            reportComponent.setDefaultOutputTarget("table/html;page-mode=page");
            if (path.endsWith(".prpti")) {
                reportComponent.setForceUnlockPreferredOutput(true);
            }
            reportComponent.setInputs(inputs);
            MasterReport report = reportComponent.getReport();
            StagingMode stagingMode = this.getStagingMode(inputs, report);
            reportStagingHandler = new StagingHandler(outputStream, stagingMode, this.userSession);
            if (reportStagingHandler.isFullyBuffered()) {
                report.getReportConfiguration().setConfigProperty(FORCED_BUFFERED_WRITING, "false");
            }
            reportComponent.setOutputStream(reportStagingHandler.getStagingOutputStream());
            IUnifiedRepository repository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class, (IPentahoSession)this.userSession);
            RepositoryFile file = repository.getFileById(fileId);
            String mimeType = reportComponent.getMimeType();
            String outputTarget = reportComponent.getComputedOutputTarget();
            if ("table/html;page-mode=page".equals(outputTarget) && reportComponent.getAcceptedPage() < 0) {
                reportComponent.setAcceptedPage(0);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)Messages.getInstance().getString("ReportPlugin.logStartGenerateContent", new Object[]{mimeType, outputTarget, String.valueOf(reportComponent.getAcceptedPage())}));
            }
            HttpServletResponse response = null;
            boolean streamToBrowser = false;
            IParameterProvider pathProviders = this.contentGenerator.getParameterProviders().get("path");
            if (pathProviders != null && (httpResponse = pathProviders.getParameter("httpresponse")) instanceof HttpServletResponse) {
                ServletOutputStream respOutputStream;
                response = (HttpServletResponse)httpResponse;
                if (reportStagingHandler.getStagingMode() == StagingMode.THRU && (respOutputStream = response.getOutputStream()) == outputStream) {
                    streamToBrowser = true;
                }
            }
            String extension = MimeHelper.getExtension((String)mimeType);
            String filename = file.getName();
            if (filename.lastIndexOf(".") != -1) {
                filename = filename.substring(0, filename.lastIndexOf("."));
            }
            String disposition = "inline; filename*=UTF-8''" + RepositoryPathEncoder.encode((String)RepositoryPathEncoder.encodeRepositoryPath((String)(filename + extension)));
            boolean validates = reportComponent.validate();
            if (!validates) {
                this.sendErrorResponse(response, outputStream, reportStagingHandler);
            } else {
                if (response != null) {
                    response.setHeader("Content-Disposition", disposition);
                    response.setHeader("Content-Description", file.getName());
                    response.setHeader("Cache-Control", "private, max-age=0, must-revalidate");
                }
                if (reportComponent.execute()) {
                    if (response != null && reportStagingHandler.canSendHeaders()) {
                        response.setHeader("Content-Disposition", disposition);
                        response.setHeader("Content-Description", file.getName());
                        response.setHeader("Cache-Control", "private, max-age=0, must-revalidate");
                        response.setContentLength(reportStagingHandler.getWrittenByteCount());
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)Messages.getInstance().getString("ReportPlugin.logEndGenerateContent", new Object[]{String.valueOf(reportStagingHandler.getWrittenByteCount())}));
                    }
                    reportStagingHandler.complete();
                } else {
                    this.sendErrorResponse(response, outputStream, reportStagingHandler);
                }
            }
        }
        catch (Exception ex) {
            result = "instance_failed";
            throw ex;
        }
        finally {
            if (reportStagingHandler != null) {
                reportStagingHandler.close();
            }
            long end = System.currentTimeMillis();
            AuditHelper.audit((String)this.userSession.getId(), (String)this.userSession.getName(), (String)path, (String)this.contentGenerator.getObjectName(), (String)this.getClass().getName(), (String)result, (String)this.contentGenerator.getInstanceId(), (String)"", (float)((float)(end - start) / 1000.0f), (ILogger)this.contentGenerator);
        }
    }

    private StagingMode getStagingMode(Map<String, Object> inputs, MasterReport report) {
        StagingMode mode;
        Object o = inputs.get("report-staging-mode");
        if (o != null) {
            try {
                return StagingMode.valueOf((String)String.valueOf(o));
            }
            catch (IllegalArgumentException ie) {
                logger.trace((Object)"Staging mode was specified but invalid");
            }
        }
        if ((mode = (StagingMode)report.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/pentaho", "staging-mode")) == null) {
            logger.trace((Object)"Looking at default settings for mode");
            String defaultStagingMode = PentahoSystem.getSystemSetting((String)"report-staging-mode", null);
            if (defaultStagingMode == null) {
                defaultStagingMode = DEFAULT.toString();
                logger.trace((Object)"Nothing in settings/staging-mode - defaulting to MEMORY");
            } else {
                logger.trace((Object)("Read " + defaultStagingMode + " from settings/report-staging-mode"));
            }
            try {
                mode = StagingMode.valueOf((String)defaultStagingMode.toUpperCase());
                logger.trace((Object)("Staging mode set from default - " + mode));
            }
            catch (IllegalArgumentException badStringInSettings) {
                mode = DEFAULT;
            }
        }
        return mode;
    }

    private void sendErrorResponse(HttpServletResponse response, OutputStream outputStream, StagingHandler reportStagingHandler) throws IOException {
        if (response != null) {
            response.setStatus(500);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)Messages.getInstance().getString("ReportPlugin.logErrorGenerateContent"));
        }
        if (reportStagingHandler.canSendHeaders()) {
            outputStream.write(Messages.getInstance().getString("ReportPlugin.ReportValidationFailed").getBytes());
            outputStream.flush();
        }
    }
}

