/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.QueryParam;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.web.http.request.HttpRequestParameterProvider;
import org.springframework.beans.factory.ListableBeanFactory;
import pt.webdetails.cpf.ClassLoaderAwareCaller;
import pt.webdetails.cpf.plugincall.api.IPluginCall;
import pt.webdetails.cpf.web.CpfHttpServletRequest;
import pt.webdetails.cpf.web.CpfHttpServletResponse;

public class InterPluginCall
implements Runnable,
Callable<String>,
IPluginCall {
    public static final Plugin CDA = new Plugin("cda");
    public static final Plugin CDB = new Plugin("cdb");
    public static final Plugin CDC = new Plugin("cdc");
    public static final Plugin CDE = new Plugin("pentaho-cdf-dd");
    public static final Plugin CDF = new Plugin("pentaho-cdf");
    public static final Plugin CDV = new Plugin("cdv");
    private Object objectResponse;
    private static final Log logger = LogFactory.getLog(InterPluginCall.class);
    private Plugin plugin;
    private String method;
    private String service;
    private Map<String, Object> requestParameters;
    private HttpServletResponse response;
    private HttpServletRequest request;
    private IPentahoSession session;
    private IPluginManager pluginManager;

    public String call(Map<String, String[]> params) throws Exception {
        for (String key : params.keySet()) {
            this.requestParameters.put(key, params.get(key));
        }
        return this.call();
    }

    public void run(Map<String, String[]> params) throws Exception {
        for (String key : params.keySet()) {
            this.requestParameters.put(key, params.get(key));
        }
        this.run();
    }

    public InputStream getResult() {
        return null;
    }

    @Deprecated
    public boolean pluginExists() {
        return this.exists();
    }

    public boolean exists() {
        return this.getPluginManager().getClassLoader(this.plugin.getName()) != null;
    }

    public InterPluginCall(Plugin plugin, String method) {
        this(plugin, plugin.getName() + ".api", method);
    }

    public InterPluginCall(Plugin plugin, String method, Map<String, Object> params) {
        this(plugin, plugin.getName() + ".api", method, params);
    }

    public InterPluginCall(Plugin plugin, String service, String method) {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin must be specified");
        }
        this.plugin = plugin;
        this.method = method;
        this.service = service != null ? service : plugin.getName() + ".api";
        this.requestParameters = new HashMap<String, Object>();
    }

    public InterPluginCall(Plugin plugin, String service, String method, Map<String, Object> params) {
        this(plugin, service, method);
        this.requestParameters.putAll(params != null ? params : new HashMap());
    }

    protected HttpServletRequest getRequest() {
        if (this.request == null) {
            this.request = new CpfHttpServletRequest();
        }
        return this.request;
    }

    public InterPluginCall putParameter(String name, Object value) {
        this.requestParameters.put(name, value);
        return this;
    }

    private Object getBeanObject() {
        ListableBeanFactory beanFactory = this.getPluginManager().getBeanFactory(this.plugin.getName());
        if (beanFactory == null) {
            if (this.pluginManager.getClassLoader(this.plugin.getName()) == null) {
                logger.error((Object)("No such plugin: " + this.plugin.getName()));
            } else {
                logger.error((Object)("No bean factory for plugin: " + this.plugin.getName()));
            }
            return null;
        }
        if (!beanFactory.containsBean(this.service)) {
            logger.error((Object)("'" + this.service + "' bean not found in " + this.plugin.getName()));
            return null;
        }
        return beanFactory.getBean(this.service);
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public void run() {
        Method[] methods;
        Class<?> classe = null;
        Method operation = null;
        Object o = null;
        o = this.getBeanObject();
        classe = o.getClass();
        for (Method m : methods = classe.getMethods()) {
            if (!m.getName().equals(this.method)) continue;
            operation = m;
            break;
        }
        Annotation[][] params = operation.getParameterAnnotations();
        Class<?>[] paramTypes = operation.getParameterTypes();
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (int i = 0; i < params.length; ++i) {
            String paramName = "";
            String paramDefaultValue = "";
            for (Annotation annotation : params[i]) {
                QueryParam param;
                String annotationClass = annotation.annotationType().getName();
                if (annotationClass == "javax.ws.rs.QueryParam") {
                    param = (QueryParam)annotation;
                    paramName = param.value();
                    continue;
                }
                if (annotationClass == "javax.ws.rs.DefaultValue") {
                    param = (DefaultValue)annotation;
                    paramDefaultValue = param.value();
                    continue;
                }
                if (annotationClass != "javax.ws.rs.core.Context") continue;
                if (paramTypes[i] == HttpServletRequest.class) {
                    CpfHttpServletRequest cpfRequest = (CpfHttpServletRequest)this.getRequest();
                    for (Map.Entry<String, Object> entry : this.requestParameters.entrySet()) {
                        String key = entry.getKey();
                        Object paramValue = entry.getValue();
                        if (paramValue instanceof String[]) {
                            String[] lValues = (String[])paramValue;
                            if (lValues.length == 1) {
                                cpfRequest.setParameter(key, lValues[0]);
                                continue;
                            }
                            cpfRequest.setParameter(key, lValues);
                            continue;
                        }
                        if (paramValue == null) continue;
                        cpfRequest.setParameter(key, paramValue.toString());
                    }
                    parameters.add(cpfRequest);
                    continue;
                }
                if (paramTypes[i] != HttpServletResponse.class) continue;
                HttpServletResponse response = (HttpServletResponse)this.getParameterProviders().get("path").getParameter("httpresponse");
                if (response == null) {
                    response = this.getResponse();
                }
                parameters.add(response);
            }
            if (this.requestParameters.containsKey(paramName)) {
                boolean val;
                Object paramValue = this.requestParameters.get(paramName);
                if (paramTypes[i] == Integer.TYPE) {
                    if (paramValue instanceof String[]) {
                        String[] lValues = (String[])paramValue;
                        paramValue = lValues.length > 0 ? lValues[0] : null;
                    }
                    val = Integer.parseInt((String)paramValue);
                    parameters.add(val ? 1 : 0);
                } else if (paramTypes[i] == Boolean.class || paramTypes[i] == Boolean.TYPE) {
                    if (paramValue instanceof String[]) {
                        String[] lValues = (String[])paramValue;
                        paramValue = lValues.length > 0 ? lValues[0] : null;
                    }
                    val = Boolean.parseBoolean((String)paramValue);
                    parameters.add(val);
                } else if (paramTypes[i] == List.class) {
                    ArrayList<String> list = new ArrayList<String>();
                    String[] splittedValues = paramValue instanceof String[] ? (String[])paramValue : ((String)paramValue).split(",");
                    for (String s : splittedValues) {
                        list.add(s);
                    }
                    parameters.add(list);
                } else if (paramTypes[i] == String.class) {
                    if (paramValue instanceof String[]) {
                        String[] lValues = (String[])paramValue;
                        paramValue = lValues.length > 0 ? lValues[0] : null;
                    }
                    parameters.add(paramValue);
                }
                this.requestParameters.remove(paramName);
                continue;
            }
            if (paramTypes[i] == Integer.TYPE) {
                int val = Integer.parseInt(paramDefaultValue);
                parameters.add(val);
                continue;
            }
            if (paramTypes[i] == Boolean.class || paramTypes[i] == Boolean.TYPE) {
                boolean val = Boolean.parseBoolean(paramDefaultValue);
                parameters.add(val);
                continue;
            }
            if (paramTypes[i] == List.class) {
                String[] splittedValues;
                ArrayList<String> list = new ArrayList<String>();
                String values = paramDefaultValue;
                for (String s : splittedValues = values.split(",")) {
                    list.add(s);
                }
                parameters.add(list);
                continue;
            }
            if (paramTypes[i] != String.class) continue;
            parameters.add(paramDefaultValue);
        }
        try {
            this.objectResponse = operation.invoke(o, parameters.toArray());
        }
        catch (IllegalAccessException ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
        }
    }

    @Override
    public String call() {
        this.run();
        CpfHttpServletResponse cpfResponse = (CpfHttpServletResponse)this.response;
        if (this.response != null) {
            String content = "";
            try {
                content = cpfResponse.getContentAsString();
            }
            catch (UnsupportedEncodingException ex) {
                logger.error((Object)"Error getting content from CpfHttpServletResponse", (Throwable)ex);
            }
            return content;
        }
        if (this.objectResponse != null) {
            return this.objectResponse.toString();
        }
        return null;
    }

    public void runInPluginClassLoader() {
        this.getClassLoaderCaller().runInClassLoader(this);
    }

    public String callInPluginClassLoader() {
        try {
            return this.getClassLoaderCaller().callInClassLoader(this);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public HttpServletResponse getResponse() {
        if (this.response == null) {
            logger.debug((Object)("No response passed to method " + this.method + ", adding response."));
            this.response = new CpfHttpServletResponse();
        }
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void setSession(IPentahoSession session) {
        this.session = session;
    }

    public void setRequestParameters(Map<String, Object> parameters) {
        this.requestParameters = parameters;
    }

    protected IPentahoSession getSession() {
        if (this.session == null) {
            this.session = PentahoSessionHolder.getSession();
        }
        return this.session;
    }

    protected IParameterProvider getRequestParameterProvider() {
        HttpRequestParameterProvider provider = null;
        if (this.request != null) {
            provider = new HttpRequestParameterProvider(this.request);
            provider.setParameters(this.requestParameters);
        } else {
            provider = new SimpleParameterProvider(this.requestParameters);
        }
        return provider;
    }

    protected ClassLoaderAwareCaller getClassLoaderCaller() {
        return new ClassLoaderAwareCaller(this.getPluginManager().getClassLoader(this.plugin.getTitle()));
    }

    protected IPluginManager getPluginManager() {
        if (this.pluginManager == null) {
            this.pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)this.getSession());
        }
        return this.pluginManager;
    }

    protected IParameterProvider getPathParameterProvider() {
        HashMap<String, String> pathMap = new HashMap<String, String>();
        pathMap.put("path", "/" + this.method);
        pathMap.put("httpresponse", (String)this.getResponse());
        if (this.getRequest() != null) {
            pathMap.put("httprequest", (String)this.getRequest());
        }
        SimpleParameterProvider pathParams = new SimpleParameterProvider(pathMap);
        return pathParams;
    }

    protected Map<String, IParameterProvider> getParameterProviders() {
        IParameterProvider requestParams = this.getRequestParameterProvider();
        IParameterProvider pathParams = this.getPathParameterProvider();
        HashMap<String, IParameterProvider> paramProvider = new HashMap<String, IParameterProvider>();
        paramProvider.put("request", requestParams);
        paramProvider.put("path", pathParams);
        return paramProvider;
    }

    public static class Plugin {
        private String name;
        private String title;

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }

        public Plugin(String name, String title) {
            this.name = name;
            this.title = title;
        }

        public Plugin(String id) {
            this.name = id;
            this.title = id;
        }
    }
}

