/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.kettle.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PasswordEncryptionService;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleDataFactoryWriterHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.AbstractKettleTransformationProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.EmbeddedKettleTransformationProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.FormulaArgument;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.FormulaParameter;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransFromFileProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransFromRepositoryProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransformationProducer;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class KettleDataFactoryBundleWriteHandler
implements BundleDataFactoryWriterHandler {
    public String writeDataFactory(WriteableDocumentBundle bundle, DataFactory dataFactory, BundleWriterState state) throws IOException, BundleWriterException {
        String fileName = BundleUtilities.getUniqueName((DocumentBundle)bundle, (String)state.getFileName(), (String)"datasources/kettle-ds{0}.xml");
        if (fileName == null) {
            throw new IOException("Unable to generate unique name for Inline-Data-Source");
        }
        OutputStream outputStream = bundle.createEntry(fileName, "text/xml");
        DefaultTagDescription tagDescription = new DefaultTagDescription(ClassicEngineBoot.getInstance().getGlobalConfig(), "org.pentaho.reporting.engine.classic.extensions.datasources.kettle.tag-def.");
        XmlWriter xmlWriter = new XmlWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), (TagDescription)tagDescription, "  ", "\n");
        KettleDataFactory kettleDataFactory = (KettleDataFactory)dataFactory;
        AttributeList rootAttrs = new AttributeList();
        rootAttrs.addNamespaceDeclaration("data", "http://jfreereport.sourceforge.net/namespaces/datasources/kettle");
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "kettle-datasource", rootAttrs, false);
        String[] queryNames = kettleDataFactory.getQueryNames();
        for (int i = 0; i < queryNames.length; ++i) {
            String queryName = queryNames[i];
            KettleTransformationProducer prod = kettleDataFactory.getQuery(queryName);
            if (prod instanceof KettleTransFromFileProducer) {
                this.writeKettleFileProducer(xmlWriter, queryName, (KettleTransFromFileProducer)prod);
                continue;
            }
            if (prod instanceof KettleTransFromRepositoryProducer) {
                this.writeKettleRepositoryProducer(xmlWriter, queryName, (KettleTransFromRepositoryProducer)prod);
                continue;
            }
            if (prod instanceof EmbeddedKettleTransformationProducer) {
                this.writeKettleEmbeddedProducer(bundle, fileName, xmlWriter, queryName, (EmbeddedKettleTransformationProducer)prod);
                continue;
            }
            throw new BundleWriterException("Failed to write Kettle-Producer: Unknown implementation.");
        }
        xmlWriter.writeCloseTag();
        xmlWriter.close();
        return fileName;
    }

    private void writeKettleFileProducer(XmlWriter xmlWriter, String queryName, KettleTransFromFileProducer fileProducer) throws IOException {
        AttributeList coreAttrs = new AttributeList();
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "name", queryName);
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "repository", fileProducer.getRepositoryName());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "filename", fileProducer.getTransformationFile());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "step", fileProducer.getStepName());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "username", fileProducer.getUsername());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "password", PasswordEncryptionService.getInstance().encrypt(fileProducer.getPassword()));
        String[] definedArgumentNames = fileProducer.getDefinedArgumentNames();
        ParameterMapping[] parameterMappings = fileProducer.getDefinedVariableNames();
        if (definedArgumentNames.length == 0 && parameterMappings.length == 0) {
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "query-file", coreAttrs, true);
            return;
        }
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "query-file", coreAttrs, false);
        this.writeParameterAndArguments(xmlWriter, fileProducer);
        xmlWriter.writeCloseTag();
    }

    private void writeKettleRepositoryProducer(XmlWriter xmlWriter, String queryName, KettleTransFromRepositoryProducer repositoryProducer) throws IOException {
        AttributeList coreAttrs = new AttributeList();
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "name", queryName);
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "repository", repositoryProducer.getRepositoryName());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "directory", repositoryProducer.getDirectoryName());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "transformation", repositoryProducer.getTransformationName());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "step", repositoryProducer.getStepName());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "username", repositoryProducer.getUsername());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "password", PasswordEncryptionService.getInstance().encrypt(repositoryProducer.getPassword()));
        String[] definedArgumentNames = repositoryProducer.getDefinedArgumentNames();
        ParameterMapping[] parameterMappings = repositoryProducer.getDefinedVariableNames();
        if (definedArgumentNames.length == 0 && parameterMappings.length == 0) {
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "query-repository", coreAttrs, true);
            return;
        }
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "query-repository", coreAttrs, false);
        this.writeParameterAndArguments(xmlWriter, repositoryProducer);
        xmlWriter.writeCloseTag();
    }

    private void writeKettleEmbeddedProducer(WriteableDocumentBundle bundle, String contextFileName, XmlWriter xmlWriter, String queryName, EmbeddedKettleTransformationProducer fileProducer) throws IOException {
        String absoluteResourceName = this.writeFile(bundle, contextFileName, queryName, fileProducer);
        AttributeList coreAttrs = new AttributeList();
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "name", queryName);
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "plugin-id", fileProducer.getPluginId());
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "query-embedded", coreAttrs, false);
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "resource", false);
        String resourceName = IOUtils.getInstance().createRelativePath(absoluteResourceName, contextFileName);
        xmlWriter.writeText(resourceName);
        xmlWriter.writeCloseTag();
        this.writeParameterAndArguments(xmlWriter, fileProducer);
        xmlWriter.writeCloseTag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeFile(WriteableDocumentBundle bundle, String contextFileName, String queryName, EmbeddedKettleTransformationProducer fileProducer) throws IOException {
        String fileName = BundleUtilities.getUniqueName((DocumentBundle)bundle, (String)contextFileName, (String)(queryName + "{0}.ktr"));
        if (fileName == null) {
            throw new IOException("Unable to generate unique name for unified datasource. ");
        }
        OutputStream outputStream = null;
        try {
            outputStream = bundle.createEntry(fileName, "text/xml");
            outputStream.write(fileProducer.getTransformationRaw());
        }
        finally {
            if (outputStream != null) {
                outputStream.flush();
                outputStream.close();
            }
        }
        return fileName;
    }

    private void writeParameterAndArguments(XmlWriter xmlWriter, AbstractKettleTransformationProducer fileProducer) throws IOException {
        int i;
        FormulaArgument[] definedArgumentNames = fileProducer.getArguments();
        FormulaParameter[] parameterMappings = fileProducer.getParameter();
        for (i = 0; i < definedArgumentNames.length; ++i) {
            FormulaArgument arg = definedArgumentNames[i];
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "argument", "formula", arg.getFormula(), true);
        }
        for (i = 0; i < parameterMappings.length; ++i) {
            FormulaParameter parameterMapping = parameterMappings[i];
            AttributeList paramAttr = new AttributeList();
            paramAttr.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "variable-name", parameterMapping.getName());
            paramAttr.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "formula", parameterMapping.getFormula());
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "variable", paramAttr, true);
        }
    }
}

