/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.kettle.parser;

import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.EmbeddedKettleTransformationProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.parser.AbstractKettleTransformationProducerReadHandler;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.StringReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class KettleEmbeddedTransReadHandler
extends AbstractKettleTransformationProducerReadHandler {
    private String pluginId;
    private StringReadHandler resourceReadHandler;
    private String name;

    @Override
    protected void startParsing(Attributes attrs) throws SAXException {
        this.pluginId = attrs.getValue(this.getUri(), "plugin-id");
        this.name = attrs.getValue(this.getUri(), "name");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (this.getUri().equals(uri) && "resource".equals(tagName)) {
            this.resourceReadHandler = new StringReadHandler();
            return this.resourceReadHandler;
        }
        return super.getHandlerForChild(uri, tagName, atts);
    }

    @Override
    public EmbeddedKettleTransformationProducer getObject() throws SAXException {
        if (this.resourceReadHandler == null) {
            throw new ParseException("Missing tag 'resource'", this.getLocator());
        }
        String resourceName = this.resourceReadHandler.getResult();
        try {
            byte[] bytes = this.loadDataFromBundle(resourceName);
            return new EmbeddedKettleTransformationProducer(this.getDefinedArgumentNames(), this.getDefinedVariableNames(), this.pluginId, bytes);
        }
        catch (Exception e) {
            throw new ParseException("Could not load resource " + resourceName, e, this.getLocator());
        }
    }

    private byte[] loadDataFromBundle(String href) throws ResourceKeyCreationException, ResourceLoadingException {
        ResourceKey key = this.getRootHandler().getSource();
        ResourceManager manager = this.getRootHandler().getResourceManager();
        ResourceKey derivedKey = manager.deriveKey(key, href);
        ResourceData data = manager.load(derivedKey);
        return data.getResource(manager);
    }

    @Override
    public EmbeddedKettleTransformationProducer getTransformationProducer() throws SAXException {
        return this.getObject();
    }
}

