/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.kettle;

import java.io.Serializable;
import java.util.ArrayList;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.parser.ParseException;
import org.pentaho.reporting.libraries.formula.util.FormulaUtil;

public class FormulaArgument
implements Serializable {
    private String formula;

    public FormulaArgument(String formula) {
        ArgumentNullException.validate((String)"formula", (Object)formula);
        this.formula = formula;
    }

    public String getFormula() {
        return this.formula;
    }

    public static FormulaArgument[] convert(String[] definedArgumentNames) {
        FormulaArgument[] args = new FormulaArgument[definedArgumentNames.length];
        for (int i = 0; i < definedArgumentNames.length; ++i) {
            String definedArgumentName = definedArgumentNames[i];
            args[i] = new FormulaArgument('=' + FormulaUtil.quoteReference((String)definedArgumentName));
        }
        return args;
    }

    public static String[] convert(FormulaArgument[] args) {
        ArrayList<String> textList = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            FormulaArgument arg = args[i];
            try {
                String[] references = FormulaUtil.getReferences((String)arg.getFormula());
                if (references.length <= 0) continue;
                textList.add(references[0]);
                continue;
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        return textList.toArray(new String[textList.size()]);
    }

    public String[] getReferencedFields() throws ParseException {
        return FormulaUtil.getReferences((String)this.getFormula());
    }

    public Object compute(FormulaContext formulaContext) throws EvaluationException, ParseException {
        Formula f = new Formula(FormulaUtil.extractFormula((String)this.formula));
        f.initialize(formulaContext);
        return f.evaluate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormulaArgument that = (FormulaArgument)o;
        return this.formula.equals(that.formula);
    }

    public int hashCode() {
        return this.formula.hashCode();
    }
}

