/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.table;

import com.microsoft.windowsazure.storage.DoesServiceRequest;
import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.RequestOptions;
import com.microsoft.windowsazure.storage.ResultContinuation;
import com.microsoft.windowsazure.storage.ResultSegment;
import com.microsoft.windowsazure.storage.StorageCredentials;
import com.microsoft.windowsazure.storage.StorageCredentialsAccountAndKey;
import com.microsoft.windowsazure.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.windowsazure.storage.StorageErrorCode;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.StorageUri;
import com.microsoft.windowsazure.storage.core.ExecutionEngine;
import com.microsoft.windowsazure.storage.core.PathUtility;
import com.microsoft.windowsazure.storage.core.RequestLocationMode;
import com.microsoft.windowsazure.storage.core.SharedAccessPolicyDeserializer;
import com.microsoft.windowsazure.storage.core.SharedAccessPolicySerializer;
import com.microsoft.windowsazure.storage.core.SharedAccessSignatureHelper;
import com.microsoft.windowsazure.storage.core.StorageRequest;
import com.microsoft.windowsazure.storage.core.UriQueryBuilder;
import com.microsoft.windowsazure.storage.core.Utility;
import com.microsoft.windowsazure.storage.table.CloudTableClient;
import com.microsoft.windowsazure.storage.table.DynamicTableEntity;
import com.microsoft.windowsazure.storage.table.EntityProperty;
import com.microsoft.windowsazure.storage.table.EntityResolver;
import com.microsoft.windowsazure.storage.table.QueryTableOperation;
import com.microsoft.windowsazure.storage.table.SharedAccessTablePolicy;
import com.microsoft.windowsazure.storage.table.TableBatchOperation;
import com.microsoft.windowsazure.storage.table.TableEntity;
import com.microsoft.windowsazure.storage.table.TableOperation;
import com.microsoft.windowsazure.storage.table.TableOperationType;
import com.microsoft.windowsazure.storage.table.TablePermissions;
import com.microsoft.windowsazure.storage.table.TableQuery;
import com.microsoft.windowsazure.storage.table.TableRequest;
import com.microsoft.windowsazure.storage.table.TableRequestOptions;
import com.microsoft.windowsazure.storage.table.TableResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;

public final class CloudTable {
    private final String name;
    private StorageUri storageUri;
    private CloudTableClient tableServiceClient;

    public String getName() {
        return this.name;
    }

    public CloudTableClient getServiceClient() {
        return this.tableServiceClient;
    }

    public final StorageUri getStorageUri() {
        return this.storageUri;
    }

    public URI getUri() {
        return this.storageUri.getPrimaryUri();
    }

    public CloudTable(String tableName, CloudTableClient client) throws URISyntaxException, StorageException {
        Utility.assertNotNull("client", client);
        Utility.assertNotNull("tableName", tableName);
        this.storageUri = PathUtility.appendPathToUri(client.getStorageUri(), tableName);
        this.name = tableName;
        this.tableServiceClient = client;
        this.parseQueryAndVerify(this.storageUri, client, client.isUsePathStyleUris());
    }

    public CloudTable(URI uri, CloudTableClient client) throws URISyntaxException, StorageException {
        this(new StorageUri(uri, null), client);
    }

    public CloudTable(StorageUri uri, CloudTableClient client) throws URISyntaxException, StorageException {
        Utility.assertNotNull("storageUri", uri);
        this.storageUri = uri;
        boolean usePathStyleUris = client == null ? Utility.determinePathStyleFromUri(this.storageUri.getPrimaryUri(), null) : client.isUsePathStyleUris();
        this.name = PathUtility.getTableNameFromUri(uri.getPrimaryUri(), usePathStyleUris);
        this.tableServiceClient = client;
        this.parseQueryAndVerify(this.storageUri, client, usePathStyleUris);
    }

    @DoesServiceRequest
    public void create() throws StorageException {
        this.create(null, null);
    }

    @DoesServiceRequest
    public void create(TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = TableRequestOptions.applyDefaults(options, this.tableServiceClient);
        Utility.assertNotNullOrEmpty("tableName", this.name);
        DynamicTableEntity tableEntry = new DynamicTableEntity();
        tableEntry.getProperties().put("TableName", new EntityProperty(this.name));
        this.tableServiceClient.execute("Tables", TableOperation.insert(tableEntry), options, opContext);
    }

    @DoesServiceRequest
    public boolean createIfNotExists() throws StorageException {
        return this.createIfNotExists(null, null);
    }

    @DoesServiceRequest
    public boolean createIfNotExists(TableRequestOptions options, OperationContext opContext) throws StorageException {
        boolean exists = this.exists(true, options = TableRequestOptions.applyDefaults(options, this.tableServiceClient), opContext);
        if (exists) {
            return false;
        }
        try {
            this.create(options, opContext);
            return true;
        }
        catch (StorageException e) {
            if (e.getHttpStatusCode() == 409 && "TableAlreadyExists".equals(e.getErrorCode())) {
                return false;
            }
            throw e;
        }
    }

    @DoesServiceRequest
    public void delete() throws StorageException {
        this.delete(null, null);
    }

    @DoesServiceRequest
    public void delete(TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = TableRequestOptions.applyDefaults(options, this.tableServiceClient);
        Utility.assertNotNullOrEmpty("tableName", this.name);
        DynamicTableEntity tableEntry = new DynamicTableEntity();
        tableEntry.getProperties().put("TableName", new EntityProperty(this.name));
        TableOperation delOp = new TableOperation(tableEntry, TableOperationType.DELETE);
        TableResult result = this.tableServiceClient.execute("Tables", delOp, options, opContext);
        if (result.getHttpStatusCode() == 204) {
            return;
        }
        throw new StorageException("OutOfRangeInput", "Unexpected http status code received.", result.getHttpStatusCode(), null, null);
    }

    @DoesServiceRequest
    public boolean deleteIfExists() throws StorageException {
        return this.deleteIfExists(null, null);
    }

    @DoesServiceRequest
    public boolean deleteIfExists(TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (this.exists(true, options = TableRequestOptions.applyDefaults(options, this.tableServiceClient), opContext)) {
            try {
                this.delete(options, opContext);
            }
            catch (StorageException ex) {
                if (ex.getHttpStatusCode() == 404 && StorageErrorCode.RESOURCE_NOT_FOUND.toString().equals(ex.getErrorCode())) {
                    return false;
                }
                throw ex;
            }
            return true;
        }
        return false;
    }

    @DoesServiceRequest
    public ArrayList<TableResult> execute(TableBatchOperation batch) throws StorageException {
        return this.execute(batch, null, null);
    }

    @DoesServiceRequest
    public ArrayList<TableResult> execute(TableBatchOperation batch, TableRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("batch", batch);
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = TableRequestOptions.applyDefaults(options, this.getServiceClient());
        return batch.execute(this.getServiceClient(), this.getName(), options, opContext);
    }

    @DoesServiceRequest
    public TableResult execute(TableOperation operation) throws StorageException {
        return this.execute(operation, null, null);
    }

    @DoesServiceRequest
    public TableResult execute(TableOperation operation, TableRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("operation", operation);
        return operation.execute(this.getServiceClient(), this.getName(), options, opContext);
    }

    @DoesServiceRequest
    public <R> Iterable<R> execute(TableQuery<?> query, EntityResolver<R> resolver) throws StorageException {
        return this.execute(query, resolver, null, null);
    }

    @DoesServiceRequest
    public <R> Iterable<R> execute(TableQuery<?> query, EntityResolver<R> resolver, TableRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("query", query);
        Utility.assertNotNull("Query requires a valid class type or resolver.", resolver);
        query.setSourceTableName(this.getName());
        return this.getServiceClient().generateIteratorForQuery(query, resolver, options, opContext);
    }

    @DoesServiceRequest
    public <T extends TableEntity> Iterable<T> execute(TableQuery<T> query) throws StorageException {
        return this.execute(query, null, null);
    }

    @DoesServiceRequest
    public <T extends TableEntity> Iterable<T> execute(TableQuery<T> query, TableRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("query", query);
        query.setSourceTableName(this.getName());
        return this.getServiceClient().generateIteratorForQuery(query, null, options, opContext);
    }

    @DoesServiceRequest
    public <R> ResultSegment<R> executeSegmented(TableQuery<?> query, EntityResolver<R> resolver, ResultContinuation continuationToken) throws IOException, URISyntaxException, StorageException {
        return this.executeSegmented(query, resolver, continuationToken, null, null);
    }

    @DoesServiceRequest
    public <R> ResultSegment<R> executeSegmented(TableQuery<?> query, EntityResolver<R> resolver, ResultContinuation continuationToken, TableRequestOptions options, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        Utility.assertNotNull("Query requires a valid class type or resolver.", resolver);
        query.setSourceTableName(this.getName());
        return this.getServiceClient().executeQuerySegmentedImpl(query, resolver, continuationToken, options, opContext);
    }

    @DoesServiceRequest
    public <T extends TableEntity> ResultSegment<T> executeSegmented(TableQuery<T> query, ResultContinuation continuationToken) throws IOException, URISyntaxException, StorageException {
        return this.executeSegmented(query, continuationToken, null, null);
    }

    @DoesServiceRequest
    public <T extends TableEntity> ResultSegment<T> executeSegmented(TableQuery<T> query, ResultContinuation continuationToken, TableRequestOptions options, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        Utility.assertNotNull("query", query);
        query.setSourceTableName(this.getName());
        return this.getServiceClient().executeQuerySegmentedImpl(query, null, continuationToken, options, opContext);
    }

    @DoesServiceRequest
    public boolean exists() throws StorageException {
        return this.exists(null, null);
    }

    @DoesServiceRequest
    public boolean exists(TableRequestOptions options, OperationContext opContext) throws StorageException {
        return this.exists(false, options, opContext);
    }

    @DoesServiceRequest
    private boolean exists(boolean primaryOnly, TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = TableRequestOptions.applyDefaults(options, this.tableServiceClient);
        Utility.assertNotNullOrEmpty("tableName", this.name);
        QueryTableOperation operation = (QueryTableOperation)TableOperation.retrieve(this.name, null, DynamicTableEntity.class);
        operation.setPrimaryOnlyRetrieve(primaryOnly);
        TableResult result = this.tableServiceClient.execute("Tables", operation, options, opContext);
        if (result.getHttpStatusCode() == 200) {
            return true;
        }
        if (result.getHttpStatusCode() == 404) {
            return false;
        }
        throw new StorageException("OutOfRangeInput", "Unexpected http status code received.", result.getHttpStatusCode(), null, null);
    }

    @DoesServiceRequest
    public void uploadPermissions(TablePermissions permissions) throws StorageException {
        this.uploadPermissions(permissions, null, null);
    }

    @DoesServiceRequest
    public void uploadPermissions(TablePermissions permissions, TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = TableRequestOptions.applyDefaults(options, this.tableServiceClient);
        ExecutionEngine.executeWithRetry(this.tableServiceClient, this, this.uploadPermissionsImpl(permissions, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudTableClient, CloudTable, Void> uploadPermissionsImpl(TablePermissions permissions, final TableRequestOptions options) throws StorageException {
        StringWriter outBuffer = new StringWriter();
        try {
            SharedAccessPolicySerializer.writeSharedAccessIdentifiersToStream(permissions.getSharedAccessPolicies(), outBuffer);
            final byte[] aclBytes = outBuffer.toString().getBytes("UTF-8");
            StorageRequest<CloudTableClient, CloudTable, Void> putRequest = new StorageRequest<CloudTableClient, CloudTable, Void>((RequestOptions)options, this.getStorageUri()){

                @Override
                public HttpURLConnection buildRequest(CloudTableClient client, CloudTable table, OperationContext context) throws Exception {
                    this.setSendStream(new ByteArrayInputStream(aclBytes));
                    this.setLength(Long.valueOf(aclBytes.length));
                    return TableRequest.setAcl(table.getStorageUri().getUri(this.getCurrentLocation()), options, context);
                }

                @Override
                public void signRequest(HttpURLConnection connection, CloudTableClient client, OperationContext context) throws Exception {
                    StorageRequest.signTableRequest(connection, client, aclBytes.length, context);
                }

                @Override
                public Void preProcessResponse(CloudTable parentObject, CloudTableClient client, OperationContext context) throws Exception {
                    if (this.getResult().getStatusCode() != 204) {
                        this.setNonExceptionedRetryableFailure(true);
                    }
                    return null;
                }
            };
            return putRequest;
        }
        catch (IllegalArgumentException e) {
            StorageException translatedException = StorageException.translateException(null, e, null);
            throw translatedException;
        }
        catch (XMLStreamException e) {
            StorageException translatedException = StorageException.translateException(null, e, null);
            throw translatedException;
        }
        catch (UnsupportedEncodingException e) {
            StorageException translatedException = StorageException.translateException(null, e, null);
            throw translatedException;
        }
    }

    @DoesServiceRequest
    public TablePermissions downloadPermissions() throws StorageException {
        return this.downloadPermissions(null, null);
    }

    @DoesServiceRequest
    public TablePermissions downloadPermissions(TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = TableRequestOptions.applyDefaults(options, this.tableServiceClient);
        return ExecutionEngine.executeWithRetry(this.tableServiceClient, this, this.downloadPermissionsImpl(options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudTableClient, CloudTable, TablePermissions> downloadPermissionsImpl(final TableRequestOptions options) throws StorageException {
        StorageRequest<CloudTableClient, CloudTable, TablePermissions> getRequest = new StorageRequest<CloudTableClient, CloudTable, TablePermissions>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudTableClient client, CloudTable table, OperationContext context) throws Exception {
                return TableRequest.getAcl(table.getStorageUri().getUri(this.getCurrentLocation()), options, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudTableClient client, OperationContext context) throws Exception {
                StorageRequest.signTableRequest(connection, client, -1L, context);
            }

            @Override
            public TablePermissions preProcessResponse(CloudTable parentObject, CloudTableClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return new TablePermissions();
            }

            @Override
            public TablePermissions postProcessResponse(HttpURLConnection connection, CloudTable table, CloudTableClient client, OperationContext context, TablePermissions permissions) throws Exception {
                HashMap<String, SharedAccessTablePolicy> accessIds = SharedAccessPolicyDeserializer.getAccessIdentifiers(this.getConnection().getInputStream(), SharedAccessTablePolicy.class);
                for (String key : accessIds.keySet()) {
                    permissions.getSharedAccessPolicies().put(key, accessIds.get(key));
                }
                return permissions;
            }
        };
        return getRequest;
    }

    public String generateSharedAccessSignature(SharedAccessTablePolicy policy, String accessPolicyIdentifier, String startPartitionKey, String startRowKey, String endPartitionKey, String endRowKey) throws InvalidKeyException, StorageException {
        if (!this.tableServiceClient.getCredentials().canCredentialsSignRequest()) {
            throw new IllegalArgumentException("Cannot create Shared Access Signature unless the Account Key credentials are used by the ServiceClient.");
        }
        String resourceName = this.getSharedAccessCanonicalName();
        String signature = SharedAccessSignatureHelper.generateSharedAccessSignatureHashForTable(policy, accessPolicyIdentifier, resourceName, startPartitionKey, startRowKey, endPartitionKey, endRowKey, this.tableServiceClient, null);
        String accountKeyName = null;
        StorageCredentials credentials = this.tableServiceClient.getCredentials();
        if (credentials instanceof StorageCredentialsAccountAndKey) {
            accountKeyName = ((StorageCredentialsAccountAndKey)credentials).getAccountKeyName();
        }
        UriQueryBuilder builder = SharedAccessSignatureHelper.generateSharedAccessSignatureForTable(policy, startPartitionKey, startRowKey, endPartitionKey, endRowKey, accessPolicyIdentifier, this.name, signature, accountKeyName);
        return builder.toString();
    }

    private String getSharedAccessCanonicalName() {
        String accountName = this.getServiceClient().getCredentials().getAccountName();
        String tableNameLowerCase = this.getName().toLowerCase(Locale.ENGLISH);
        return String.format("/%s/%s", accountName, tableNameLowerCase);
    }

    private void parseQueryAndVerify(StorageUri completeUri, CloudTableClient existingClient, boolean usePathStyleUris) throws URISyntaxException, StorageException {
        Utility.assertNotNull("completeUri", completeUri);
        if (!completeUri.isAbsolute()) {
            String errorMessage = String.format("Address %s is a relative address. Only absolute addresses are permitted.", completeUri.toString());
            throw new IllegalArgumentException(errorMessage);
        }
        this.storageUri = PathUtility.stripURIQueryAndFragment(completeUri);
        HashMap<String, String[]> queryParameters = PathUtility.parseQueryString(completeUri.getQuery());
        StorageCredentialsSharedAccessSignature sasCreds = SharedAccessSignatureHelper.parseQuery(queryParameters);
        if (sasCreds == null) {
            return;
        }
        Boolean sameCredentials = existingClient == null ? false : Utility.areCredentialsEqual(sasCreds, existingClient.getCredentials());
        if (existingClient == null || !sameCredentials.booleanValue()) {
            this.tableServiceClient = new CloudTableClient(new URI(PathUtility.getServiceClientBaseAddress(this.getUri(), usePathStyleUris)), (StorageCredentials)sasCreds);
        }
        if (existingClient != null && !sameCredentials.booleanValue()) {
            this.tableServiceClient.setRetryPolicyFactory(existingClient.getRetryPolicyFactory());
            this.tableServiceClient.setTimeoutInMs(existingClient.getTimeoutInMs());
            this.tableServiceClient.setLocationMode(existingClient.getLocationMode());
            this.tableServiceClient.setTablePayloadFormat(existingClient.getTablePayloadFormat());
        }
    }
}

