/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.core;

import com.microsoft.windowsazure.storage.LeaseDuration;
import com.microsoft.windowsazure.storage.LeaseState;
import com.microsoft.windowsazure.storage.LeaseStatus;
import com.microsoft.windowsazure.storage.core.Utility;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseResponse {
    public static String getContentMD5(HttpURLConnection request) {
        return request.getHeaderField("Content-MD5");
    }

    public static String getDate(HttpURLConnection request) {
        String retString = request.getHeaderField("Date");
        return retString == null ? request.getHeaderField("x-ms-date") : retString;
    }

    public static String getEtag(HttpURLConnection request) {
        return request.getHeaderField("ETag");
    }

    public static HashMap<String, String> getMetadata(HttpURLConnection request) {
        return BaseResponse.getValuesByHeaderPrefix(request, "x-ms-meta-");
    }

    public static String getRequestId(HttpURLConnection request) {
        return request.getHeaderField("x-ms-request-id");
    }

    public static LeaseStatus getLeaseStatus(HttpURLConnection request) {
        String leaseStatus = request.getHeaderField("x-ms-lease-status");
        if (!Utility.isNullOrEmpty(leaseStatus)) {
            return LeaseStatus.parse(leaseStatus);
        }
        return LeaseStatus.UNSPECIFIED;
    }

    public static LeaseState getLeaseState(HttpURLConnection request) {
        String leaseState = request.getHeaderField("x-ms-lease-state");
        if (!Utility.isNullOrEmpty(leaseState)) {
            return LeaseState.parse(leaseState);
        }
        return LeaseState.UNSPECIFIED;
    }

    public static LeaseDuration getLeaseDuration(HttpURLConnection request) {
        String leaseDuration = request.getHeaderField("x-ms-lease-duration");
        if (!Utility.isNullOrEmpty(leaseDuration)) {
            return LeaseDuration.parse(leaseDuration);
        }
        return LeaseDuration.UNSPECIFIED;
    }

    public static String getLeaseID(HttpURLConnection request) {
        return request.getHeaderField("x-ms-lease-id");
    }

    public static String getLeaseTime(HttpURLConnection request) {
        return request.getHeaderField("x-ms-lease-time");
    }

    private static HashMap<String, String> getValuesByHeaderPrefix(HttpURLConnection request, String prefix) {
        HashMap<String, String> retVals = new HashMap<String, String>();
        Map<String, List<String>> headerMap = request.getHeaderFields();
        int prefixLength = prefix.length();
        for (Map.Entry<String, List<String>> entry : headerMap.entrySet()) {
            if (entry.getKey() == null || !entry.getKey().startsWith(prefix)) continue;
            List<String> currHeaderValues = entry.getValue();
            retVals.put(entry.getKey().substring(prefixLength), currHeaderValues.get(0));
        }
        return retVals;
    }

    protected BaseResponse() {
    }
}

