/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.webapp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class IDLFilter
implements Filter {
    public static final String ASSUMED_BASE_ADDRESS_PARAM = "assumed-base-address";
    public static final String MATCH_PREFIX_PARAM = "match-prefix";
    public static final String MATCH_SUFFIX_PARAM = "match-suffix";
    public static final String CONTENT_TYPE_PARAM = "content-type";
    private String matchPrefix = "";
    private String matchSuffix = "";
    private String contentType = "application/xml";
    private String assumedBaseAddress = null;
    private ServletContext servletContext = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        String contentType;
        String matchSuffix;
        String matchPrefix;
        this.assumedBaseAddress = filterConfig.getInitParameter(ASSUMED_BASE_ADDRESS_PARAM);
        if (this.assumedBaseAddress != null) {
            while (this.assumedBaseAddress.endsWith("/")) {
                this.assumedBaseAddress = this.assumedBaseAddress.substring(0, this.assumedBaseAddress.length() - 1);
            }
        }
        if ((matchPrefix = filterConfig.getInitParameter(MATCH_PREFIX_PARAM)) != null) {
            this.matchPrefix = matchPrefix;
        }
        if ((matchSuffix = filterConfig.getInitParameter(MATCH_SUFFIX_PARAM)) != null) {
            this.matchSuffix = matchSuffix;
        }
        if ((contentType = filterConfig.getInitParameter(CONTENT_TYPE_PARAM)) != null) {
            this.contentType = contentType;
        }
        this.servletContext = filterConfig.getServletContext();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        String contextPath;
        HttpServletRequest request;
        StringBuffer requestURI;
        if (this.assumedBaseAddress != null && (requestURI = (request = (HttpServletRequest)servletRequest).getRequestURL()).indexOf(contextPath = request.getContextPath()) >= 0) {
            int splitIndex = requestURI.indexOf(contextPath) + contextPath.length();
            String fullContextPath = requestURI.substring(0, splitIndex);
            String postContextPath = requestURI.substring(splitIndex);
            InputStream wsdlStream = this.getServletContext().getResourceAsStream(postContextPath);
            if (wsdlStream != null) {
                StringBuffer match = new StringBuffer(this.matchPrefix).append(this.assumedBaseAddress).append(this.matchSuffix);
                StringBuffer replacement = new StringBuffer(this.matchPrefix).append(fullContextPath).append(this.matchSuffix);
                BufferedReader reader = new BufferedReader(new InputStreamReader(wsdlStream, "utf-8"));
                String line = reader.readLine();
                servletResponse.setContentType(this.contentType);
                PrintWriter out = servletResponse.getWriter();
                while (line != null) {
                    out.println(line.replace(match, replacement));
                    line = reader.readLine();
                }
                out.flush();
                out.close();
                return;
            }
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }

    public String getMatchPrefix() {
        return this.matchPrefix;
    }

    public void setMatchPrefix(String matchPrefix) {
        this.matchPrefix = matchPrefix;
    }

    public String getMatchSuffix() {
        return this.matchSuffix;
    }

    public void setMatchSuffix(String matchSuffix) {
        this.matchSuffix = matchSuffix;
    }

    public String getAssumedBaseAddress() {
        return this.assumedBaseAddress;
    }

    public void setAssumedBaseAddress(String assumedBaseAddress) {
        this.assumedBaseAddress = assumedBaseAddress;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

