/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg;

import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IParameterProvider;
import pt.webdetails.cgg.CggService;
import pt.webdetails.cpf.SimpleContentGenerator;
import pt.webdetails.cpf.annotations.AccessLevel;
import pt.webdetails.cpf.annotations.Exposed;

public class CggContentGenerator
extends SimpleContentGenerator {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog(CggContentGenerator.class);
    private static final String CCC_VERSION_PARAM = "cccVersion";
    private static final String CCC_VERSION_ANALYZER_4_8 = "2.0-analyzer";

    public String getPluginName() {
        return "cgg";
    }

    @Exposed(accessLevel=AccessLevel.PUBLIC)
    public void Draw(OutputStream out) {
        this.draw(out);
    }

    @Exposed(accessLevel=AccessLevel.PUBLIC)
    public void draw(OutputStream out) {
        IParameterProvider requestParams = (IParameterProvider)this.parameterProviders.get("request");
        String script = requestParams.getStringParameter("script", "");
        String type = requestParams.getStringParameter("type", "svg");
        String outputType = requestParams.getStringParameter("outputType", "png");
        String attachmentName = requestParams.getStringParameter("attachmentName", "");
        String multiChartOverflow = requestParams.getStringParameter("multiChartOverflow", "");
        String widthAsStr = requestParams.getStringParameter("width", "0");
        Long width = 0L;
        try {
            width = Long.parseLong(widthAsStr);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        String heightAsStr = requestParams.getStringParameter("height", "0");
        Long height = 0L;
        try {
            height = Long.parseLong(heightAsStr);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        String cccLibVersion = requestParams.getStringParameter(CCC_VERSION_PARAM, "");
        HttpServletRequest request = this.getRequest();
        HttpServletResponse response = this.getResponse();
        CggService service = new CggService();
        if (response == null) {
            service.setOutputStream(out);
        }
        service.draw(script, type, outputType, attachmentName, multiChartOverflow, cccLibVersion, height, width, response, request);
    }

    @Exposed(accessLevel=AccessLevel.PUBLIC)
    public void refresh(OutputStream out) {
    }
}

