/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.util.Shell;

public final class FileUtils {
    private static final Log LOG;
    static BitSet charToEscape;

    public static Path makeQualified(Path path, Configuration conf) throws IOException {
        if (!path.isAbsolute()) {
            return path.makeQualified(FileSystem.get((Configuration)conf));
        }
        URI fsUri = FileSystem.getDefaultUri((Configuration)conf);
        URI pathUri = path.toUri();
        String scheme = pathUri.getScheme();
        String authority = pathUri.getAuthority();
        if (scheme == null) {
            scheme = fsUri.getScheme();
            authority = fsUri.getAuthority();
            if (authority == null) {
                authority = "";
            }
        } else if (authority == null) {
            authority = scheme.equals(fsUri.getScheme()) && fsUri.getAuthority() != null ? fsUri.getAuthority() : "";
        }
        return new Path(scheme, authority, pathUri.getPath());
    }

    private FileUtils() {
    }

    public static String makePartName(List<String> partCols, List<String> vals) {
        return FileUtils.makePartName(partCols, vals, null);
    }

    public static String makePartName(List<String> partCols, List<String> vals, String defaultStr) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < partCols.size(); ++i) {
            if (i > 0) {
                name.append("/");
            }
            name.append(FileUtils.escapePathName(partCols.get(i).toLowerCase(), defaultStr));
            name.append('=');
            name.append(FileUtils.escapePathName(vals.get(i), defaultStr));
        }
        return name.toString();
    }

    static boolean needsEscaping(char c) {
        return c >= '\u0000' && c < charToEscape.size() && charToEscape.get(c);
    }

    public static String escapePathName(String path) {
        return FileUtils.escapePathName(path, null);
    }

    public static String escapePathName(String path, String defaultPath) {
        if (path == null || path.length() == 0) {
            if (defaultPath == null) {
                return "__HIVE_DEFAULT_PARTITION__";
            }
            return defaultPath;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (FileUtils.needsEscaping(c)) {
                sb.append('%');
                sb.append(String.format("%1$02X", c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unescapePathName(String path) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '%' && i + 2 < path.length()) {
                int code = -1;
                try {
                    code = Integer.valueOf(path.substring(i + 1, i + 3), 16);
                }
                catch (Exception e) {
                    code = -1;
                }
                if (code >= 0) {
                    sb.append((char)code);
                    i += 2;
                    continue;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void listStatusRecursively(FileSystem fs, FileStatus fileStatus, List<FileStatus> results) throws IOException {
        if (fileStatus.isDir()) {
            for (FileStatus stat : fs.listStatus(fileStatus.getPath())) {
                FileUtils.listStatusRecursively(fs, stat, results);
            }
        } else {
            results.add(fileStatus);
        }
    }

    public static String makeDefaultListBucketingDirName(List<String> skewedCols, Configuration hconf) {
        String defaultDir = FileUtils.escapePathName(HiveConf.getVar(hconf, HiveConf.ConfVars.HIVE_LIST_BUCKETING_DEFAULT_DIR_NAME));
        StringBuilder defaultDirPath = new StringBuilder();
        for (int i = 0; i < skewedCols.size(); ++i) {
            if (i > 0) {
                defaultDirPath.append("/");
            }
            defaultDirPath.append(defaultDir);
        }
        String lbDirName = defaultDirPath.toString();
        return lbDirName;
    }

    public static boolean isOwnerOfFileHierarchy(FileSystem fs, FileStatus fileStatus, String userName) throws IOException {
        FileStatus[] childStatuses;
        if (!fileStatus.getOwner().equals(userName)) {
            return false;
        }
        if (!fileStatus.isDir()) {
            return true;
        }
        for (FileStatus childStatus : childStatuses = fs.listStatus(fileStatus.getPath())) {
            if (FileUtils.isOwnerOfFileHierarchy(fs, childStatus, userName)) continue;
            return false;
        }
        return true;
    }

    public static boolean mkdir(FileSystem fs, Path f, boolean inheritPerms, Configuration conf) throws IOException {
        LOG.info((Object)("Creating directory if it doesn't exist: " + f));
        if (!inheritPerms) {
            return fs.mkdirs(f);
        }
        try {
            return fs.getFileStatus(f).isDir();
        }
        catch (FileNotFoundException ignore) {
            Path path = f;
            ArrayList<Path> pathsToSet = new ArrayList<Path>();
            while (!fs.exists(path)) {
                pathsToSet.add(path);
                path = path.getParent();
            }
            boolean success = fs.mkdirs(f);
            if (!success) {
                return false;
            }
            FsPermission parentPerm = fs.getFileStatus(path).getPermission();
            String permString = Integer.toString(parentPerm.toShort(), 8);
            for (Path pathToSet : pathsToSet) {
                LOG.info((Object)("Setting permission of parent directory: " + path.toString() + " on new directory: " + pathToSet.toString()));
                try {
                    FsShell fshell = new FsShell();
                    fshell.setConf(conf);
                    fshell.run(new String[]{"-chmod", "-R", permString, pathToSet.toString()});
                }
                catch (Exception e) {
                    LOG.warn((Object)("Error setting permissions of " + pathToSet), (Throwable)e);
                }
            }
            return true;
        }
    }

    public static boolean copy(FileSystem srcFS, Path src, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite, HiveConf conf) throws IOException {
        boolean copied = FileUtil.copy((FileSystem)srcFS, (Path)src, (FileSystem)dstFS, (Path)dst, (boolean)deleteSource, (boolean)overwrite, (Configuration)conf);
        boolean inheritPerms = conf.getBoolVar(HiveConf.ConfVars.HIVE_WAREHOUSE_SUBDIR_INHERIT_PERMS);
        if (copied && inheritPerms) {
            FileStatus destFileStatus = dstFS.getFileStatus(dst);
            FsPermission perm = destFileStatus.getPermission();
            String permString = Integer.toString(perm.toShort(), 8);
            String group = destFileStatus.getGroup();
            try {
                FsShell fshell = new FsShell();
                fshell.setConf((Configuration)conf);
                fshell.run(new String[]{"-chgrp", "-R", group, dst.toString()});
                fshell.run(new String[]{"-chmod", "-R", permString, dst.toString()});
            }
            catch (Exception e) {
                LOG.warn((Object)("Error setting permissions or group of " + dst), (Throwable)e);
            }
        }
        return copied;
    }

    static {
        char[] clist;
        LOG = LogFactory.getLog((String)FileUtils.class.getName());
        charToEscape = new BitSet(128);
        for (int c = 0; c < 32; c = (int)((char)(c + 1))) {
            charToEscape.set(c);
        }
        for (char c : clist = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\"', '#', '%', '\'', '*', '/', ':', '=', '?', '\\', '\u007f', '{', '[', ']', '^'}) {
            charToEscape.set(c);
        }
        if (Shell.WINDOWS) {
            char[] winClist;
            for (char c : winClist = new char[]{' ', '<', '>', '|'}) {
                charToEscape.set(c);
            }
        }
    }
}

