/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.pig;

import java.util.HashMap;
import org.apache.commons.vfs.FileObject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.pig.JobEntryPigScriptExecutor;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class JobEntryPigScriptExecutorDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static final Class<?> PKG = JobEntryPigScriptExecutor.class;
    public static final String PIG_FILE_EXT = ".pig";
    private Display m_display;
    private boolean m_backupChanged;
    private Text m_wName;
    private Label m_hdfsLab;
    private TextVar m_hdfsHostname;
    private Label m_hdfsPortLab;
    private TextVar m_hdfsPort;
    private Label m_jobTrackerLab;
    private TextVar m_jobTrackerHostname;
    private Label m_jobTrackerPortLab;
    private TextVar m_jobTrackerPort;
    private TextVar m_pigScriptText;
    private Button m_pigScriptBrowseBut;
    private Button m_enableBlockingBut;
    private Button m_localExecutionBut;
    private TableView m_scriptParams;
    protected JobEntryPigScriptExecutor m_jobEntry;
    private boolean m_isMapR = false;

    public JobEntryPigScriptExecutorDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.m_jobEntry = (JobEntryPigScriptExecutor)jobEntryInt;
    }

    public JobEntryInterface open() {
        Shell parent = this.getParent();
        this.m_display = parent.getDisplay();
        this.shell = new Shell(parent, this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage((Shell)this.shell, (JobEntryInterface)this.m_jobEntry);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryPigScriptExecutorDialog.this.m_jobEntry.setChanged();
            }
        };
        this.m_backupChanged = this.m_jobEntry.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText("Pig script executor");
        int middle = this.props.getMiddlePct();
        int margin = 4;
        Label nameLineL = new Label((Composite)this.shell, 131072);
        nameLineL.setText(BaseMessages.getString(PKG, (String)"JobEntryDialog.Title", (String[])new String[0]));
        this.props.setLook((Control)nameLineL);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        nameLineL.setLayoutData((Object)fd);
        this.m_wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.m_wName);
        this.m_wName.addModifyListener(lsMod);
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        this.m_wName.setLayoutData((Object)fd);
        this.m_hdfsLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)this.m_hdfsLab);
        this.m_hdfsLab.setText(BaseMessages.getString(PKG, (String)"JobEntryPigScriptExecutor.HDFSHostname.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_wName, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_hdfsLab.setLayoutData((Object)fd);
        this.m_hdfsHostname = new TextVar((VariableSpace)this.jobMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.m_hdfsHostname);
        this.m_hdfsHostname.addModifyListener(lsMod);
        this.m_hdfsHostname.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryPigScriptExecutorDialog.this.m_hdfsHostname.setToolTipText(JobEntryPigScriptExecutorDialog.this.jobMeta.environmentSubstitute(JobEntryPigScriptExecutorDialog.this.m_hdfsHostname.getText()));
            }
        });
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_wName, margin);
        fd.left = new FormAttachment(middle, 0);
        this.m_hdfsHostname.setLayoutData((Object)fd);
        this.m_hdfsPortLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)this.m_hdfsPortLab);
        this.m_hdfsPortLab.setText(BaseMessages.getString(PKG, (String)"JobEntryPigScriptExecutor.HDFSPort.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_hdfsHostname, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_hdfsPortLab.setLayoutData((Object)fd);
        this.m_hdfsPort = new TextVar((VariableSpace)this.jobMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.m_hdfsPort);
        this.m_hdfsPort.addModifyListener(lsMod);
        this.m_hdfsPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryPigScriptExecutorDialog.this.m_hdfsPort.setToolTipText(JobEntryPigScriptExecutorDialog.this.jobMeta.environmentSubstitute(JobEntryPigScriptExecutorDialog.this.m_hdfsPort.getText()));
            }
        });
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_hdfsHostname, margin);
        fd.left = new FormAttachment(middle, 0);
        this.m_hdfsPort.setLayoutData((Object)fd);
        this.m_jobTrackerLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)this.m_jobTrackerLab);
        this.m_jobTrackerLab.setText(BaseMessages.getString(PKG, (String)"JobEntryPigScriptExecutor.JobtrackerHostname.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_hdfsPort, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_jobTrackerLab.setLayoutData((Object)fd);
        this.m_jobTrackerHostname = new TextVar((VariableSpace)this.jobMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.m_jobTrackerHostname);
        this.m_jobTrackerHostname.addModifyListener(lsMod);
        this.m_jobTrackerHostname.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryPigScriptExecutorDialog.this.m_jobTrackerHostname.setToolTipText(JobEntryPigScriptExecutorDialog.this.jobMeta.environmentSubstitute(JobEntryPigScriptExecutorDialog.this.m_jobTrackerHostname.getText()));
            }
        });
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_hdfsPort, margin);
        fd.left = new FormAttachment(middle, 0);
        this.m_jobTrackerHostname.setLayoutData((Object)fd);
        this.m_jobTrackerPortLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)this.m_jobTrackerPortLab);
        this.m_jobTrackerPortLab.setText(BaseMessages.getString(PKG, (String)"JobEntryPigScriptExecutor.JobtrackerPort.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_jobTrackerHostname, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_jobTrackerPortLab.setLayoutData((Object)fd);
        this.m_jobTrackerPort = new TextVar((VariableSpace)this.jobMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.m_jobTrackerPort);
        this.m_jobTrackerPort.addModifyListener(lsMod);
        this.m_jobTrackerPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryPigScriptExecutorDialog.this.m_jobTrackerPort.setToolTipText(JobEntryPigScriptExecutorDialog.this.jobMeta.environmentSubstitute(JobEntryPigScriptExecutorDialog.this.m_jobTrackerPort.getText()));
            }
        });
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_jobTrackerHostname, margin);
        fd.left = new FormAttachment(middle, 0);
        this.m_jobTrackerPort.setLayoutData((Object)fd);
        Label scriptFileLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)scriptFileLab);
        scriptFileLab.setText(BaseMessages.getString(PKG, (String)"JobEntryPigScriptExecutor.PigScript.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_jobTrackerPort, margin);
        fd.right = new FormAttachment(middle, -margin);
        scriptFileLab.setLayoutData((Object)fd);
        this.m_pigScriptBrowseBut = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.m_pigScriptBrowseBut);
        this.m_pigScriptBrowseBut.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_jobTrackerPort, 0);
        this.m_pigScriptBrowseBut.setLayoutData((Object)fd);
        this.m_pigScriptBrowseBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobEntryPigScriptExecutorDialog.this.openDialog();
            }
        });
        this.m_pigScriptText = new TextVar((VariableSpace)this.jobMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.m_pigScriptText);
        this.m_pigScriptText.addModifyListener(lsMod);
        this.m_pigScriptText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryPigScriptExecutorDialog.this.m_pigScriptText.setToolTipText(JobEntryPigScriptExecutorDialog.this.jobMeta.environmentSubstitute(JobEntryPigScriptExecutorDialog.this.m_pigScriptText.getText()));
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.m_jobTrackerPort, margin);
        fd.right = new FormAttachment((Control)this.m_pigScriptBrowseBut, -margin);
        this.m_pigScriptText.setLayoutData((Object)fd);
        Label enableBlockingLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)enableBlockingLab);
        enableBlockingLab.setText(BaseMessages.getString(PKG, (String)"JobEntryPigScriptExecutor.EnableBlocking.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_pigScriptText, margin);
        fd.right = new FormAttachment(middle, -margin);
        enableBlockingLab.setLayoutData((Object)fd);
        this.m_enableBlockingBut = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.m_enableBlockingBut);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.m_pigScriptText, margin);
        this.m_enableBlockingBut.setLayoutData((Object)fd);
        this.m_enableBlockingBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobEntryPigScriptExecutorDialog.this.m_jobEntry.setChanged();
            }
        });
        Label localExecutionLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)localExecutionLab);
        localExecutionLab.setText(BaseMessages.getString(PKG, (String)"JobEntryPigScriptExecutor.LocalExecution.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_enableBlockingBut, margin);
        fd.right = new FormAttachment(middle, -margin);
        localExecutionLab.setLayoutData((Object)fd);
        this.m_localExecutionBut = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.m_localExecutionBut);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.m_enableBlockingBut, margin);
        this.m_localExecutionBut.setLayoutData((Object)fd);
        this.m_localExecutionBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobEntryPigScriptExecutorDialog.this.m_jobEntry.setChanged();
                JobEntryPigScriptExecutorDialog.this.setEnabledStatus();
            }
        });
        if (this.m_isMapR) {
            this.m_localExecutionBut.setEnabled(false);
            this.m_localExecutionBut.setSelection(false);
            this.m_localExecutionBut.setToolTipText(BaseMessages.getString(PKG, (String)"JobEntryPigScriptExecutor.Warning.MapRLocalExecution", (String[])new String[0]));
            localExecutionLab.setToolTipText(this.m_localExecutionBut.getToolTipText());
        }
        Group paramsGroup = new Group((Composite)this.shell, 16);
        paramsGroup.setText(BaseMessages.getString(PKG, (String)"JobEntryPigScriptExecutor.ScriptParameters.Label", (String[])new String[0]));
        FormLayout paramsLayout = new FormLayout();
        paramsGroup.setLayout((Layout)paramsLayout);
        this.props.setLook((Control)paramsGroup);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.m_localExecutionBut, margin);
        fd.right = new FormAttachment(100, -margin);
        fd.left = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, -margin * 10);
        paramsGroup.setLayoutData((Object)fd);
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"JobEntryPigScriptExecutor.ScriptParameters.ParamterName.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"JobEntryPigScriptExecutor.ScriptParameters.ParamterValue.Label", (String[])new String[0]), 1, false)};
        this.m_scriptParams = new TableView((VariableSpace)this.jobMeta, (Composite)paramsGroup, 65538, colinf, 1, lsMod, this.props);
        fd = new FormData();
        fd.top = new FormAttachment(0, margin);
        fd.right = new FormAttachment(100, -margin);
        fd.left = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, -margin);
        this.m_scriptParams.setLayoutData((Object)fd);
        Button wOK = new Button((Composite)this.shell, 8);
        wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOK, wCancel}, (int)margin, (Control)paramsGroup);
        Listener lsCancel = new Listener(){

            public void handleEvent(Event e) {
                JobEntryPigScriptExecutorDialog.this.cancel();
            }
        };
        Listener lsOK = new Listener(){

            public void handleEvent(Event e) {
                JobEntryPigScriptExecutorDialog.this.ok();
            }
        };
        wOK.addListener(13, lsOK);
        wCancel.addListener(13, lsCancel);
        SelectionAdapter lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JobEntryPigScriptExecutorDialog.this.ok();
            }
        };
        this.m_wName.addSelectionListener((SelectionListener)lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
            }
        });
        this.getData();
        BaseStepDialog.setSize((Shell)this.shell);
        this.shell.open();
        this.props.setDialogSize(this.shell, "JobTransDialogSize");
        while (!this.shell.isDisposed()) {
            if (this.m_display.readAndDispatch()) continue;
            this.m_display.sleep();
        }
        return this.m_jobEntry;
    }

    private void cancel() {
        this.m_jobEntry.setChanged(this.m_backupChanged);
        this.m_jobEntry = null;
        this.dispose();
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    protected void setEnabledStatus() {
        boolean local;
        if (this.m_isMapR) {
            this.m_localExecutionBut.setEnabled(false);
            this.m_localExecutionBut.setSelection(false);
        }
        this.m_hdfsLab.setEnabled(!(local = this.m_localExecutionBut.getSelection()));
        this.m_hdfsHostname.setEnabled(!local);
        this.m_hdfsPortLab.setEnabled(!local);
        this.m_hdfsPort.setEnabled(!local);
        this.m_jobTrackerLab.setEnabled(!local);
        this.m_jobTrackerHostname.setEnabled(!local);
        this.m_jobTrackerPortLab.setEnabled(!local);
        this.m_jobTrackerPort.setEnabled(!local);
    }

    protected void openDialog() {
        FileDialog openDialog = new FileDialog(this.shell, 4096);
        openDialog.setFilterExtensions(new String[]{"*.pig", "*"});
        openDialog.setFilterNames(new String[]{"Pig script files", "All files"});
        String parentFolder = null;
        try {
            parentFolder = KettleVFS.getFilename((FileObject)KettleVFS.getFileObject((String)this.jobMeta.environmentSubstitute(this.jobMeta.getFilename())));
            if (!Const.isEmpty((String)parentFolder)) {
                openDialog.setFileName(parentFolder);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (openDialog.open() != null) {
            this.m_pigScriptText.setText(openDialog.getFilterPath() + System.getProperty("file.separator") + openDialog.getFileName());
        }
    }

    protected void getData() {
        this.m_wName.setText(Const.NVL((String)this.m_jobEntry.getName(), (String)""));
        if (!Const.isEmpty((String)this.m_jobEntry.getHDFSHostname())) {
            this.m_hdfsHostname.setText(this.m_jobEntry.getHDFSHostname());
        }
        if (!Const.isEmpty((String)this.m_jobEntry.getHDFSPort())) {
            this.m_hdfsPort.setText(this.m_jobEntry.getHDFSPort());
        }
        if (!Const.isEmpty((String)this.m_jobEntry.getJobTrackerHostname())) {
            this.m_jobTrackerHostname.setText(this.m_jobEntry.getJobTrackerHostname());
        }
        if (!Const.isEmpty((String)this.m_jobEntry.getJobTrackerPort())) {
            this.m_jobTrackerPort.setText(this.m_jobEntry.getJobTrackerPort());
        }
        this.m_pigScriptText.setText(Const.NVL((String)this.m_jobEntry.getScriptFilename(), (String)""));
        this.m_enableBlockingBut.setSelection(this.m_jobEntry.getEnableBlocking());
        this.m_localExecutionBut.setSelection(this.m_jobEntry.getLocalExecution());
        HashMap<String, String> params = this.m_jobEntry.getScriptParameters();
        if (params.size() > 0) {
            for (String name : params.keySet()) {
                String value = params.get(name);
                TableItem item = new TableItem(this.m_scriptParams.table, 0);
                item.setText(1, name);
                item.setText(2, value);
            }
        }
        this.m_scriptParams.removeEmptyRows();
        this.m_scriptParams.setRowNums();
        this.m_scriptParams.optWidth(true);
        this.setEnabledStatus();
    }

    protected void ok() {
        if (Const.isEmpty((String)this.m_wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.StepJobEntryNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.JobEntryNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.m_jobEntry.setName(this.m_wName.getText());
        this.m_jobEntry.setHDFSHostname(this.m_hdfsHostname.getText());
        this.m_jobEntry.setHDFSPort(this.m_hdfsPort.getText());
        this.m_jobEntry.setJobTrackerHostname(this.m_jobTrackerHostname.getText());
        this.m_jobEntry.setJobTrackerPort(this.m_jobTrackerPort.getText());
        this.m_jobEntry.setScriptFilename(this.m_pigScriptText.getText());
        this.m_jobEntry.setEnableBlocking(this.m_enableBlockingBut.getSelection());
        this.m_jobEntry.setLocalExecution(this.m_localExecutionBut.getSelection());
        int numNonEmpty = this.m_scriptParams.nrNonEmpty();
        HashMap<String, String> params = new HashMap<String, String>();
        if (numNonEmpty > 0) {
            for (int i = 0; i < numNonEmpty; ++i) {
                TableItem item = this.m_scriptParams.getNonEmpty(i);
                String name = item.getText(1).trim();
                String value = item.getText(2).trim();
                params.put(name, value);
            }
        }
        this.m_jobEntry.setScriptParameters(params);
        this.m_jobEntry.setChanged();
        this.dispose();
    }
}

