/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon.s3;

import java.io.OutputStream;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.UserAuthenticator;
import org.apache.commons.vfs.auth.StaticUserAuthenticator;
import org.apache.commons.vfs.impl.DefaultFileSystemConfigBuilder;
import org.pentaho.amazon.s3.S3FileOutputMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutput;

public class S3FileOutput
extends TextFileOutput {
    private FileSystemOptions fsOptions;

    public S3FileOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    protected FileObject getFileObject(String vfsFilename) throws KettleFileException {
        return KettleVFS.getFileObject((String)vfsFilename, (FileSystemOptions)this.getFsOptions());
    }

    protected FileObject getFileObject(String vfsFilename, VariableSpace space) throws KettleFileException {
        return KettleVFS.getFileObject((String)vfsFilename, (VariableSpace)space, (FileSystemOptions)this.getFsOptions());
    }

    protected OutputStream getOutputStream(String vfsFilename, VariableSpace space, boolean append) throws KettleFileException {
        return KettleVFS.getOutputStream((String)vfsFilename, (VariableSpace)space, (FileSystemOptions)this.getFsOptions(), (boolean)append);
    }

    protected FileSystemOptions createFileSystemOptions() throws KettleFileException {
        try {
            FileSystemOptions opts = new FileSystemOptions();
            S3FileOutputMeta s3Meta = (S3FileOutputMeta)this.meta;
            DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(opts, (UserAuthenticator)new StaticUserAuthenticator(null, Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(s3Meta.getAccessKey())), Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(s3Meta.getSecretKey()))));
            return opts;
        }
        catch (FileSystemException e) {
            throw new KettleFileException((Throwable)e);
        }
    }

    protected FileSystemOptions getFsOptions() throws KettleFileException {
        if (this.fsOptions == null) {
            this.fsOptions = this.createFileSystemOptions();
        }
        return this.fsOptions;
    }
}

