/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BaseEngineException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.service.AuthorizationException;
import org.apache.oozie.service.AuthorizationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.JsonRestServlet;
import org.apache.oozie.servlet.ServletUtilities;
import org.apache.oozie.servlet.XServletException;
import org.apache.oozie.util.JobUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public abstract class BaseJobServlet
extends JsonRestServlet {
    private static final JsonRestServlet.ResourceInfo[] RESOURCES_INFO = new JsonRestServlet.ResourceInfo[1];

    public BaseJobServlet(String instrumentationName) {
        super(instrumentationName, RESOURCES_INFO);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String jobId = this.getResourceName(request);
        request.setAttribute("audit.param", (Object)jobId);
        request.setAttribute("audit.operation", (Object)request.getParameter("action"));
        try {
            AuthorizationService auth = Services.get().get(AuthorizationService.class);
            auth.authorizeForJob(this.getUser(request), jobId, true);
        }
        catch (AuthorizationException ex) {
            throw new XServletException(401, ex);
        }
        String action = request.getParameter("action");
        if (action.equals("start")) {
            this.stopCron();
            this.startJob(request, response);
            this.startCron();
            response.setStatus(200);
        } else if (action.equals("resume")) {
            this.stopCron();
            this.resumeJob(request, response);
            this.startCron();
            response.setStatus(200);
        } else if (action.equals("suspend")) {
            this.stopCron();
            this.suspendJob(request, response);
            this.startCron();
            response.setStatus(200);
        } else if (action.equals("kill")) {
            this.stopCron();
            this.killJob(request, response);
            this.startCron();
            response.setStatus(200);
        } else if (action.equals("change")) {
            this.stopCron();
            this.changeJob(request, response);
            this.startCron();
            response.setStatus(200);
        } else if (action.equals("rerun")) {
            this.validateContentType(request, "application/xml");
            XConfiguration conf = new XConfiguration((InputStream)request.getInputStream());
            this.stopCron();
            BaseJobServlet.checkAuthorizationForApp(this.getUser(request), conf);
            JobUtils.normalizeAppPath(conf.get("user.name"), conf.get("group.name"), conf);
            this.reRunJob(request, response, conf);
            this.startCron();
            response.setStatus(200);
        } else if (action.equals("coord-rerun")) {
            this.validateContentType(request, "application/xml");
            this.stopCron();
            JSONObject json = this.reRunJob(request, response, null);
            this.startCron();
            if (json != null) {
                this.sendJsonResponse(response, 200, (JSONStreamAware)json);
            } else {
                response.setStatus(200);
            }
        } else if (action.equals("bundle-rerun")) {
            this.validateContentType(request, "application/xml");
            this.stopCron();
            JSONObject json = this.reRunJob(request, response, null);
            this.startCron();
            if (json != null) {
                this.sendJsonResponse(response, 200, (JSONStreamAware)json);
            } else {
                response.setStatus(200);
            }
        } else {
            throw new XServletException(400, ErrorCode.E0303, "action", action);
        }
    }

    static void checkAuthorizationForApp(String requestUser, Configuration conf) throws XServletException {
        String user = conf.get("user.name");
        String group = conf.get("group.name");
        try {
            if (user == null) {
                throw new XServletException(400, ErrorCode.E0401, "user.name");
            }
            if (!requestUser.equals("?") && !user.equals(requestUser)) {
                throw new XServletException(400, ErrorCode.E0400, requestUser, user);
            }
            AuthorizationService auth = Services.get().get(AuthorizationService.class);
            if (group == null) {
                group = auth.getDefaultGroup(user);
                conf.set("group.name", group);
            } else {
                auth.authorizeForGroup(user, group);
            }
            XLog.Info.get().setParameter("GROUP", group);
            String wfPath = conf.get("oozie.wf.application.path");
            String coordPath = conf.get("oozie.coord.application.path");
            String bundlePath = conf.get("oozie.bundle.application.path");
            if (wfPath == null && coordPath == null && bundlePath == null) {
                String libPath = conf.get("oozie.libpath");
                conf.set("oozie.wf.application.path", libPath);
                wfPath = libPath;
            }
            ServletUtilities.ValidateAppPath(wfPath, coordPath, bundlePath);
            if (wfPath != null) {
                auth.authorizeForApp(user, group, wfPath, "workflow.xml", conf);
            } else if (coordPath != null) {
                auth.authorizeForApp(user, group, coordPath, "coordinator.xml", conf);
            } else if (bundlePath != null) {
                auth.authorizeForApp(user, group, bundlePath, "bundle.xml", conf);
            }
        }
        catch (AuthorizationException ex) {
            XLog.getLog(BaseJobServlet.class).info((Object)"AuthorizationException ", ex);
            throw new XServletException(401, ex);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String jobId = this.getResourceName(request);
        String show = request.getParameter("show");
        try {
            AuthorizationService auth = Services.get().get(AuthorizationService.class);
            auth.authorizeForJob(this.getUser(request), jobId, false);
        }
        catch (AuthorizationException ex) {
            throw new XServletException(401, ex);
        }
        if (show == null || show.equals("info")) {
            this.stopCron();
            JsonBean job = null;
            try {
                job = this.getJob(request, response);
            }
            catch (BaseEngineException e) {
                throw new XServletException(400, e);
            }
            this.startCron();
            this.sendJsonResponse(response, 200, job);
        } else if (show.equals("log")) {
            response.setContentType("text/plain; charset=\"UTF-8\"");
            this.streamJobLog(request, response);
        } else if (show.equals("definition")) {
            this.stopCron();
            response.setContentType("application/xml; charset=\"UTF-8\"");
            String wfDefinition = this.getJobDefinition(request, response);
            this.startCron();
            response.setStatus(200);
            response.getWriter().write(wfDefinition);
        } else {
            throw new XServletException(400, ErrorCode.E0303, "show", show);
        }
    }

    abstract void startJob(HttpServletRequest var1, HttpServletResponse var2) throws XServletException, IOException;

    abstract void resumeJob(HttpServletRequest var1, HttpServletResponse var2) throws XServletException, IOException;

    abstract void suspendJob(HttpServletRequest var1, HttpServletResponse var2) throws XServletException, IOException;

    abstract void killJob(HttpServletRequest var1, HttpServletResponse var2) throws XServletException, IOException;

    abstract void changeJob(HttpServletRequest var1, HttpServletResponse var2) throws XServletException, IOException;

    abstract JSONObject reRunJob(HttpServletRequest var1, HttpServletResponse var2, Configuration var3) throws XServletException, IOException;

    abstract JsonBean getJob(HttpServletRequest var1, HttpServletResponse var2) throws XServletException, IOException, BaseEngineException;

    abstract String getJobDefinition(HttpServletRequest var1, HttpServletResponse var2) throws XServletException, IOException;

    abstract void streamJobLog(HttpServletRequest var1, HttpServletResponse var2) throws XServletException, IOException;

    static {
        BaseJobServlet.RESOURCES_INFO[0] = new JsonRestServlet.ResourceInfo("*", Arrays.asList("PUT", "GET"), Arrays.asList(new JsonRestServlet.ParameterInfo("action", String.class, true, Arrays.asList("PUT")), new JsonRestServlet.ParameterInfo("show", String.class, false, Arrays.asList("GET"))));
    }
}

