/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.IOException;
import java.io.StringReader;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.coord.CoordActionReadyXCommand;
import org.apache.oozie.command.coord.CoordActionTimeOutXCommand;
import org.apache.oozie.command.coord.CoordCommandUtils;
import org.apache.oozie.command.coord.CoordinatorXCommand;
import org.apache.oozie.coord.CoordELEvaluator;
import org.apache.oozie.coord.CoordELFunctions;
import org.apache.oozie.executor.jpa.CoordActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.StatusUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;

public class CoordActionInputCheckXCommand
extends CoordinatorXCommand<Void> {
    private final String actionId;
    private final int COMMAND_REQUEUE_INTERVAL = 60000;
    private CoordinatorActionBean coordAction = null;
    private CoordinatorJobBean coordJob = null;
    private JPAService jpaService = null;

    public CoordActionInputCheckXCommand(String actionId) {
        super("coord_action_input", "coord_action_input", 1);
        this.actionId = ParamChecker.notEmpty(actionId, "actionId");
    }

    @Override
    protected Void execute() throws CommandException {
        this.LOG.info("[" + this.actionId + "]::ActionInputCheck:: Action is in WAITING state.");
        Date nominalTime = this.coordAction.getNominalTime();
        Date currentTime = new Date();
        if (nominalTime.compareTo(currentTime) > 0) {
            this.queue(new CoordActionInputCheckXCommand(this.coordAction.getId()), Math.max(nominalTime.getTime() - currentTime.getTime(), 60000L));
            this.coordAction.setLastModifiedTime(new Date());
            try {
                this.jpaService.execute(new CoordActionUpdateJPAExecutor(this.coordAction));
            }
            catch (JPAExecutorException e) {
                throw new CommandException(e);
            }
            this.LOG.info("[" + this.actionId + "]::ActionInputCheck:: nominal Time is newer than current time, so requeue and wait. Current=" + currentTime + ", nominal=" + nominalTime);
            return null;
        }
        StringBuilder actionXml = new StringBuilder(this.coordAction.getActionXml());
        Instrumentation.Cron cron = new Instrumentation.Cron();
        try {
            XConfiguration actionConf = new XConfiguration(new StringReader(this.coordAction.getRunConf()));
            cron.start();
            StringBuilder existList = new StringBuilder();
            StringBuilder nonExistList = new StringBuilder();
            StringBuilder nonResolvedList = new StringBuilder();
            CoordCommandUtils.getResolvedList(this.coordAction.getMissingDependencies(), nonExistList, nonResolvedList);
            this.LOG.info("[" + this.actionId + "]::CoordActionInputCheck:: Missing deps:" + nonExistList.toString() + " " + nonResolvedList.toString());
            boolean status = this.checkInput(actionXml, existList, nonExistList, actionConf);
            this.coordAction.setLastModifiedTime(currentTime);
            this.coordAction.setActionXml(actionXml.toString());
            if (nonResolvedList.length() > 0 && !status) {
                nonExistList.append(";").append((CharSequence)nonResolvedList);
            }
            this.coordAction.setMissingDependencies(nonExistList.toString());
            if (status) {
                this.coordAction.setStatus(CoordinatorAction.Status.READY);
                this.queue(new CoordActionReadyXCommand(this.coordAction.getJobId()), 100L);
            } else {
                long waitingTime = (currentTime.getTime() - Math.max(this.coordAction.getNominalTime().getTime(), this.coordAction.getCreatedTime().getTime())) / 60000L;
                int timeOut = this.coordAction.getTimeOut();
                if (timeOut >= 0 && waitingTime > (long)timeOut) {
                    this.queue(new CoordActionTimeOutXCommand(this.coordAction), 100L);
                } else {
                    this.queue(new CoordActionInputCheckXCommand(this.coordAction.getId()), 60000L);
                }
            }
            this.coordAction.setLastModifiedTime(new Date());
            this.jpaService.execute(new CoordActionUpdateJPAExecutor(this.coordAction));
        }
        catch (Exception e) {
            throw new CommandException(ErrorCode.E1021, e.getMessage(), e);
        }
        cron.stop();
        return null;
    }

    protected boolean checkInput(StringBuilder actionXml, StringBuilder existList, StringBuilder nonExistList, Configuration conf) throws Exception {
        Element eAction = XmlUtils.parseXml(actionXml.toString());
        boolean allExist = this.checkResolvedUris(eAction, existList, nonExistList, conf);
        if (allExist) {
            this.LOG.debug("[" + this.actionId + "]::ActionInputCheck:: Checking Latest/future");
            allExist = this.checkUnresolvedInstances(eAction, conf);
        }
        if (allExist) {
            this.materializeDataProperties(eAction, conf);
            actionXml.replace(0, actionXml.length(), XmlUtils.prettyPrint(eAction).toString());
        }
        return allExist;
    }

    private void materializeDataProperties(Element eAction, Configuration conf) throws Exception {
        ELEvaluator eval = CoordELEvaluator.createDataEvaluator(eAction, conf, this.actionId);
        Element configElem = eAction.getChild("action", eAction.getNamespace()).getChild("workflow", eAction.getNamespace()).getChild("configuration", eAction.getNamespace());
        if (configElem != null) {
            for (Element propElem : configElem.getChildren("property", configElem.getNamespace())) {
                this.resolveTagContents("value", propElem, eval);
            }
        }
    }

    private void resolveTagContents(String tagName, Element elem, ELEvaluator eval) throws Exception {
        if (elem == null) {
            return;
        }
        Element tagElem = elem.getChild(tagName, elem.getNamespace());
        if (tagElem != null) {
            String updated = CoordELFunctions.evalAndWrap(eval, tagElem.getText());
            tagElem.removeContent();
            tagElem.addContent(updated);
        } else {
            this.LOG.warn(" Value NOT FOUND " + tagName);
        }
    }

    private boolean checkUnresolvedInstances(Element eAction, Configuration actionConf) throws Exception {
        boolean ret;
        String strAction = XmlUtils.prettyPrint(eAction).toString();
        Date nominalTime = DateUtils.parseDateUTC(eAction.getAttributeValue("action-nominal-time"));
        String actualTimeStr = eAction.getAttributeValue("action-actual-time");
        Date actualTime = null;
        if (actualTimeStr == null) {
            this.LOG.debug("Unable to get action-actual-time from action xml, this job is submitted from previous version. Assign current date to actual time, action = " + this.actionId);
            actualTime = new Date();
        } else {
            actualTime = DateUtils.parseDateUTC(actualTimeStr);
        }
        StringBuffer resultedXml = new StringBuffer();
        Element inputList = eAction.getChild("input-events", eAction.getNamespace());
        if (inputList != null && !(ret = this.materializeUnresolvedEvent(inputList.getChildren("data-in", eAction.getNamespace()), nominalTime, actualTime, actionConf))) {
            resultedXml.append(strAction);
            return false;
        }
        Element outputList = eAction.getChild("output-events", eAction.getNamespace());
        if (outputList != null) {
            for (Element dEvent : outputList.getChildren("data-out", eAction.getNamespace())) {
                if (dEvent.getChild("unresolved-instances", dEvent.getNamespace()) == null) continue;
                throw new CommandException(ErrorCode.E1006, "coord:latest()/future()", " not permitted in output-event ");
            }
        }
        return true;
    }

    private boolean materializeUnresolvedEvent(List<Element> eDataEvents, Date nominalTime, Date actualTime, Configuration conf) throws Exception {
        for (Element dEvent : eDataEvents) {
            if (dEvent.getChild("unresolved-instances", dEvent.getNamespace()) == null) continue;
            ELEvaluator eval = CoordELEvaluator.createLazyEvaluator(actualTime, nominalTime, dEvent, conf);
            String uresolvedInstance = dEvent.getChild("unresolved-instances", dEvent.getNamespace()).getTextTrim();
            String[] unresolvedList = uresolvedInstance.split("#");
            StringBuffer resolvedTmp = new StringBuffer();
            for (int i = 0; i < unresolvedList.length; ++i) {
                String ret = CoordELFunctions.evalAndWrap(eval, unresolvedList[i]);
                Boolean isResolved = (Boolean)eval.getVariable("is_resolved");
                if (!isResolved.booleanValue()) {
                    this.LOG.info("[" + this.actionId + "]::Cannot resolve: " + ret);
                    return false;
                }
                if (resolvedTmp.length() > 0) {
                    resolvedTmp.append("#");
                }
                resolvedTmp.append((String)eval.getVariable("resolved_path"));
            }
            if (resolvedTmp.length() > 0) {
                if (dEvent.getChild("uris", dEvent.getNamespace()) != null) {
                    resolvedTmp.append("#").append(dEvent.getChild("uris", dEvent.getNamespace()).getTextTrim());
                    dEvent.removeChild("uris", dEvent.getNamespace());
                }
                Element uriInstance = new Element("uris", dEvent.getNamespace());
                uriInstance.addContent(resolvedTmp.toString());
                dEvent.getContent().add(1, uriInstance);
            }
            dEvent.removeChild("unresolved-instances", dEvent.getNamespace());
        }
        return true;
    }

    private boolean checkResolvedUris(Element eAction, StringBuilder existList, StringBuilder nonExistList, Configuration conf) throws IOException {
        this.LOG.info("[" + this.actionId + "]::ActionInputCheck:: In checkResolvedUris...");
        Element inputList = eAction.getChild("input-events", eAction.getNamespace());
        if (inputList != null) {
            if (nonExistList.length() > 0) {
                this.checkListOfPaths(existList, nonExistList, conf);
            }
            return nonExistList.length() == 0;
        }
        return true;
    }

    private boolean checkListOfPaths(StringBuilder existList, StringBuilder nonExistList, Configuration conf) throws IOException {
        String[] uriList = nonExistList.toString().split("#");
        if (uriList[0] != null) {
            this.LOG.info("[" + this.actionId + "]::ActionInputCheck:: In checkListOfPaths: " + uriList[0] + " is Missing.");
        }
        nonExistList.delete(0, nonExistList.length());
        boolean allExists = true;
        String existSeparator = "";
        String nonExistSeparator = "";
        for (int i = 0; i < uriList.length; ++i) {
            if (allExists) {
                allExists = this.pathExists(uriList[i], conf);
                this.LOG.info("[" + this.actionId + "]::ActionInputCheck:: File:" + uriList[i] + ", Exists? :" + allExists);
            }
            if (allExists) {
                existList.append(existSeparator).append(uriList[i]);
                existSeparator = "#";
                continue;
            }
            nonExistList.append(nonExistSeparator).append(uriList[i]);
            nonExistSeparator = "#";
        }
        return allExists;
    }

    private boolean pathExists(String sPath, Configuration actionConf) throws IOException {
        this.LOG.debug("checking for the file " + sPath);
        Path path = new Path(sPath);
        String user = ParamChecker.notEmpty(actionConf.get("user.name"), "user.name");
        String group = ParamChecker.notEmpty(actionConf.get("group.name"), "group.name");
        try {
            return Services.get().get(HadoopAccessorService.class).createFileSystem(user, group, path.toUri(), new Configuration()).exists(path);
        }
        catch (HadoopAccessorException e) {
            throw new IOException(e);
        }
    }

    private String createURIs(Element event, String instances, StringBuilder unresolvedInstances) throws Exception {
        if (instances == null || instances.length() == 0) {
            return "";
        }
        String[] instanceList = instances.split("#");
        StringBuilder uris = new StringBuilder();
        for (int i = 0; i < instanceList.length; ++i) {
            int funcType = CoordCommandUtils.getFuncType(instanceList[i]);
            if (funcType == CoordCommandUtils.LATEST || funcType == CoordCommandUtils.FUTURE) {
                if (unresolvedInstances.length() > 0) {
                    unresolvedInstances.append("#");
                }
                unresolvedInstances.append(instanceList[i]);
                continue;
            }
            ELEvaluator eval = CoordELEvaluator.createURIELEvaluator(instanceList[i]);
            if (uris.length() > 0) {
                uris.append("#");
            }
            uris.append(CoordELFunctions.evalAndWrap(eval, event.getChild("dataset", event.getNamespace()).getChild("uri-template", event.getNamespace()).getTextTrim()));
        }
        return uris.toString();
    }

    @Override
    protected String getEntityKey() {
        return this.coordAction.getJobId();
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void eagerLoadState() throws CommandException {
        this.loadState();
    }

    @Override
    protected void loadState() throws CommandException {
        if (this.jpaService == null) {
            this.jpaService = Services.get().get(JPAService.class);
        }
        try {
            this.coordAction = this.jpaService.execute(new CoordActionGetJPAExecutor(this.actionId));
            this.coordJob = this.jpaService.execute(new CoordJobGetJPAExecutor(this.coordAction.getJobId()));
        }
        catch (JPAExecutorException je) {
            throw new CommandException(je);
        }
        LogUtils.setLogInfo(this.coordAction, this.logInfo);
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.coordAction.getStatus() != CoordinatorAction.Status.WAITING) {
            throw new PreconditionException(ErrorCode.E1100, "[" + this.actionId + "]::CoordActionInputCheck:: Ignoring action. Should be in WAITING state, but state=" + this.coordAction.getStatus());
        }
        if (StatusUtils.getStatusForCoordActionInputCheck(this.coordJob)) {
            return;
        }
        if (this.coordJob.getStatus() != Job.Status.RUNNING && this.coordJob.getStatus() != Job.Status.PAUSED && this.coordJob.getStatus() != Job.Status.PAUSEDWITHERROR) {
            throw new PreconditionException(ErrorCode.E1100, "[" + this.actionId + "]::CoordActionInputCheck:: Ignoring action." + " Coordinator job is not in RUNNING/PAUSED/PAUSEDWITHERROR state, but state=" + this.coordJob.getStatus());
        }
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.actionId;
    }
}

