/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Comparator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;

public class RegionServerCoprocessorHost
extends CoprocessorHost<RegionServerEnvironment> {
    private RegionServerServices rsServices;

    public RegionServerCoprocessorHost(RegionServerServices rsServices, Configuration conf) {
        this.rsServices = rsServices;
        this.conf = conf;
        this.loadSystemCoprocessors(conf, "hbase.coprocessor.regionserver.classes");
    }

    @Override
    public RegionServerEnvironment createEnvironment(Class<?> implClass, Coprocessor instance, int priority, int sequence, Configuration conf) {
        return new RegionServerEnvironment(implClass, instance, priority, sequence, conf, this.rsServices);
    }

    public void preStop(String message) throws IOException {
        ObserverContext<RegionServerCoprocessorEnvironment> ctx = null;
        for (RegionServerEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionServerObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            ((RegionServerObserver)env.getInstance()).preStopRegionServer(ctx);
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    static class EnvironmentPriorityComparator
    implements Comparator<CoprocessorEnvironment> {
        EnvironmentPriorityComparator() {
        }

        @Override
        public int compare(CoprocessorEnvironment env1, CoprocessorEnvironment env2) {
            if (env1.getPriority() < env2.getPriority()) {
                return -1;
            }
            if (env1.getPriority() > env2.getPriority()) {
                return 1;
            }
            if (env1.getLoadSequence() < env2.getLoadSequence()) {
                return -1;
            }
            if (env1.getLoadSequence() > env2.getLoadSequence()) {
                return 1;
            }
            return 0;
        }
    }

    static class RegionServerEnvironment
    extends CoprocessorHost.Environment
    implements RegionServerCoprocessorEnvironment {
        private RegionServerServices regionServerServices;

        public RegionServerEnvironment(Class<?> implClass, Coprocessor impl, int priority, int seq, Configuration conf, RegionServerServices services) {
            super(impl, priority, seq, conf);
            this.regionServerServices = services;
        }

        @Override
        public RegionServerServices getRegionServerServices() {
            return this.regionServerServices;
        }
    }
}

