/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.HbaseObjectWritable;
import org.apache.hadoop.hbase.ipc.ProtocolSignature;
import org.apache.hadoop.hbase.ipc.VersionedProtocol;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.VersionMismatchException;
import org.apache.hadoop.io.VersionedWritable;

public class Invocation
extends VersionedWritable
implements Configurable {
    protected String methodName;
    protected Class[] parameterClasses;
    protected Object[] parameters;
    protected Configuration conf;
    private long clientVersion;
    private int clientMethodsHash;
    private static byte RPC_VERSION = 1;

    public Invocation() {
    }

    public Invocation(Method method, Class<? extends VersionedProtocol> declaringClass, Object[] parameters) {
        this.methodName = method.getName();
        this.parameterClasses = method.getParameterTypes();
        this.parameters = parameters;
        if (declaringClass.equals(VersionedProtocol.class)) {
            this.clientVersion = 0L;
            this.clientMethodsHash = 0;
        } else {
            try {
                Field versionField = declaringClass.getField("VERSION");
                versionField.setAccessible(true);
                this.clientVersion = versionField.getLong(declaringClass);
            }
            catch (NoSuchFieldException ex) {
                throw new RuntimeException("The " + declaringClass, ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            this.clientMethodsHash = ProtocolSignature.getFingerprint(declaringClass.getMethods());
        }
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class[] getParameterClasses() {
        return this.parameterClasses;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    long getProtocolVersion() {
        return this.clientVersion;
    }

    protected int getClientMethodsHash() {
        return this.clientMethodsHash;
    }

    public long getRpcVersion() {
        return RPC_VERSION;
    }

    public void readFields(DataInput in) throws IOException {
        block3: {
            try {
                super.readFields(in);
                this.methodName = in.readUTF();
                this.clientVersion = in.readLong();
                this.clientMethodsHash = in.readInt();
            }
            catch (VersionMismatchException e) {
                if (!e.toString().endsWith("found v0")) break block3;
                short len = (short)(in.readByte() & 0xFF);
                byte[] buf = new byte[len];
                in.readFully(buf, 0, len);
                this.methodName = new String(buf);
            }
        }
        this.parameters = new Object[in.readInt()];
        this.parameterClasses = new Class[this.parameters.length];
        HbaseObjectWritable objectWritable = new HbaseObjectWritable();
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i] = HbaseObjectWritable.readObject(in, objectWritable, this.conf);
            this.parameterClasses[i] = objectWritable.getDeclaredClass();
        }
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.methodName);
        out.writeLong(this.clientVersion);
        out.writeInt(this.clientMethodsHash);
        out.writeInt(this.parameterClasses.length);
        for (int i = 0; i < this.parameterClasses.length; ++i) {
            HbaseObjectWritable.writeObject(out, this.parameters[i], this.parameterClasses[i], this.conf);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(this.methodName);
        buffer.append("(");
        for (int i = 0; i < this.parameters.length; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.parameters[i] instanceof byte[] ? Bytes.toStringBinary((byte[])this.parameters[i]) : this.parameters[i]);
        }
        buffer.append(")");
        buffer.append(", rpc version=" + RPC_VERSION);
        buffer.append(", client version=" + this.clientVersion);
        buffer.append(", methodsFingerPrint=" + this.clientMethodsHash);
        return buffer.toString();
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public byte getVersion() {
        return RPC_VERSION;
    }
}

