/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.fs;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

public class HFileSystem
extends FilterFileSystem {
    private final FileSystem noChecksumFs;
    private final boolean useHBaseChecksum;

    public HFileSystem(Configuration conf, boolean useHBaseChecksum) throws IOException {
        this.fs = FileSystem.get((Configuration)conf);
        this.useHBaseChecksum = useHBaseChecksum;
        this.fs.initialize(HFileSystem.getDefaultUri((Configuration)conf), conf);
        if (useHBaseChecksum && !(this.fs instanceof LocalFileSystem)) {
            conf = new Configuration(conf);
            conf.setBoolean("dfs.client.read.shortcircuit.skip.checksum", true);
            this.noChecksumFs = HFileSystem.newInstanceFileSystem(conf);
            this.noChecksumFs.setVerifyChecksum(false);
        } else {
            this.noChecksumFs = this.fs;
        }
    }

    public HFileSystem(FileSystem fs) {
        this.fs = fs;
        this.noChecksumFs = fs;
        this.useHBaseChecksum = false;
    }

    public FileSystem getNoChecksumFs() {
        return this.noChecksumFs;
    }

    public FileSystem getBackingFs() throws IOException {
        return this.fs;
    }

    public boolean useHBaseChecksum() {
        return this.useHBaseChecksum;
    }

    public void close() throws IOException {
        super.close();
        if (this.noChecksumFs != this.fs) {
            this.noChecksumFs.close();
        }
    }

    private static FileSystem newInstanceFileSystem(Configuration conf) throws IOException {
        URI uri = FileSystem.getDefaultUri((Configuration)conf);
        FileSystem fs = null;
        Class clazz = conf.getClass("fs." + uri.getScheme() + ".impl", null);
        if (clazz != null) {
            fs = (FileSystem)ReflectionUtils.newInstance((Class)clazz, (Configuration)conf);
            fs.initialize(uri, conf);
        } else {
            Configuration clone = new Configuration(conf);
            clone.setBoolean("fs." + uri.getScheme() + ".impl.disable.cache", true);
            fs = FileSystem.get((URI)uri, (Configuration)clone);
        }
        if (fs == null) {
            throw new IOException("No FileSystem for scheme: " + uri.getScheme());
        }
        return fs;
    }

    public static FileSystem get(Configuration conf) throws IOException {
        return new HFileSystem(conf, true);
    }

    public static FileSystem getLocalFs(Configuration conf) throws IOException {
        return new HFileSystem((FileSystem)FileSystem.getLocal((Configuration)conf));
    }

    public FSDataOutputStream createNonRecursive(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.fs.createNonRecursive(f, overwrite, bufferSize, replication, blockSize, progress);
    }
}

