/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;

public class RandomRowFilter
extends FilterBase {
    protected static final Random random = new Random();
    protected float chance;
    protected boolean filterOutRow;

    public RandomRowFilter() {
    }

    public RandomRowFilter(float chance) {
        this.chance = chance;
    }

    public float getChance() {
        return this.chance;
    }

    public void setChance(float chance) {
        this.chance = chance;
    }

    @Override
    public boolean filterAllRemaining() {
        return false;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue v) {
        if (this.filterOutRow) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        return Filter.ReturnCode.INCLUDE;
    }

    @Override
    public boolean filterRow() {
        return this.filterOutRow;
    }

    @Override
    public boolean filterRowKey(byte[] buffer, int offset, int length) {
        this.filterOutRow = this.chance < 0.0f ? true : (this.chance > 1.0f ? false : !(random.nextFloat() < this.chance));
        return this.filterOutRow;
    }

    @Override
    public void reset() {
        this.filterOutRow = false;
    }

    public void readFields(DataInput in) throws IOException {
        this.chance = in.readFloat();
    }

    public void write(DataOutput out) throws IOException {
        out.writeFloat(this.chance);
    }
}

