/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.util.ArrayList;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;

public class FamilyFilter
extends CompareFilter {
    public FamilyFilter() {
    }

    public FamilyFilter(CompareFilter.CompareOp familyCompareOp, WritableByteArrayComparable familyComparator) {
        super(familyCompareOp, familyComparator);
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue v) {
        byte familyLength = v.getFamilyLength();
        if (familyLength > 0 && this.doCompare(this.compareOp, this.comparator, v.getBuffer(), v.getFamilyOffset(), familyLength)) {
            return Filter.ReturnCode.SKIP;
        }
        return Filter.ReturnCode.INCLUDE;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        ArrayList arguments = CompareFilter.extractArguments(filterArguments);
        CompareFilter.CompareOp compareOp = (CompareFilter.CompareOp)((Object)arguments.get(0));
        WritableByteArrayComparable comparator = (WritableByteArrayComparable)arguments.get(1);
        return new FamilyFilter(compareOp, comparator);
    }
}

