/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.codec.CodecException;
import org.apache.hadoop.hbase.codec.Encoder;

public abstract class BaseEncoder
implements Encoder {
    protected final OutputStream out;
    protected boolean flushed = false;

    public BaseEncoder(OutputStream out) {
        this.out = out;
    }

    @Override
    public abstract void write(KeyValue var1) throws IOException;

    protected void checkFlushed() throws CodecException {
        if (this.flushed) {
            throw new CodecException("Flushed; done");
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.flushed) {
            return;
        }
        this.flushed = true;
        this.out.flush();
    }
}

