/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.client.ScannerTimeoutException;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.DataOutputBuffer;

public class ClientScanner
extends AbstractClientScanner {
    private final Log LOG = LogFactory.getLog(this.getClass());
    protected Scan scan;
    protected boolean closed = false;
    protected HRegionInfo currentRegion = null;
    private ScannerCallable callable = null;
    protected final LinkedList<Result> cache = new LinkedList();
    protected final int caching;
    protected long lastNext;
    protected Result lastResult = null;
    protected ScanMetrics scanMetrics = null;
    protected final long maxScannerResultSize;
    private final HConnection connection;
    private final byte[] tableName;
    private final int scannerTimeout;

    public ClientScanner(Configuration conf, Scan scan, byte[] tableName) throws IOException {
        this(conf, scan, tableName, HConnectionManager.getConnection(conf));
    }

    public ClientScanner(Configuration conf, Scan scan, byte[] tableName, HConnection connection) throws IOException {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Creating scanner over " + Bytes.toString(tableName) + " starting at key '" + Bytes.toStringBinary(scan.getStartRow()) + "'"));
        }
        this.scan = scan;
        this.tableName = tableName;
        this.lastNext = System.currentTimeMillis();
        this.connection = connection;
        this.maxScannerResultSize = conf.getLong(HConstants.HBASE_CLIENT_SCANNER_MAX_RESULT_SIZE_KEY, HConstants.DEFAULT_HBASE_CLIENT_SCANNER_MAX_RESULT_SIZE);
        this.scannerTimeout = (int)conf.getLong(HConstants.HBASE_REGIONSERVER_LEASE_PERIOD_KEY, HConstants.DEFAULT_HBASE_REGIONSERVER_LEASE_PERIOD);
        byte[] enableMetrics = scan.getAttribute(Scan.SCAN_ATTRIBUTES_METRICS_ENABLE);
        if (enableMetrics != null && Bytes.toBoolean(enableMetrics)) {
            this.scanMetrics = new ScanMetrics();
        }
        this.caching = this.scan.getCaching() > 0 ? this.scan.getCaching() : conf.getInt("hbase.client.scanner.caching", 1);
        this.initializeScannerInConstruction();
    }

    protected void initializeScannerInConstruction() throws IOException {
        this.nextScanner(this.caching, false);
    }

    protected HConnection getConnection() {
        return this.connection;
    }

    protected byte[] getTableName() {
        return this.tableName;
    }

    protected Scan getScan() {
        return this.scan;
    }

    protected long getTimestamp() {
        return this.lastNext;
    }

    protected boolean checkScanStopRow(byte[] endKey) {
        byte[] stopRow;
        int cmp;
        return this.scan.getStopRow().length > 0 && (cmp = Bytes.compareTo(stopRow = this.scan.getStopRow(), 0, stopRow.length, endKey, 0, endKey.length)) <= 0;
    }

    private boolean nextScanner(int nbRows, boolean done) throws IOException {
        byte[] localStartKey;
        if (this.callable != null) {
            this.callable.setClose();
            this.callable.withRetries();
            this.callable = null;
        }
        if (this.currentRegion != null) {
            byte[] endKey = this.currentRegion.getEndKey();
            if (endKey == null || Bytes.equals(endKey, HConstants.EMPTY_BYTE_ARRAY) || this.checkScanStopRow(endKey) || done) {
                this.close();
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("Finished with scanning at " + (Object)((Object)this.currentRegion)));
                }
                return false;
            }
            localStartKey = endKey;
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Finished with region " + (Object)((Object)this.currentRegion)));
            }
        } else {
            localStartKey = this.scan.getStartRow();
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Advancing internal scanner to startKey at '" + Bytes.toStringBinary(localStartKey) + "'"));
        }
        try {
            this.callable = this.getScannerCallable(localStartKey, nbRows);
            this.callable.withRetries();
            this.currentRegion = this.callable.getHRegionInfo();
            if (this.scanMetrics != null) {
                this.scanMetrics.countOfRegions.inc();
            }
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        return true;
    }

    protected ScannerCallable getScannerCallable(byte[] localStartKey, int nbRows) {
        this.scan.setStartRow(localStartKey);
        ScannerCallable s = new ScannerCallable(this.getConnection(), this.getTableName(), this.scan, this.scanMetrics);
        s.setCaching(nbRows);
        return s;
    }

    protected void writeScanMetrics() throws IOException {
        if (this.scanMetrics == null) {
            return;
        }
        DataOutputBuffer d = new DataOutputBuffer();
        this.scanMetrics.write((DataOutput)d);
        this.scan.setAttribute(Scan.SCAN_ATTRIBUTES_METRICS_DATA, d.getData());
    }

    @Override
    public Result next() throws IOException {
        if (this.cache.size() == 0 && this.closed) {
            return null;
        }
        if (this.cache.size() == 0) {
            Result[] values = null;
            long remainingResultSize = this.maxScannerResultSize;
            int countdown = this.caching;
            this.callable.setCaching(this.caching);
            boolean skipFirst = false;
            do {
                try {
                    if (skipFirst) {
                        this.callable.setCaching(1);
                        values = (Result[])this.callable.withRetries();
                        this.callable.setCaching(this.caching);
                        skipFirst = false;
                    }
                    values = (Result[])this.callable.withRetries();
                }
                catch (DoNotRetryIOException e) {
                    if (e instanceof UnknownScannerException) {
                        long timeout = this.lastNext + (long)this.scannerTimeout;
                        if (timeout < System.currentTimeMillis()) {
                            long elapsed = System.currentTimeMillis() - this.lastNext;
                            ScannerTimeoutException ex = new ScannerTimeoutException(elapsed + "ms passed since the last invocation, " + "timeout is currently set to " + this.scannerTimeout);
                            ex.initCause(e);
                            throw ex;
                        }
                    } else {
                        Throwable cause = e.getCause();
                        if (cause == null || !(cause instanceof NotServingRegionException) && !(cause instanceof RegionServerStoppedException)) {
                            throw e;
                        }
                    }
                    if (this.lastResult != null) {
                        this.scan.setStartRow(this.lastResult.getRow());
                        skipFirst = true;
                    }
                    this.currentRegion = null;
                    continue;
                }
                long currentTime = System.currentTimeMillis();
                if (this.scanMetrics != null) {
                    this.scanMetrics.sumOfMillisSecBetweenNexts.inc(currentTime - this.lastNext);
                }
                this.lastNext = currentTime;
                if (values == null || values.length <= 0) continue;
                for (Result rs : values) {
                    this.cache.add(rs);
                    for (KeyValue kv : rs.raw()) {
                        remainingResultSize -= kv.heapSize();
                    }
                    --countdown;
                    this.lastResult = rs;
                }
            } while (remainingResultSize > 0L && countdown > 0 && this.nextScanner(countdown, values == null));
        }
        if (this.cache.size() > 0) {
            return this.cache.poll();
        }
        this.writeScanMetrics();
        return null;
    }

    @Override
    public Result[] next(int nbRows) throws IOException {
        Result next;
        ArrayList<Result> resultSets = new ArrayList<Result>(nbRows);
        for (int i = 0; i < nbRows && (next = this.next()) != null; ++i) {
            resultSets.add(next);
        }
        return resultSets.toArray(new Result[resultSets.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.callable != null) {
            this.callable.setClose();
            try {
                this.callable.withRetries();
            }
            catch (IOException e) {
            }
            finally {
                try {
                    this.writeScanMetrics();
                }
                catch (IOException e) {}
            }
            this.callable = null;
        }
        this.closed = true;
    }
}

